/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MSession;
import org.compiere.util.CLogger;
import org.compiere.util.WebInfo;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;

public class WebLogin {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private static final String COOKIE_NAME = "adempiereWebUser";
    private String P_ForwardTo = "ForwardTo";
    private String P_SalesRep_ID = "SalesRep_ID";
    private String P_EMail = "EMail";
    private String P_Password = "Password";
    private String P_Action = "Mode";
    private String LOGIN_RelURL = "/login.jsp";
    private String update_page = "/update.jsp";
    private String message = null;
    private Properties ctx;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private HttpSession session;
    private boolean addressConfirm;
    private String forward;
    private String salesRep;
    private String email;
    private String password;
    private WebUser wu;

    public WebLogin(HttpServletRequest t_request, HttpServletResponse t_response, Properties t_ctx) {
        this.request = t_request;
        this.response = t_response;
        this.ctx = t_ctx;
        if (this.request.getParameter("P_ForwardTo") != null) {
            this.setP_ForwardTo(this.request.getParameter("P_ForwardTo"));
        }
        if (this.request.getParameter("SalesRep_ID") != null) {
            this.setP_SalesRep_ID(this.request.getParameter("SalesRep_ID"));
        }
        if (this.request.getParameter("P_EMail") != null) {
            this.setP_EMail(this.request.getParameter("P_EMail"));
        }
        if (this.request.getParameter("P_Password") != null) {
            this.setP_Password(this.request.getParameter("P_Password"));
        }
        if (this.request.getParameter("P_Action") != null) {
            this.setP_Action(this.request.getParameter("P_Action"));
        }
        if (this.request.getParameter("LOGIN_RelURL") != null) {
            this.setLogin_RelURL(this.request.getParameter("LOGIN_RelURL"));
        }
        if (this.request.getParameter("update_page") != null) {
            this.setLogin_RelURL(this.request.getParameter("update_page"));
        }
    }

    public boolean init() {
        this.session = this.request.getSession(true);
        this.forward = WebUtil.getParameter(this.request, this.P_ForwardTo);
        if (this.forward != null) {
            this.session.setAttribute(this.P_ForwardTo, (Object)this.forward);
        }
        this.salesRep = WebUtil.getParameter(this.request, this.P_SalesRep_ID);
        if (this.salesRep != null) {
            this.session.setAttribute(this.P_SalesRep_ID, (Object)this.salesRep);
        }
        this.email = WebUtil.getParameter(this.request, this.P_EMail);
        if (this.email == null) {
            this.email = "";
        }
        this.email = this.email.trim();
        if (this.email != null) {
            this.session.setAttribute(this.P_EMail, (Object)this.email);
        }
        this.password = WebUtil.getParameter(this.request, this.P_Password);
        if (this.password == null) {
            this.password = "";
        }
        this.password = this.password.trim();
        if (this.session.getAttribute("info") != null) {
            WebInfo wi = (WebInfo)this.session.getAttribute("info");
            this.wu = wi.getWebUser();
        }
        return true;
    }

    public boolean action() throws IOException, ServletException {
        boolean logout;
        String mode = WebUtil.getParameter(this.request, this.P_Action);
        boolean deleteCookie = "deleteCookie".equals(mode);
        if (deleteCookie) {
            this.log.fine("** deleteCookie");
            WebUtil.deleteCookieWebUser(this.request, this.response, COOKIE_NAME);
        }
        if ((logout = "logout".equals(mode)) || deleteCookie) {
            this.log.fine("** logout");
            if (this.session != null) {
                MSession cSession = MSession.get(this.ctx, false);
                if (cSession != null) {
                    cSession.logout();
                }
                this.wu = (WebUser)this.session.getAttribute("webUser");
                if (this.wu != null) {
                    this.wu.logout();
                }
                this.session.removeAttribute("webUser");
                this.session.setMaxInactiveInterval(1);
                this.session.invalidate();
            }
            WebUtil.createForwardPage(this.response, "Logout", "http://" + this.request.getServerName() + "/", 2);
        } else if ("SendEMail".equals(mode)) {
            this.log.info("** send mail");
            this.wu = WebUser.get(this.ctx, this.email);
            if (!this.wu.isEMailValid()) {
                this.wu.setPasswordMessage("EMail not found in system");
            } else {
                this.wu.setPassword();
                String msg = WebUtil.sendEMail(this.request, this.wu, "UP", new Object[]{this.request.getServerName(), this.wu.getName(), WebUtil.getFrom(this.request), this.wu.getPassword()});
                if ("OK".equals(msg)) {
                    this.wu.setPasswordMessage("EMail sent");
                } else {
                    this.wu.setPasswordMessage("Problem sending EMail: " + msg);
                }
            }
            this.forward = this.getLogin_RelURL();
        } else if ("Login".equals(mode)) {
            this.log.info("** login " + this.email + "/" + this.password);
            WebUtil.addCookieWebUser(this.request, this.response, this.email, COOKIE_NAME);
            this.wu = WebUser.get(this.ctx, this.email, this.password, false);
            this.wu.login(this.password);
            if (this.wu.isLoggedIn()) {
                MSession cSession;
                if (this.forward == null || this.forward.equals(this.getLogin_RelURL())) {
                    this.forward = "/index.jsp";
                }
                if ((cSession = MSession.get(this.ctx, this.request.getRemoteAddr(), this.request.getRemoteHost(), this.session.getId())) != null) {
                    cSession.setWebStoreSession(true);
                }
            } else {
                this.forward = this.getLogin_RelURL();
                this.log.fine("- PasswordMessage=" + this.wu.getPasswordMessage());
            }
            if (this.session == null) {
                this.session = this.request.getSession(true);
            }
            this.session.setAttribute("info", (Object)new WebInfo(this.ctx, this.wu));
        } else if ("LoginNew".equals(mode)) {
            this.log.info("** loginNew");
            WebUtil.addCookieWebUser(this.request, this.response, "", COOKIE_NAME);
            this.wu = WebUser.get(this.ctx, "");
            this.forward = this.getLogin_RelURL();
        } else if ("Submit".equals(mode)) {
            this.log.info("** submit " + this.email + "/" + this.password + " - AddrConf=" + this.addressConfirm);
            if (this.wu == null || !this.wu.isLoggedIn() || !this.addressConfirm) {
                this.wu = WebUser.get(this.ctx, this.email, null, false);
            }
            if (this.wu.getAD_User_ID() != 0) {
                boolean passwordChange;
                String passwordNew = WebUtil.getParameter(this.request, "PasswordNew");
                if (passwordNew == null) {
                    passwordNew = "";
                }
                boolean bl = passwordChange = passwordNew.length() > 0 && !passwordNew.equals(this.password);
                if (this.addressConfirm || this.wu.login(this.password)) {
                    MSession cSession;
                    if (this.wu.isLoggedIn() && (cSession = MSession.get(this.ctx, this.request.getRemoteAddr(), this.request.getRemoteHost(), this.session.getId())) != null) {
                        cSession.setWebStoreSession(true);
                    }
                    if (passwordChange) {
                        this.log.fine("- update Pwd " + this.email + ", Old=" + this.password + ", DB=" + this.wu.getPassword() + ", New=" + passwordNew);
                    }
                    if (WebUtil.updateFields(this.request, this.wu, passwordChange)) {
                        if (passwordChange) {
                            this.session.setAttribute("hdrMessage", (Object)"Password changed");
                        }
                    } else {
                        this.forward = this.getLogin_RelURL();
                        this.log.warning(" - update not done");
                    }
                } else {
                    this.forward = this.getLogin_RelURL();
                    this.session.setAttribute("hdrMessage", (Object)"Email/Password not correct");
                    this.log.warning(" - update not confirmed");
                }
            } else {
                this.log.fine("** new " + this.email + "/" + this.password);
                this.wu.setEmail(this.email);
                this.wu.setPassword(this.password);
                if (WebUtil.updateFields(this.request, this.wu, true)) {
                    if (this.wu.login(this.password)) {
                        this.session.setAttribute("info", (Object)new WebInfo(this.ctx, this.wu));
                        MSession cSession = MSession.get(this.ctx, this.request.getRemoteAddr(), this.request.getRemoteHost(), this.session.getId());
                        if (cSession != null) {
                            cSession.setWebStoreSession(true);
                        }
                    } else {
                        this.forward = this.getLogin_RelURL();
                    }
                } else {
                    this.log.fine("- failed - " + this.wu.getSaveErrorMessage() + " - " + this.wu.getPasswordMessage());
                    this.forward = this.getLogin_RelURL();
                }
            }
            if (this.wu != null) {
                this.session.setAttribute("info", (Object)new WebInfo(this.ctx, this.wu));
            }
        } else if ("email".equals(mode)) {
            String email = WebUtil.getParameter(this.request, "EMail");
            if (email == null) {
                email = "";
            }
            email = email.trim();
            String emailNew = WebUtil.getParameter(this.request, "EMailNew");
            if (emailNew == null) {
                emailNew = "";
            }
            email = email.trim();
            if (emailNew.length() == 0 || emailNew.equals(email)) {
                this.setMessage("New EMail invalid.");
                return false;
            }
            if (!WebUtil.isEmailValid(emailNew)) {
                this.setMessage("New EMail invalid.");
                return false;
            }
            this.wu.setEmail(emailNew);
            this.wu.save();
            this.session.setAttribute("hdrMessage", (Object)"EMail Address Changed");
            this.session.setAttribute("info", (Object)new WebInfo(this.ctx, this.wu));
        } else if ("password".equals(mode)) {
            String passwordNew;
            if (this.wu == null) {
                this.log.warning("No web user");
                return false;
            }
            String password = WebUtil.getParameter(this.request, "Password");
            if (password == null) {
                password = "";
            }
            if (!this.wu.login(password = password.trim())) {
                this.setMessage("Email/Password not correct");
                return false;
            }
            MSession cSession = MSession.get(this.ctx, this.request.getRemoteAddr(), this.request.getRemoteHost(), this.session.getId());
            if (cSession != null) {
                cSession.setWebStoreSession(true);
            }
            if ((passwordNew = WebUtil.getParameter(this.request, "PasswordNew")) == null) {
                passwordNew = "";
            }
            password = password.trim();
            if (passwordNew.length() == 0 || passwordNew.equals(password)) {
                this.setMessage("New Password invalid.");
                return false;
            }
            this.wu.setPasswordMessage(null);
            this.wu.setPassword(passwordNew);
            if (this.wu.getPasswordMessage() != null) {
                this.setMessage("New Password invalid.");
                return false;
            }
            this.wu.save();
            this.session.setAttribute("hdrMessage", (Object)"Password Changed");
            this.session.setAttribute("info", (Object)new WebInfo(this.ctx, this.wu));
        } else if ("address".equals(mode)) {
            this.wu.setC_Country_ID(WebUtil.getParamOrNull(this.request, "C_Country_ID"));
            this.wu.setC_Region_ID(WebUtil.getParamOrNull(this.request, "C_Region_ID"));
            this.wu.setRegionName(WebUtil.getParamOrNull(this.request, "RegionName"));
            this.wu.setName(WebUtil.getParamOrNull(this.request, "Name"));
            this.wu.setCompany(WebUtil.getParamOrNull(this.request, "Company"));
            this.wu.setTitle(WebUtil.getParamOrNull(this.request, "Title"));
            this.wu.setAddress(WebUtil.getParamOrNull(this.request, "Address"));
            this.wu.setAddress2(WebUtil.getParamOrNull(this.request, "Address2"));
            this.wu.setCity(WebUtil.getParamOrNull(this.request, "City"));
            this.wu.setPostal(WebUtil.getParamOrNull(this.request, "Postal"));
            this.wu.setPhone(WebUtil.getParamOrNull(this.request, "Phone"));
            this.wu.setFax(WebUtil.getParamOrNull(this.request, "Fax"));
            this.wu.save();
            this.session.setAttribute("hdrMessage", (Object)"Contact Information Changed");
            this.session.setAttribute("info", (Object)new WebInfo(this.ctx, this.wu));
        } else if ("EMailVerify".equals(mode)) {
            if (this.wu == null) {
                this.log.warning("No web user");
                return false;
            }
            this.log.info(this.forward + " - " + this.wu.toString());
            String cmd = WebUtil.getParameter(this.request, "ReSend");
            if (cmd != null && cmd.length() > 1) {
                WebUtil.resendCode(this.request, this.wu);
            } else {
                this.wu.setEMailVerifyCode(WebUtil.getParameter(this.request, "VerifyCode"), this.request.getRemoteAddr());
            }
        } else if ("bankaccountach".equals(mode)) {
            if (this.wu == null) {
                this.log.warning("No web user");
                return false;
            }
            this.log.info(this.forward + " - " + this.wu.toString());
            MBPBankAccount thisBPBankAccount = this.wu.getBankAccount(true);
            thisBPBankAccount.setIsACH(true);
            thisBPBankAccount.setA_City(WebUtil.getParamOrNull(this.request, "A_City"));
            thisBPBankAccount.setA_Name(WebUtil.getParamOrNull(this.request, "A_Name"));
            thisBPBankAccount.setAccountNo(WebUtil.getParamOrNull(this.request, "AccountNo"));
            thisBPBankAccount.setRoutingNo(WebUtil.getParamOrNull(this.request, "RoutingNo"));
            thisBPBankAccount.save();
        } else {
            this.log.log(Level.WARNING, "Unknown request='" + mode + "'");
        }
        return true;
    }

    public void setMessage(String newVal) {
        if (newVal != null) {
            this.message = newVal;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setP_ForwardTo(String newVal) {
        if (newVal != null) {
            this.P_ForwardTo = newVal;
        }
    }

    public String getP_ForwardTo() {
        return this.P_ForwardTo;
    }

    public void setP_EMail(String newVal) {
        if (newVal != null) {
            this.P_EMail = newVal;
        }
    }

    public String getP_EMail() {
        return this.P_EMail;
    }

    public void setP_Password(String newVal) {
        if (newVal != null) {
            this.P_Password = newVal;
        }
    }

    public String getP_Password() {
        return this.P_Password;
    }

    public void setP_SalesRep_ID(String newVal) {
        if (newVal != null) {
            this.P_SalesRep_ID = newVal;
        }
    }

    public String getP_SalesRep_ID() {
        return this.P_SalesRep_ID;
    }

    public void setP_Action(String newVal) {
        if (newVal != null) {
            this.P_Action = newVal;
        }
    }

    public String getP_Action() {
        return this.P_Action;
    }

    public void setLogin_RelURL(String newVal) {
        if (newVal != null) {
            this.LOGIN_RelURL = newVal;
        }
    }

    public String getLogin_RelURL() {
        return this.LOGIN_RelURL;
    }

    public void setUpdate_page(String newVal) {
        if (newVal != null) {
            this.update_page = newVal;
        }
    }

    public String getUpdate_page() {
        return this.update_page;
    }

    public void setForward(String newVal) {
        if (newVal != null) {
            this.forward = newVal;
        }
    }

    public String getForward() {
        return this.forward;
    }

    public String getSalesRep_ID() {
        return this.salesRep;
    }

    public void setAddressConfirm(boolean newVal) {
        this.addressConfirm = newVal;
    }

    public boolean getAddressConfirm() {
        return this.addressConfirm;
    }

    public WebUser getWebUser() {
        return this.wu;
    }
}

