/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.comment;
import org.apache.ecs.xhtml.h3;
import org.apache.ecs.xhtml.hr;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.model.MSystem;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.WebUtil;

public class WebEnv {
    public static boolean DEBUG = true;
    private static CLogger log = CLogger.getCLogger(WebEnv.class);
    public static final String DIR_BASE = "/adempiere";
    private static final String DIR_IMAGE = "images";
    private static final String STYLE_STD = "standard.css";
    private static final String LOGO = "LogoSmall.gif";
    private static final String DIR_STORE = "store";
    public static final String TARGET_CMD = "WCmd";
    public static final String TARGET_MENU = "WMenu";
    public static final String TARGET_WINDOW = "WWindow";
    public static final String TARGET_POPUP = "WPopUp";
    public static final String CHARSET = "UTF-8";
    public static final String ENCODING = "UTF-8";
    public static final String COOKIE_INFO = "adempiereInfo";
    public static final int TIMEOUT = 900;
    private static boolean s_initOK = false;
    public static String NBSP = "&nbsp;";

    public static boolean initWeb(ServletConfig config) {
        if (s_initOK) {
            log.info(config.getServletName());
            return true;
        }
        Enumeration en = config.getInitParameterNames();
        StringBuffer info = new StringBuffer("Servlet Init Parameter: ").append(config.getServletName());
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            String value = config.getInitParameter(name);
            System.setProperty(name, value);
            info.append("\n").append(name).append("=").append(value);
        }
        boolean retValue = WebEnv.initWeb(config.getServletContext());
        log.info(info.toString());
        return retValue;
    }

    public static boolean initWeb(ServletContext context) {
        if (s_initOK) {
            log.info(context.getServletContextName());
            return true;
        }
        Enumeration en = context.getInitParameterNames();
        StringBuffer info = new StringBuffer("Servlet Context Init Parameters: ").append(context.getServletContextName());
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            String value = context.getInitParameter(name);
            System.setProperty(name, value);
            info.append("\n").append(name).append("=").append(value);
        }
        try {
            s_initOK = Adempiere.startup(false);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "startup", ex);
        }
        if (!s_initOK) {
            return false;
        }
        log.info(info.toString());
        Properties ctx = new Properties();
        MClient client = MClient.get(ctx, 0);
        MSystem system = MSystem.get(ctx);
        client.sendEMail(client.getRequestEMail(), "Server started: " + system.getName(), "ServerInfo: " + context.getServerInfo(), null);
        return s_initOK;
    }

    public static String getBaseDirectory(String entry) {
        StringBuffer sb = new StringBuffer(DIR_BASE);
        if (!entry.startsWith("/")) {
            sb.append("/");
        }
        sb.append(entry);
        return sb.toString();
    }

    public static String getImageDirectory(String entry) {
        StringBuffer sb = new StringBuffer(DIR_BASE);
        sb.append("/").append(DIR_IMAGE);
        if (!entry.startsWith("/")) {
            sb.append("/");
        }
        sb.append(entry);
        return sb.toString();
    }

    public static String getStoreDirectory(String entry) {
        StringBuffer sb = new StringBuffer(DIR_BASE);
        sb.append("/").append(DIR_STORE);
        if (!entry.startsWith("/")) {
            sb.append("/");
        }
        sb.append(entry);
        return sb.toString();
    }

    public static String getLogoURL() {
        return WebEnv.getBaseDirectory(LOGO);
    }

    public static img getLogo() {
        return new img(WebEnv.getLogoURL()).setAlign("right").setAlt("&copy; Jorg Janke/adempiere");
    }

    public static String getStylesheetURL() {
        return WebEnv.getBaseDirectory(STYLE_STD);
    }

    public static String getCellContent(Object content) {
        if (content == null) {
            return NBSP;
        }
        String str = content.toString();
        if (str.length() == 0) {
            return NBSP;
        }
        return str;
    }

    public static String getCellContent(int content) {
        return String.valueOf(content);
    }

    public static void dump(ServletConfig config) {
        log.config("ServletConfig " + config.getServletName());
        log.config("- Context=" + config.getServletContext());
        if (!CLogMgt.isLevelFiner()) {
            return;
        }
        boolean first = true;
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            if (first) {
                log.finer("InitParameter:");
            }
            first = false;
            String key = (String)e.nextElement();
            String value = config.getInitParameter(key);
            log.finer("- " + key + " = " + value);
        }
    }

    public static void dump(ServletContext ctx) {
        Object value;
        String key;
        log.config("ServletContext " + ctx.getServletContextName());
        log.config("- ServerInfo=" + ctx.getServerInfo());
        if (!CLogMgt.isLevelFiner()) {
            return;
        }
        boolean first = true;
        Enumeration e = ctx.getInitParameterNames();
        while (e.hasMoreElements()) {
            if (first) {
                log.finer("InitParameter:");
            }
            first = false;
            key = (String)e.nextElement();
            value = ctx.getInitParameter(key);
            log.finer("- " + key + " = " + value);
        }
        first = true;
        e = ctx.getAttributeNames();
        while (e.hasMoreElements()) {
            if (first) {
                log.finer("Attributes:");
            }
            first = false;
            key = (String)e.nextElement();
            value = ctx.getAttribute(key);
            log.finer("- " + key + " = " + value);
        }
    }

    public static void dump(HttpSession session) {
        log.config("Session " + session.getId());
        log.config("- Created=" + new Timestamp(session.getCreationTime()));
        if (!CLogMgt.isLevelFiner()) {
            return;
        }
        boolean first = true;
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            if (first) {
                log.finer("Attributes:");
            }
            first = false;
            String key = (String)e.nextElement();
            Object value = session.getAttribute(key);
            log.finer("- " + key + " = " + value);
        }
    }

    public static void dump(HttpServletRequest request) {
        Object value;
        String key;
        log.config("Request " + request.getProtocol() + " " + request.getMethod());
        if (!CLogMgt.isLevelFiner()) {
            return;
        }
        log.finer("- Server=" + request.getServerName() + ", Port=" + request.getServerPort());
        log.finer("- ContextPath=" + request.getContextPath() + ", ServletPath=" + request.getServletPath() + ", Query=" + request.getQueryString());
        log.finer("- From " + request.getRemoteHost() + "/" + request.getRemoteAddr() + " - User=" + request.getRemoteUser());
        log.finer("- URI=" + request.getRequestURI() + ", URL=" + request.getRequestURL());
        log.finer("- AuthType=" + request.getAuthType());
        log.finer("- Secure=" + request.isSecure());
        log.finer("- PathInfo=" + request.getPathInfo() + " - " + request.getPathTranslated());
        log.finer("- UserPrincipal=" + request.getUserPrincipal());
        boolean first = true;
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            if (first) {
                log.finer("- Header:");
            }
            first = false;
            key = (String)e.nextElement();
            value = request.getHeader(key);
            log.finer("  - " + key + " = " + value);
        }
        first = true;
        try {
            String enc = request.getCharacterEncoding();
            if (enc == null) {
                request.setCharacterEncoding("UTF-8");
            }
        }
        catch (Exception ee) {
            log.log(Level.SEVERE, "Set CharacterEncoding=UTF-8", ee);
        }
        e = request.getParameterNames();
        while (e.hasMoreElements()) {
            if (first) {
                log.finer("- Parameter:");
            }
            first = false;
            key = (String)e.nextElement();
            value = WebUtil.getParameter(request, key);
            log.finer("  - " + key + " = " + (String)value);
        }
        first = true;
        e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            if (first) {
                log.finer("- Attributes:");
            }
            first = false;
            key = (String)e.nextElement();
            value = request.getAttribute(key);
            log.finer("  - " + key + " = " + value);
        }
        Cookie[] ccc = request.getCookies();
        if (ccc != null) {
            for (int i2 = 0; i2 < ccc.length; ++i2) {
                if (i2 == 0) {
                    log.finer("- Cookies:");
                }
                log.finer("  - " + ccc[i2].getName() + ", Domain=" + ccc[i2].getDomain() + ", Path=" + ccc[i2].getPath() + ", MaxAge=" + ccc[i2].getMaxAge());
            }
        }
        log.finer("- Encoding=" + request.getCharacterEncoding());
        log.finer("- Locale=" + request.getLocale());
        first = true;
        e = request.getLocales();
        while (e.hasMoreElements()) {
            if (first) {
                log.finer("- Locales:");
            }
            first = false;
            log.finer("  - " + e.nextElement());
        }
        log.finer("- Class=" + request.getClass().getName());
    }

    public static void addFooter(HttpServletRequest request, HttpServletResponse response, HttpServlet servlet, body body2) {
        body2.addElement((Element)new hr());
        body2.addElement((Element)new comment(" --- Footer Start --- "));
        p footer = new p();
        footer.addElement("2006-11-02: ");
        footer.addElement((Element)new a("javascript:diag_window();", "Window Info"));
        footer.addElement(" - ");
        footer.addElement((Element)new a("javascript:diag_navigator();", "Browser Info"));
        footer.addElement(" - ");
        footer.addElement((Element)new a("javascript:diag_request();", "Request Info"));
        footer.addElement(" - ");
        footer.addElement((Element)new a("javascript:diag_document();", "Document Info"));
        footer.addElement(" - ");
        footer.addElement((Element)new a("javascript:diag_form();", "Form Info"));
        footer.addElement(" - ");
        footer.addElement((Element)new a("javascript:toggle('DEBUG');", "Servlet Info"));
        footer.addElement(" - ");
        footer.addElement((Element)new a("javascript:diag_source();", "Show Source"));
        footer.addElement("\n");
        body2.addElement((Element)footer);
        body2.addElement((Element)new br());
        body2.addElement((Element)WebEnv.getServletInfo(request, response, servlet));
        body2.addElement((Element)new script("hide('DEBUG');"));
        body2.addElement((Element)new comment(" --- Footer End --- "));
    }

    private static table getServletInfo(HttpServletRequest request, HttpServletResponse response, HttpServlet servlet) {
        String attrib;
        String name;
        String name2;
        String name3;
        table table2 = new table();
        table2.setID("DEBUG");
        tr space = new tr().addElement((Element)new td().addElement("."));
        table2.addElement((Element)space);
        table2.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new h3("Request Info"))));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Method")).addElement((Element)new td().addElement(request.getMethod())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Protocol")).addElement((Element)new td().addElement(request.getProtocol())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("URI")).addElement((Element)new td().addElement(request.getRequestURI())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Context Path")).addElement((Element)new td().addElement(request.getContextPath())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Servlet Path")).addElement((Element)new td().addElement(request.getServletPath())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Path Info")).addElement((Element)new td().addElement(request.getPathInfo())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Path Translated")).addElement((Element)new td().addElement(request.getPathTranslated())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Query String")).addElement((Element)new td().addElement(request.getQueryString())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Content Length")).addElement((Element)new td().addElement("" + request.getContentLength())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Content Type")).addElement((Element)new td().addElement(request.getContentType())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Character Encoding")).addElement((Element)new td().addElement(request.getCharacterEncoding())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Locale")).addElement((Element)new td().addElement(request.getLocale().toString())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Schema")).addElement((Element)new td().addElement(request.getScheme())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Server Name")).addElement((Element)new td().addElement(request.getServerName())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Server Port")).addElement((Element)new td().addElement("" + request.getServerPort())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Remote User")).addElement((Element)new td().addElement(request.getRemoteUser())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Remote Address")).addElement((Element)new td().addElement(request.getRemoteAddr())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Remote Host")).addElement((Element)new td().addElement(request.getRemoteHost())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Authorization Type")).addElement((Element)new td().addElement(request.getAuthType())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("User Principal")).addElement((Element)new td().addElement(request.getUserPrincipal() == null ? "" : ((Object)request.getUserPrincipal()).toString())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("IsSecure")).addElement((Element)new td().addElement(request.isSecure() ? "true" : "false")));
        table2.addElement((Element)space);
        table2.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new h3("Request Attributes"))));
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            name3 = e.nextElement().toString();
            String attrib2 = request.getAttribute(name3).toString();
            table2.addElement((Element)new tr().addElement((Element)new td().addElement(name3)).addElement((Element)new td().addElement(attrib2)));
        }
        table2.addElement((Element)space);
        table2.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new h3("Req Parameters"))));
        try {
            String enc = request.getCharacterEncoding();
            if (enc == null) {
                request.setCharacterEncoding("UTF-8");
            }
        }
        catch (Exception ee) {
            log.log(Level.SEVERE, "Set CharacterEncoding=UTF-8", ee);
        }
        e = request.getParameterNames();
        while (e.hasMoreElements()) {
            name3 = (String)e.nextElement();
            String para = WebUtil.getParameter(request, name3);
            table2.addElement((Element)new tr().addElement((Element)new td().addElement(name3)).addElement((Element)new td().addElement(para)));
        }
        table2.addElement((Element)space);
        table2.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new h3("Req Header"))));
        e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            name3 = (String)e.nextElement();
            if (name3.equals("Cockie")) continue;
            String hdr = request.getHeader(name3);
            table2.addElement((Element)new tr().addElement((Element)new td().addElement(name3)).addElement((Element)new td().addElement(hdr)));
        }
        table2.addElement((Element)space);
        table2.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new h3("Req Cookies"))));
        Cookie[] cc = request.getCookies();
        if (cc != null) {
            for (int i2 = 0; i2 < cc.length; ++i2) {
                table2.addElement((Element)new tr().addElement((Element)new td().addElement(cc[i2].getName())).addElement((Element)new td().addElement(cc[i2].getValue())));
                table2.addElement((Element)new tr().addElement((Element)new td().addElement(cc[i2].getName() + ": Comment")).addElement((Element)new td().addElement(cc[i2].getComment())));
                table2.addElement((Element)new tr().addElement((Element)new td().addElement(cc[i2].getName() + ": Domain")).addElement((Element)new td().addElement(cc[i2].getDomain())));
                table2.addElement((Element)new tr().addElement((Element)new td().addElement(cc[i2].getName() + ": Max Age")).addElement((Element)new td().addElement("" + cc[i2].getMaxAge())));
                table2.addElement((Element)new tr().addElement((Element)new td().addElement(cc[i2].getName() + ": Path")).addElement((Element)new td().addElement(cc[i2].getPath())));
                table2.addElement((Element)new tr().addElement((Element)new td().addElement(cc[i2].getName() + ": Is Secure")).addElement((Element)new td().addElement(cc[i2].getSecure() ? "true" : "false")));
                table2.addElement((Element)new tr().addElement((Element)new td().addElement(cc[i2].getName() + ": Version")).addElement((Element)new td().addElement("" + cc[i2].getVersion())));
            }
        }
        table2.addElement((Element)space);
        table2.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new h3("Req Session"))));
        HttpSession session = request.getSession(true);
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Session ID")).addElement((Element)new td().addElement(session.getId())));
        Timestamp ts = new Timestamp(session.getCreationTime());
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Created")).addElement((Element)new td().addElement(ts.toString())));
        ts = new Timestamp(session.getLastAccessedTime());
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Accessed")).addElement((Element)new td().addElement(ts.toString())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Request Session ID")).addElement((Element)new td().addElement(request.getRequestedSessionId())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement(".. via Cookie")).addElement((Element)new td().addElement("" + request.isRequestedSessionIdFromCookie())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement(".. via URL")).addElement((Element)new td().addElement("" + request.isRequestedSessionIdFromURL())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Valid")).addElement((Element)new td().addElement("" + request.isRequestedSessionIdValid())));
        table2.addElement((Element)space);
        table2.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new h3("Session Attributes"))));
        e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            name2 = (String)e.nextElement();
            String attrib3 = session.getAttribute(name2).toString();
            table2.addElement((Element)new tr().addElement((Element)new td().addElement(name2)).addElement((Element)new td().addElement(attrib3)));
        }
        table2.addElement((Element)space);
        table2.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new h3("Response"))));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Buffer Size")).addElement((Element)new td().addElement(String.valueOf(response.getBufferSize()))));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Character Encoding")).addElement((Element)new td().addElement(response.getCharacterEncoding())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Locale")).addElement((Element)new td().addElement(response.getLocale() == null ? "null" : response.getLocale().toString())));
        table2.addElement((Element)space);
        table2.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new h3("Servlet"))));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Name")).addElement((Element)new td().addElement(servlet.getServletName())));
        table2.addElement((Element)new tr().addElement((Element)new td().addElement("Info")).addElement((Element)new td().addElement(servlet.getServletInfo())));
        table2.addElement((Element)space);
        table2.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new h3("Servlet Init Parameter"))));
        e = servlet.getInitParameterNames();
        while (e.hasMoreElements()) {
            name2 = (String)e.nextElement();
            String para = servlet.getInitParameter(name2);
            table2.addElement((Element)new tr().addElement((Element)new td().addElement(name2)).addElement((Element)new td().addElement(para)));
        }
        table2.addElement((Element)space);
        table2.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new h3("Servlet Context"))));
        ServletContext servCtx = servlet.getServletContext();
        e = servCtx.getAttributeNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            attrib = servCtx.getAttribute(name).toString();
            table2.addElement((Element)new tr().addElement((Element)new td().addElement(name)).addElement((Element)new td().addElement(attrib)));
        }
        table2.addElement((Element)space);
        table2.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new h3("Servlet Context Init Parameter"))));
        e = servCtx.getInitParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            attrib = servCtx.getInitParameter(name).toString();
            table2.addElement((Element)new tr().addElement((Element)new td().addElement(name)).addElement((Element)new td().addElement(attrib)));
        }
        return table2;
    }
}

