/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.util.ArrayList;
import java.util.logging.Logger;

public class Trace {
    public static String[] getCallerClasses(Throwable caller, int maxNestLevel) {
        int nestLevel = maxNestLevel;
        if (nestLevel < 1) {
            nestLevel = 99;
        }
        ArrayList<String> list = new ArrayList<String>();
        Throwable t = caller;
        if (t == null) {
            t = new Throwable();
        }
        StackTraceElement[] elements = t.getStackTrace();
        for (int i2 = 0; i2 < elements.length && list.size() <= maxNestLevel; ++i2) {
            String className = elements[i2].getClassName();
            if (className.startsWith("org.compiere.util.Trace") || className.startsWith("java.lang.Throwable")) continue;
            list.add(className);
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static String getCallerClass(int nestLevel) {
        String[] array = Trace.getCallerClasses(null, nestLevel);
        if (array.length < nestLevel) {
            return "";
        }
        return array[nestLevel];
    }

    public static boolean isCalledFrom(String className) {
        if (className == null || className.length() == 0) {
            return false;
        }
        return Trace.getCallerClass(1).indexOf(className) != -1;
    }

    public static void printStack() {
        Trace.printStack(true, true);
    }

    public static void printStack(boolean adempiereOnly, boolean first9only) {
        Throwable t = new Throwable();
        int counter = 0;
        StackTraceElement[] elements = t.getStackTrace();
        for (int i2 = 1; i2 < elements.length; ++i2) {
            if (elements[i2].getClassName().indexOf("util.Trace") != -1 || adempiereOnly && (!adempiereOnly || !elements[i2].getClassName().startsWith("org.compiere"))) continue;
            Logger.global.fine(i2 + ": " + elements[i2]);
            if (first9only && ++counter > 8) break;
        }
    }
}

