/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.model.MClient;
import org.compiere.model.MLookupCache;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.swing.CFrame;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Ini;
import org.compiere.util.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Env {
    private static CLogger s_log = CLogger.getCLogger(Env.class);
    private static Properties s_ctx = new Properties();
    public static final int WINDOW_FIND = 1110;
    public static final int WINDOW_MLOOKUP = 1111;
    public static final int WINDOW_CUSTOMIZE = 1112;
    public static final int WINDOW_INFO = 1113;
    public static final int TAB_INFO = 1113;
    public static final String LANGUAGE = "#AD_Language";
    private static ArrayList<Container> s_windows = new ArrayList(20);
    private static ArrayList<CFrame> s_hiddenWindows = new ArrayList();
    private static boolean s_closingWindows = false;
    public static final BigDecimal ZERO = new BigDecimal(0.0);
    public static final BigDecimal ONE = new BigDecimal(1.0);
    public static final BigDecimal ONEHUNDRED = new BigDecimal(100.0);
    public static final String NL = System.getProperty("line.separator");

    public static void exitEnv(int status) {
        MSession session = MSession.get(Env.getCtx(), false);
        if (session != null) {
            session.logout();
        }
        Env.reset(true);
        s_log.info("");
        CLogMgt.shutdown();
        if (Ini.isClient()) {
            System.exit(status);
        }
    }

    public static void logout() {
        MSession session = MSession.get(Env.getCtx(), false);
        if (session != null) {
            session.logout();
        }
        Env.reset(true);
    }

    public static void reset(boolean finalCall) {
        s_log.info("finalCall=" + finalCall);
        Env.closeWindows();
        s_windows.clear();
        if (finalCall) {
            s_ctx.clear();
        } else {
            Object[] keys = s_ctx.keySet().toArray();
            for (int i2 = 0; i2 < keys.length; ++i2) {
                String tag = keys[i2].toString();
                if (!Character.isDigit(tag.charAt(0))) continue;
                s_ctx.remove(keys[i2]);
            }
        }
        CacheMgt.get().reset();
        DB.closeTarget();
        if (!finalCall) {
            DB.setDBTarget(CConnection.get());
            MRole defaultRole = MRole.getDefault(s_ctx, false);
            if (defaultRole != null) {
                defaultRole.loadAccess(true);
            }
        }
    }

    public static final Properties getCtx() {
        return s_ctx;
    }

    public static void setCtx(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        s_ctx.clear();
        s_ctx = ctx;
    }

    public static void setContext(Properties ctx, String context, String value) {
        if (ctx == null || context == null) {
            return;
        }
        s_log.finer("Context " + context + "==" + value);
        if (value == null || value.length() == 0) {
            ctx.remove(context);
        } else {
            ctx.setProperty(context, value);
        }
    }

    public static void setContext(Properties ctx, String context, Timestamp value) {
        if (ctx == null || context == null) {
            return;
        }
        if (value == null) {
            ctx.remove(context);
            s_log.finer("Context " + context + "==" + value);
        } else {
            String stringValue = value.toString();
            stringValue = stringValue.substring(0, stringValue.length() - 2);
            ctx.setProperty(context, stringValue);
            s_log.finer("Context " + context + "==" + stringValue);
        }
    }

    public static void setContext(Properties ctx, String context, int value) {
        if (ctx == null || context == null) {
            return;
        }
        s_log.finer("Context " + context + "==" + value);
        ctx.setProperty(context, String.valueOf(value));
    }

    public static void setContext(Properties ctx, String context, boolean value) {
        Env.setContext(ctx, context, value ? "Y" : "N");
    }

    public static void setContext(Properties ctx, int WindowNo, String context, String value) {
        if (ctx == null || context == null) {
            return;
        }
        if (WindowNo != 1110 && WindowNo != 1111) {
            s_log.finer("Context(" + WindowNo + ") " + context + "==" + value);
        }
        if (value == null || value.equals("")) {
            ctx.remove(WindowNo + "|" + context);
        } else {
            ctx.setProperty(WindowNo + "|" + context, value);
        }
    }

    public static void setContext(Properties ctx, int WindowNo, String context, Timestamp value) {
        boolean logit;
        if (ctx == null || context == null) {
            return;
        }
        boolean bl = logit = WindowNo != 1110 && WindowNo != 1111;
        if (value == null) {
            ctx.remove(WindowNo + "|" + context);
            s_log.finer("Context(" + WindowNo + ") " + context + "==" + value);
        } else {
            String stringValue = value.toString();
            stringValue = stringValue.substring(0, stringValue.length() - 2);
            ctx.setProperty(WindowNo + "|" + context, stringValue);
            s_log.finer("Context(" + WindowNo + ") " + context + "==" + stringValue);
        }
    }

    public static void setContext(Properties ctx, int WindowNo, String context, int value) {
        if (ctx == null || context == null) {
            return;
        }
        if (WindowNo != 1110 && WindowNo != 1111) {
            s_log.finer("Context(" + WindowNo + ") " + context + "==" + value);
        }
        ctx.setProperty(WindowNo + "|" + context, String.valueOf(value));
    }

    public static void setContext(Properties ctx, int WindowNo, String context, boolean value) {
        Env.setContext(ctx, WindowNo, context, value ? "Y" : "N");
    }

    public static void setContext(Properties ctx, int WindowNo, int TabNo, String context, String value) {
        if (ctx == null || context == null) {
            return;
        }
        if (WindowNo != 1110 && WindowNo != 1111) {
            s_log.finest("Context(" + WindowNo + "," + TabNo + ") " + context + "==" + value);
        }
        if (value == null || value.equals("")) {
            ctx.remove(WindowNo + "|" + TabNo + "|" + context);
        } else {
            ctx.setProperty(WindowNo + "|" + TabNo + "|" + context, value);
        }
    }

    public static void setAutoCommit(Properties ctx, boolean autoCommit) {
        if (ctx == null) {
            return;
        }
        ctx.setProperty("AutoCommit", autoCommit ? "Y" : "N");
    }

    public static void setAutoCommit(Properties ctx, int WindowNo, boolean autoCommit) {
        if (ctx == null) {
            return;
        }
        ctx.setProperty(WindowNo + "|AutoCommit", autoCommit ? "Y" : "N");
    }

    public static void setAutoNew(Properties ctx, boolean autoNew) {
        if (ctx == null) {
            return;
        }
        ctx.setProperty("AutoNew", autoNew ? "Y" : "N");
    }

    public static void setAutoNew(Properties ctx, int WindowNo, boolean autoNew) {
        if (ctx == null) {
            return;
        }
        ctx.setProperty(WindowNo + "|AutoNew", autoNew ? "Y" : "N");
    }

    public static void setSOTrx(Properties ctx, boolean isSOTrx) {
        if (ctx == null) {
            return;
        }
        ctx.setProperty("IsSOTrx", isSOTrx ? "Y" : "N");
    }

    public static String getContext(Properties ctx, String context) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        return ctx.getProperty(context, "");
    }

    public static String getContext(Properties ctx, int WindowNo, String context, boolean onlyWindow) {
        if (ctx == null) {
            throw new IllegalArgumentException("No Ctx");
        }
        if (context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = ctx.getProperty(WindowNo + "|" + context);
        if (s == null) {
            if (context.startsWith("#") || context.startsWith("$")) {
                return Env.getContext(ctx, context);
            }
            if (onlyWindow) {
                return "";
            }
            return Env.getContext(ctx, "#" + context);
        }
        return s;
    }

    public static String getContext(Properties ctx, int WindowNo, String context) {
        return Env.getContext(ctx, WindowNo, context, false);
    }

    public static String getContext(Properties ctx, int WindowNo, int TabNo, String context) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = ctx.getProperty(WindowNo + "|" + TabNo + "|" + context);
        if (s == null) {
            return Env.getContext(ctx, WindowNo, context, false);
        }
        return s;
    }

    public static int getContextAsInt(Properties ctx, String context) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, context);
        if (s.length() == 0) {
            s = Env.getContext(ctx, 0, context, false);
        }
        if (s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            s_log.log(Level.SEVERE, "(" + context + ") = " + s, e);
            return 0;
        }
    }

    public static int getContextAsInt(Properties ctx, int WindowNo, String context) {
        String s = Env.getContext(ctx, WindowNo, context, false);
        if (s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            s_log.log(Level.SEVERE, "(" + context + ") = " + s, e);
            return 0;
        }
    }

    public static int getContextAsInt(Properties ctx, int WindowNo, int TabNo, String context) {
        String s = Env.getContext(ctx, WindowNo, TabNo, context);
        if (s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            s_log.log(Level.SEVERE, "(" + context + ") = " + s, e);
            return 0;
        }
    }

    public static boolean isAutoCommit(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, "AutoCommit");
        return s != null && s.equals("Y");
    }

    public static boolean isAutoCommit(Properties ctx, int WindowNo) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, WindowNo, "AutoCommit", false);
        if (s != null) {
            return s.equals("Y");
        }
        return Env.isAutoCommit(ctx);
    }

    public static boolean isAutoNew(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, "AutoNew");
        return s != null && s.equals("Y");
    }

    public static boolean isAutoNew(Properties ctx, int WindowNo) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, WindowNo, "AutoNew", false);
        if (s != null) {
            return s.equals("Y");
        }
        return Env.isAutoNew(ctx);
    }

    public static boolean isSOTrx(Properties ctx) {
        String s = Env.getContext(ctx, "IsSOTrx");
        return s == null || !s.equals("N");
    }

    public static boolean isSOTrx(Properties ctx, int WindowNo) {
        String s = Env.getContext(ctx, WindowNo, "IsSOTrx", true);
        return s == null || !s.equals("N");
    }

    public static Timestamp getContextAsDate(Properties ctx, String context) {
        return Env.getContextAsDate(ctx, 0, context);
    }

    public static Timestamp getContextAsDate(Properties ctx, int WindowNo, String context) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, WindowNo, context, false);
        if (s == null || s.equals("")) {
            s_log.log(Level.SEVERE, "No value for: " + context);
            return new Timestamp(System.currentTimeMillis());
        }
        if (s.trim().length() == 10) {
            s = s.trim() + " 00:00:00.0";
        } else if (s.indexOf(46) == -1) {
            s = s.trim() + ".0";
        }
        return Timestamp.valueOf(s);
    }

    public static int getAD_Client_ID(Properties ctx) {
        return Env.getContextAsInt(ctx, "#AD_Client_ID");
    }

    public static int getAD_Org_ID(Properties ctx) {
        return Env.getContextAsInt(ctx, "#AD_Org_ID");
    }

    public static int getAD_User_ID(Properties ctx) {
        return Env.getContextAsInt(ctx, "#AD_User_ID");
    }

    public static int getAD_Role_ID(Properties ctx) {
        return Env.getContextAsInt(ctx, "#AD_Role_ID");
    }

    public static String getPreference(Properties ctx, int AD_Window_ID, String context, boolean system) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String retValue = null;
        if (!system) {
            retValue = ctx.getProperty("P" + AD_Window_ID + "|" + context);
            if (retValue == null) {
                retValue = ctx.getProperty("P|" + context);
            }
        } else {
            retValue = ctx.getProperty("#" + context);
            if (retValue == null) {
                retValue = ctx.getProperty("$" + context);
            }
        }
        return retValue == null ? "" : retValue;
    }

    public static boolean isBaseLanguage(Properties ctx, String tableName) {
        return Language.isBaseLanguage(Env.getAD_Language(ctx));
    }

    public static boolean isBaseLanguage(String AD_Language, String tableName) {
        return Language.isBaseLanguage(AD_Language);
    }

    public static boolean isBaseLanguage(Language language, String tableName) {
        return language.isBaseLanguage();
    }

    public static boolean isBaseTranslation(String tableName) {
        return tableName.startsWith("AD") || tableName.equals("C_Country_Trl");
    }

    public static boolean isMultiLingualDocument(Properties ctx) {
        return MClient.get(ctx).isMultiLingualDocument();
    }

    public static String getAD_Language(Properties ctx) {
        String lang;
        if (ctx != null && ((lang = Env.getContext(ctx, LANGUAGE)) != null || lang.length() > 0)) {
            return lang;
        }
        return Language.getBaseAD_Language();
    }

    public static Language getLanguage(Properties ctx) {
        String lang;
        if (ctx != null && ((lang = Env.getContext(ctx, LANGUAGE)) != null || lang.length() > 0)) {
            return Language.getLanguage(lang);
        }
        return Language.getBaseLanguage();
    }

    public static Language getLoginLanguage(Properties ctx) {
        return Language.getLoginLanguage();
    }

    public static void verifyLanguage(Properties ctx, Language language) {
        if (language.isBaseLanguage()) {
            return;
        }
        boolean isSystemLanguage = false;
        ArrayList<String> AD_Languages = new ArrayList<String>();
        String sql = "SELECT DISTINCT AD_Language FROM AD_Message_Trl";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String AD_Language = rs.getString(1);
                if (AD_Language.equals(language.getAD_Language())) {
                    isSystemLanguage = true;
                    break;
                }
                AD_Languages.add(AD_Language);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, "", e);
        }
        if (isSystemLanguage) {
            return;
        }
        if (AD_Languages.size() == 0) {
            s_log.warning("NO System Language - Set to Base " + Language.getBaseAD_Language());
            language.setAD_Language(Language.getBaseAD_Language());
            return;
        }
        for (int i2 = 0; i2 < AD_Languages.size(); ++i2) {
            String langCompare;
            String AD_Language = (String)AD_Languages.get(i2);
            String lang = AD_Language.substring(0, 2);
            if (!lang.equals(langCompare = language.getAD_Language().substring(0, 2))) continue;
            s_log.fine("Found similar Language " + AD_Language);
            language.setAD_Language(AD_Language);
            return;
        }
        s_log.warning("Not System Language=" + language + " - Set to Base Language " + Language.getBaseAD_Language());
        language.setAD_Language(Language.getBaseAD_Language());
    }

    public static String[] getEntireContext(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        Iterator<Object> keyIterator = ctx.keySet().iterator();
        String[] sList = new String[ctx.size()];
        int i2 = 0;
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            sList[i2++] = key.toString() + " == " + ctx.get(key).toString();
        }
        return sList;
    }

    public static String getHeader(Properties ctx, int WindowNo) {
        StringBuffer sb = new StringBuffer();
        if (WindowNo > 0) {
            sb.append(Env.getContext(ctx, WindowNo, "WindowName", false)).append("  ");
        }
        sb.append(Env.getContext(ctx, "#AD_User_Name")).append("@").append(Env.getContext(ctx, "#AD_Client_Name")).append(".").append(Env.getContext(ctx, "#AD_Org_Name")).append(" [").append(CConnection.get().toString()).append("]");
        return sb.toString();
    }

    public static void clearWinContext(Properties ctx, int WindowNo) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        Object[] keys = ctx.keySet().toArray();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            String tag = keys[i2].toString();
            if (!tag.startsWith(WindowNo + "|")) continue;
            ctx.remove(keys[i2]);
        }
        MLookupCache.cacheReset(WindowNo);
        Env.removeWindow(WindowNo);
    }

    public static void clearContext(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        ctx.clear();
    }

    public static String parseContext(Properties ctx, int WindowNo, String value, boolean onlyWindow, boolean ignoreUnparsable) {
        if (value == null || value.length() == 0) {
            return "";
        }
        String inStr = new String(value);
        StringBuffer outStr = new StringBuffer();
        int i2 = inStr.indexOf(64);
        while (i2 != -1) {
            outStr.append(inStr.substring(0, i2));
            inStr = inStr.substring(i2 + 1, inStr.length());
            int j = inStr.indexOf(64);
            if (j < 0) {
                s_log.log(Level.SEVERE, "No second tag: " + inStr);
                return "";
            }
            String token = inStr.substring(0, j);
            String ctxInfo = Env.getContext(ctx, WindowNo, token, onlyWindow);
            if (ctxInfo.length() == 0 && (token.startsWith("#") || token.startsWith("$"))) {
                ctxInfo = Env.getContext(ctx, token);
            }
            if (ctxInfo.length() == 0) {
                s_log.config("No Context Win=" + WindowNo + " for: " + token);
                if (!ignoreUnparsable) {
                    return "";
                }
            } else {
                outStr.append(ctxInfo);
            }
            inStr = inStr.substring(j + 1, inStr.length());
            i2 = inStr.indexOf(64);
        }
        outStr.append(inStr);
        return outStr.toString();
    }

    public static String parseContext(Properties ctx, int WindowNo, String value, boolean onlyWindow) {
        return Env.parseContext(ctx, WindowNo, value, onlyWindow, false);
    }

    public static int createWindowNo(Container win) {
        int retValue = s_windows.size();
        s_windows.add(win);
        return retValue;
    }

    public static int getWindowNo(Container container) {
        if (container == null) {
            return 0;
        }
        JFrame winFrame = Env.getFrame(container);
        if (winFrame == null) {
            return 0;
        }
        for (int i2 = 0; i2 < s_windows.size(); ++i2) {
            JFrame cmpFrame;
            Container cmp = s_windows.get(i2);
            if (cmp == null || !winFrame.equals(cmpFrame = Env.getFrame(cmp))) continue;
            return i2;
        }
        return 0;
    }

    public static JFrame getWindow(int WindowNo) {
        JFrame retValue = null;
        try {
            retValue = Env.getFrame(s_windows.get(WindowNo));
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, e.toString());
        }
        return retValue;
    }

    private static void removeWindow(int WindowNo) {
        if (WindowNo < s_windows.size()) {
            s_windows.set(WindowNo, null);
        }
    }

    public static void clearWinContext(int WindowNo) {
        Env.clearWinContext(s_ctx, WindowNo);
    }

    public static void clearContext() {
        s_ctx.clear();
    }

    public static JFrame getFrame(Container container) {
        for (Container element = container; element != null; element = element.getParent()) {
            if (!(element instanceof JFrame)) continue;
            return (JFrame)element;
        }
        return null;
    }

    public static Graphics getGraphics(Container container) {
        for (Container element = container; element != null; element = element.getParent()) {
            Graphics g = element.getGraphics();
            if (g == null) continue;
            return g;
        }
        return null;
    }

    public static Window getParent(Container container) {
        for (Container element = container; element != null; element = element.getParent()) {
            if (element instanceof JDialog || element instanceof JFrame) {
                return (Window)element;
            }
            if (!(element instanceof Window)) continue;
            return (Window)element;
        }
        return null;
    }

    public static Image getImage(String fileNameInImageDir) {
        URL url = Adempiere.class.getResource("images/" + fileNameInImageDir);
        if (url == null) {
            s_log.log(Level.SEVERE, "Not found: " + fileNameInImageDir);
            return null;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.getImage(url);
    }

    public static ImageIcon getImageIcon(String fileNameInImageDir) {
        URL url = Adempiere.class.getResource("images/" + fileNameInImageDir);
        if (url == null) {
            s_log.log(Level.WARNING, "Not found: " + fileNameInImageDir);
            return null;
        }
        return new ImageIcon(url);
    }

    public static ImageIcon getImageIcon2(String fileName) {
        URL url = Adempiere.class.getResource("images/" + fileName + ".gif");
        if (url == null) {
            url = Adempiere.class.getResource("images/" + fileName + ".png");
        }
        if (url == null) {
            s_log.log(Level.WARNING, "GIF/PNG Not found: " + fileName);
            return null;
        }
        return new ImageIcon(url);
    }

    public static void startBrowser(String url) {
        s_log.info(url);
        String cmd = "explorer ";
        if (!Env.isWindows()) {
            cmd = "netscape ";
        }
        String execute = cmd + url;
        try {
            Runtime.getRuntime().exec(execute);
        }
        catch (Exception e) {
            s_log.severe(execute + " - " + e);
        }
    }

    public static boolean isMac() {
        String osName = System.getProperty("os.name");
        return (osName = osName.toLowerCase()).indexOf("mac") != -1;
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return (osName = osName.toLowerCase()).indexOf("windows") != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hideWindow(CFrame window) {
        if (!Ini.isCacheWindow() || s_closingWindows) {
            return false;
        }
        for (int i2 = 0; i2 < s_hiddenWindows.size(); ++i2) {
            CFrame hidden = s_hiddenWindows.get(i2);
            s_log.info(i2 + ": " + hidden);
            if (hidden.getAD_Window_ID() != window.getAD_Window_ID()) continue;
            return false;
        }
        if (window.getAD_Window_ID() != 0 && s_hiddenWindows.add(window)) {
            window.setVisible(false);
            s_log.info(window.toString());
            if (s_hiddenWindows.size() > 10) {
                CFrame toClose = s_hiddenWindows.remove(0);
                try {
                    s_closingWindows = true;
                    toClose.dispose();
                }
                finally {
                    s_closingWindows = false;
                }
            }
            return true;
        }
        return false;
    }

    public static CFrame showWindow(int AD_Window_ID) {
        for (int i2 = 0; i2 < s_hiddenWindows.size(); ++i2) {
            CFrame hidden = s_hiddenWindows.get(i2);
            if (hidden.getAD_Window_ID() != AD_Window_ID) continue;
            s_hiddenWindows.remove(i2);
            s_log.info(hidden.toString());
            hidden.setVisible(true);
            hidden.toFront();
            return hidden;
        }
        return null;
    }

    static void closeWindows() {
        s_closingWindows = true;
        for (int i2 = 0; i2 < s_hiddenWindows.size(); ++i2) {
            CFrame hidden = s_hiddenWindows.get(i2);
            hidden.dispose();
        }
        s_hiddenWindows.clear();
        s_closingWindows = false;
    }

    public static void sleep(int sec) {
        s_log.info("Start - Seconds=" + sec);
        try {
            Thread.sleep(sec * 1000);
        }
        catch (Exception e) {
            s_log.log(Level.WARNING, "", e);
        }
        s_log.info("End");
    }

    public static Set<Window> updateUI() {
        HashSet<Window> updated = new HashSet<Window>();
        for (Container c : s_windows) {
            Component[] childs;
            JFrame w = Env.getFrame(c);
            if (w == null || updated.contains(w)) continue;
            SwingUtilities.updateComponentTreeUI(w);
            w.validate();
            RepaintManager mgr = RepaintManager.currentManager(w);
            for (Component child : childs = w.getComponents()) {
                if (!(child instanceof JComponent)) continue;
                mgr.markCompletelyDirty((JComponent)child);
            }
            w.repaint();
            updated.add(w);
        }
        for (CFrame w : s_hiddenWindows) {
            Component[] childs;
            if (updated.contains(w)) continue;
            SwingUtilities.updateComponentTreeUI(w);
            w.validate();
            RepaintManager mgr = RepaintManager.currentManager(w);
            for (Component child : childs = w.getComponents()) {
                if (!(child instanceof JComponent)) continue;
                mgr.markCompletelyDirty((JComponent)child);
            }
            w.repaint();
            updated.add(w);
        }
        return updated;
    }

    static {
        s_ctx.put(LANGUAGE, Language.getBaseAD_Language());
    }
}

