/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.RowSet;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import oracle.jdbc.OracleConnection;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.interfaces.Server;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MLanguage;
import org.compiere.model.MRole;
import org.compiere.model.MSequence;
import org.compiere.model.MSystem;
import org.compiere.process.SequenceCheck;
import org.compiere.util.CLogErrorBuffer;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CStatement;
import org.compiere.util.CStatementVO;
import org.compiere.util.DBException;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public final class DB {
    private static CConnection s_cc = null;
    private static Connection[] s_connections = null;
    private static int s_conCacheSize = Ini.isClient() ? 1 : 3;
    private static int s_conCount = 0;
    private static Connection s_connectionRW = null;
    private static Connection s_connectionID = null;
    private static CLogger log = CLogger.getCLogger(DB.class);
    public static final String SQLSTATEMENT_SEPARATOR = "; ";
    private static final char QUOTE = '\'';

    public static boolean afterMigration(Properties ctx) {
        MSystem system = MSystem.get(ctx);
        if (!system.isJustMigrated()) {
            return false;
        }
        log.info("Role");
        String sql = "SELECT * FROM AD_Role";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MRole role = new MRole(ctx, rs, null);
                role.updateAccessRecords();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(1)", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        try {
            Class<?> clazz = Class.forName("org.compiere.MigrateData");
            clazz.newInstance();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Data", e);
        }
        log.info("Language");
        MLanguage.maintain(ctx);
        log.info("Sequence");
        SequenceCheck.validate(ctx);
        log.info("Costing");
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(ctx, 0);
        for (int i2 = 0; i2 < ass.length; ++i2) {
            ass[i2].checkCosting();
            ass[i2].save();
        }
        system.setIsJustMigrated(false);
        return system.save();
    }

    public static void updateMail() {
        String envName = Ini.getAdempiereHome();
        if (envName == null) {
            return;
        }
        File envFile = new File(envName = envName + File.separator + "AdempiereEnv.properties");
        if (!envFile.exists()) {
            return;
        }
        Properties env = new Properties();
        try {
            FileInputStream in = new FileInputStream(envFile);
            env.load(in);
            in.close();
        }
        catch (Exception e) {
            return;
        }
        String updated = env.getProperty("ADEMPIERE_MAIL_UPDATED");
        if (updated != null || updated.equals("Y")) {
            return;
        }
        String server = env.getProperty("ADEMPIERE_MAIL_SERVER");
        if (server == null || server.length() == 0) {
            return;
        }
        String adminEMail = env.getProperty("ADEMPIERE_ADMIN_EMAIL");
        if (adminEMail == null || adminEMail.length() == 0) {
            return;
        }
        String mailUser = env.getProperty("ADEMPIERE_MAIL_USER");
        if (mailUser == null || mailUser.length() == 0) {
            return;
        }
        String mailPassword = env.getProperty("ADEMPIERE_MAIL_PASSWORD");
        StringBuffer sql = new StringBuffer("UPDATE AD_Client SET").append(" SMTPHost=").append(DB.TO_STRING(server)).append(", RequestEMail=").append(DB.TO_STRING(adminEMail)).append(", RequestUser=").append(DB.TO_STRING(mailUser)).append(", RequestUserPW=").append(DB.TO_STRING(mailPassword)).append(", IsSMTPAuthorization='Y' WHERE AD_Client_ID=0");
        int no = DB.executeUpdate(sql.toString(), null);
        sql = new StringBuffer("UPDATE AD_User SET ").append(" EMail=").append(DB.TO_STRING(adminEMail)).append(", EMailUser=").append(DB.TO_STRING(mailUser)).append(", EMailUserPW=").append(DB.TO_STRING(mailUser)).append(" WHERE AD_User_ID IN (0,100)");
        no = DB.executeUpdate(sql.toString(), null);
        try {
            env.setProperty("ADEMPIERE_MAIL_UPDATED", "Y");
            FileOutputStream out = new FileOutputStream(envFile);
            env.store(out, "");
            out.flush();
            out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDBTarget(CConnection cc) {
        if (cc == null) {
            throw new IllegalArgumentException("Connection is NULL");
        }
        if (s_cc != null && s_cc.equals(cc)) {
            return;
        }
        DB.closeTarget();
        if (s_cc == null) {
            s_cc = cc;
        }
        CConnection cConnection = s_cc;
        synchronized (cConnection) {
            s_cc = cc;
            s_connections = null;
            s_connectionRW = null;
            s_connectionID = null;
        }
        s_cc.setDataSource();
        log.config(s_cc + " - DS=" + s_cc.isDataSource());
    }

    public static boolean connect() {
        boolean success = false;
        try {
            boolean bl = success = DB.getConnectionRW() != null;
            if (success) {
                boolean bl2 = success = DB.getConnectionRO() != null;
            }
            if (success) {
                success = DB.getConnectionID() != null;
            }
            s_cc.readInfo(DB.getConnectionRW());
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }

    public static boolean isConnected() {
        boolean success = false;
        CLogErrorBuffer eb = CLogErrorBuffer.get(false);
        if (eb != null && eb.isIssueError()) {
            eb.setIssueError(false);
        } else {
            eb = null;
        }
        try {
            success = DB.getConnectionRW() != null;
        }
        catch (Exception e) {
            success = false;
        }
        if (eb != null) {
            eb.setIssueError(true);
        }
        return success;
    }

    public static Connection getConnectionRW() {
        try {
            if (s_connectionRW != null) {
                if (s_connectionRW.isClosed()) {
                    log.finest("Closed");
                    s_connectionRW = null;
                } else if (s_connectionRW instanceof OracleConnection && ((OracleConnection)s_connectionRW).pingDatabase(1) < 0) {
                    log.warning("No ping");
                    s_connectionRW = null;
                } else if (s_connectionRW.getTransactionIsolation() != 2) {
                    s_connectionRW.setTransactionIsolation(2);
                }
            }
        }
        catch (Exception e) {
            s_connectionRW = null;
        }
        if (s_connectionRW == null) {
            s_connectionRW = s_cc.getConnection(true, 2);
            log.finest("Con=" + s_connectionRW);
        }
        if (s_connectionRW == null) {
            throw new UnsupportedOperationException("No DBConnection");
        }
        return s_connectionRW;
    }

    public static Connection getConnectionID() {
        if (s_connectionID != null) {
            try {
                if (s_connectionID.isClosed()) {
                    s_connectionID = null;
                }
            }
            catch (Exception e) {
                s_connectionID = null;
            }
        }
        if (s_connectionID == null) {
            s_connectionID = s_cc.getConnection(false, 2);
        }
        if (s_connectionID == null) {
            throw new UnsupportedOperationException("No DBConnection");
        }
        log.log(Level.ALL, s_connectionID.toString());
        return s_connectionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnectionRO() {
        try {
            CConnection cConnection = s_cc;
            synchronized (cConnection) {
                if (s_connections == null) {
                    s_connections = DB.createConnections(2);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "RO", e);
        }
        int pos = s_conCount++;
        int connectionNo = pos % s_conCacheSize;
        Connection connection = s_connections[connectionNo];
        try {
            if (connection != null) {
                if (connection.isClosed()) {
                    connection = null;
                } else if (connection instanceof OracleConnection && ((OracleConnection)connection).pingDatabase(1) < 0) {
                    log.warning("No ping #" + connectionNo);
                    connection = null;
                } else {
                    if (!connection.isReadOnly()) {
                        connection.setReadOnly(true);
                    }
                    if (connection.getTransactionIsolation() != 2) {
                        connection.setTransactionIsolation(2);
                    }
                }
            }
        }
        catch (Exception e) {
            log.severe("#" + connectionNo + " - " + e.toString());
            connection = null;
        }
        if (connection == null) {
            log.finest("Replacing connection #" + connectionNo);
            connection = s_cc.getConnection(true, 2);
            try {
                if (connection != null) {
                    connection.setReadOnly(true);
                }
            }
            catch (Exception e) {
                log.severe("Cannot set to R/O - " + e);
            }
            DB.s_connections[connectionNo] = connection;
        }
        if (connection == null) {
            throw new UnsupportedOperationException("DB.getConnectionRO - @NoDBConnection@");
        }
        log.log(Level.ALL, "#" + connectionNo + " - " + connection);
        return connection;
    }

    public static Connection createConnection(boolean autoCommit, int trxLevel) {
        Connection conn = s_cc.getConnection(autoCommit, trxLevel);
        if (CLogMgt.isLevelFinest()) {
            // empty if block
        }
        return conn;
    }

    private static Connection[] createConnections(int trxLevel) {
        log.finest("(" + s_conCacheSize + ") " + s_cc.getConnectionURL() + ", UserID=" + s_cc.getDbUid() + ", TrxLevel=" + CConnection.getTransactionIsolationInfo(trxLevel));
        Connection[] cons = new Connection[s_conCacheSize];
        try {
            for (int i2 = 0; i2 < s_conCacheSize; ++i2) {
                cons[i2] = s_cc.getConnection(true, trxLevel);
                if (cons[i2] != null) continue;
                log.warning("Connection is NULL");
            }
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        return cons;
    }

    public static AdempiereDatabase getDatabase() {
        if (s_cc != null) {
            return s_cc.getDatabase();
        }
        log.severe("No Database Connection");
        return null;
    }

    public static AdempiereDatabase getDatabase(String URL2) {
        return Database.getDatabaseFromURL(URL2);
    }

    public static boolean isOracle() {
        if (s_cc != null) {
            return s_cc.isOracle();
        }
        log.severe("No Database Connection");
        return false;
    }

    public static boolean isDerby() {
        if (s_cc != null) {
            return s_cc.isDerby();
        }
        log.severe("No Database Connection");
        return false;
    }

    public static boolean isPostgreSQL() {
        if (s_cc != null) {
            return s_cc.isPostgreSQL();
        }
        log.severe("No Database");
        return false;
    }

    public static boolean isDB2() {
        if (s_cc != null) {
            return s_cc.isDB2();
        }
        log.severe("No Database");
        return false;
    }

    public static boolean isFyracle() {
        if (s_cc != null) {
            return s_cc.isFyracle();
        }
        log.severe("No Database");
        return false;
    }

    public static String getDatabaseInfo() {
        if (s_cc != null) {
            return s_cc.getDBInfo();
        }
        return "No Database";
    }

    public static boolean isDatabaseOK(Properties ctx) {
        String version = "?";
        String sql = "SELECT Version FROM AD_System";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                version = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Problem with AD_System Table - Run system.sql script - " + e.toString());
            return false;
        }
        log.info("DB_Version=" + version);
        if ("2006-11-02".equals(version)) {
            return true;
        }
        String AD_Message = "DatabaseVersionError";
        String title = Adempiere.getName() + " " + Msg.getMsg(ctx, AD_Message, true);
        String msg = Msg.getMsg(ctx, AD_Message);
        msg = MessageFormat.format(msg, "2006-11-02", version);
        Object[] options = new Object[]{UIManager.get("OptionPane.noButtonText"), "Migrate"};
        int no = JOptionPane.showOptionDialog(null, msg, title, -1, 0, UIManager.getIcon("OptionPane.errorIcon"), options, options[0]);
        if (no == 1) {
            JOptionPane.showMessageDialog(null, "Start RUN_Migrate (in utils)\nSee: http://www.adempiere.com/maintain", title, 1);
            Env.exitEnv(1);
        }
        return false;
    }

    public static void closeTarget() {
        boolean closed = false;
        if (s_connections != null) {
            for (int i2 = 0; i2 < s_conCacheSize; ++i2) {
                try {
                    if (s_connections[i2] != null) {
                        closed = true;
                        s_connections[i2].close();
                    }
                }
                catch (SQLException e) {
                    log.warning("#" + i2 + " - " + e.getMessage());
                }
                DB.s_connections[i2] = null;
            }
        }
        s_connections = null;
        try {
            if (s_connectionRW != null) {
                closed = true;
                s_connectionRW.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "R/W", e);
        }
        s_connectionRW = null;
        try {
            if (s_connectionID != null) {
                s_connectionID.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Id", e);
        }
        s_connectionID = null;
        if (s_cc != null) {
            closed = true;
            s_cc.setDataSource(null);
        }
        s_cc = null;
        if (closed) {
            log.fine("closed");
        }
    }

    public static CallableStatement prepareCall(String RO_SQL) {
        if (RO_SQL == null || RO_SQL.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing - " + RO_SQL);
        }
        String sql = DB.getDatabase().convertStatement(RO_SQL);
        try {
            return DB.getConnectionRO().prepareCall(sql, 1003, 1007);
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
            return null;
        }
    }

    public static CPreparedStatement prepareStatement(String RO_SQL) {
        return DB.prepareStatement(RO_SQL, 1003, 1007, null);
    }

    public static CPreparedStatement prepareStatement(String RO_SQL, String trxName) {
        return DB.prepareStatement(RO_SQL, 1003, 1007, trxName);
    }

    public static CPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        return DB.prepareStatement(sql, resultSetType, resultSetConcurrency, null);
    }

    public static CPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, String trxName) {
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException("No SQL");
        }
        return new CPreparedStatement(resultSetType, resultSetConcurrency, sql, trxName);
    }

    public static Statement createStatement() {
        return DB.createStatement(1003, 1007, null);
    }

    public static Statement createStatement(int resultSetType, int resultSetConcurrency, String trxName) {
        return new CStatement(resultSetType, resultSetConcurrency, trxName);
    }

    public static int executeUpdate(String sql) {
        return DB.executeUpdate(sql, null, false, null);
    }

    public static int executeUpdate(String sql, String trxName) {
        return DB.executeUpdate(sql, null, false, trxName);
    }

    public static int executeUpdate(String sql, boolean ignoreError) {
        return DB.executeUpdate(sql, null, ignoreError, null);
    }

    public static int executeUpdate(String sql, boolean ignoreError, String trxName) {
        return DB.executeUpdate(sql, null, ignoreError, trxName);
    }

    public static int executeUpdate(String sql, int param, String trxName) {
        return DB.executeUpdate(sql, new Object[]{new Integer(param)}, false, trxName);
    }

    public static int executeUpdate(String sql, int param, boolean ignoreError, String trxName) {
        return DB.executeUpdate(sql, new Object[]{new Integer(param)}, ignoreError, trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String sql, Object[] params, boolean ignoreError, String trxName) {
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing - " + sql);
        }
        int no = -1;
        CPreparedStatement cs = new CPreparedStatement(1003, 1008, sql, trxName);
        try {
            if (params != null) {
                for (int i2 = 0; i2 < params.length; ++i2) {
                    Object param = params[i2];
                    if (param instanceof String) {
                        cs.setString(i2 + 1, (String)param);
                        continue;
                    }
                    if (param instanceof Integer) {
                        cs.setInt(i2 + 1, (Integer)param);
                        continue;
                    }
                    if (param instanceof BigDecimal) {
                        cs.setBigDecimal(i2 + 1, (BigDecimal)param);
                        continue;
                    }
                    if (!(param instanceof Timestamp)) continue;
                    cs.setTimestamp(i2 + 1, (Timestamp)param);
                }
            }
            no = cs.executeUpdate();
            if (trxName == null) {
                cs.commit();
            }
        }
        catch (SQLException e) {
            if (ignoreError) {
                log.log(Level.SEVERE, cs.getSql() + " [" + trxName + "] - " + e.getMessage());
            } else {
                log.log(Level.SEVERE, cs.getSql() + " [" + trxName + "]", e);
                log.saveError("DBExecuteError", e);
            }
        }
        finally {
            try {
                cs.close();
            }
            catch (SQLException e2) {
                log.log(Level.SEVERE, "Cannot close statement");
            }
        }
        return no;
    }

    public static int executeUpdateMultiple(String sql, boolean ignoreError, String trxName) {
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing - " + sql);
        }
        int index = sql.indexOf(SQLSTATEMENT_SEPARATOR);
        if (index == -1) {
            return DB.executeUpdate(sql, null, ignoreError, trxName);
        }
        int no = 0;
        String[] statements = sql.split(SQLSTATEMENT_SEPARATOR);
        for (int i2 = 0; i2 < statements.length; ++i2) {
            log.fine(statements[i2]);
            no += DB.executeUpdate(statements[i2], null, ignoreError, trxName);
        }
        return no;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdateEx(String SQL, String trxName) throws SQLException {
        if (SQL == null || SQL.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing - " + SQL);
        }
        String sql = DB.getDatabase().convertStatement(SQL);
        int no = -1;
        SQLException ex = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            Trx trx = trxName == null ? null : Trx.get(trxName, true);
            conn = trx != null ? trx.getConnection() : DB.getConnectionRW();
            stmt = conn.createStatement();
            no = stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql + " [" + trxName + "]", e);
            ex = e;
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e2) {
                log.log(Level.SEVERE, "Cannot close statement");
            }
        }
        if (ex != null) {
            throw new SQLException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode());
        }
        return no;
    }

    public static boolean commit(boolean throwException, String trxName) throws SQLException {
        try {
            Connection conn = null;
            Trx trx = trxName == null ? null : Trx.get(trxName, true);
            conn = trx != null ? trx.getConnection() : DB.getConnectionRW();
            conn.commit();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "[" + trxName + "]", e);
            if (throwException) {
                throw e;
            }
            return false;
        }
        return true;
    }

    public static boolean rollback(boolean throwException, String trxName) throws SQLException {
        try {
            Connection conn = null;
            Trx trx = trxName == null ? null : Trx.get(trxName, true);
            conn = trx != null ? trx.getConnection() : DB.getConnectionRW();
            conn.rollback();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "[" + trxName + "]", e);
            if (throwException) {
                throw e;
            }
            return false;
        }
        return true;
    }

    public static RowSet getRowSet(String sql, boolean local) {
        RowSet retValue = null;
        CStatementVO info = new CStatementVO(1004, 1007, DB.getDatabase().convertStatement(sql));
        CPreparedStatement stmt = new CPreparedStatement(info);
        retValue = local ? stmt.local_getRowSet() : stmt.remote_getRowSet();
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSQLValue(String trxName, String sql) {
        int retValue = -1;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            } else {
                log.fine("No Value " + sql);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSQLValue(String trxName, String sql, int int_param1) {
        int retValue = -1;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, int_param1);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            } else {
                log.config("No Value " + sql + " - Param1=" + int_param1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql + " - Param1=" + int_param1 + " [" + trxName + "]", e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSQLValue(String trxName, String sql, int int_param1, int int_param2) {
        int retValue = -1;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, int_param1);
            pstmt.setInt(2, int_param2);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            } else {
                log.info("No Value " + sql + " - Param1=" + int_param1 + ",Param2=" + int_param2);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql + " - Param1=" + int_param1 + ",Param2=" + int_param2 + " [" + trxName + "]", e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSQLValue(String trxName, String sql, String str_param1) {
        int retValue = -1;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setString(1, str_param1);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            } else {
                log.info("No Value " + sql + " - Param1=" + str_param1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql + " - Param1=" + str_param1, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSQLValue(String trxName, String sql, int int_param1, String s_param2) {
        int retValue = -1;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, int_param1);
            pstmt.setString(2, s_param2);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            } else {
                log.info("No Value: " + sql + " - Param1=" + int_param1 + ",Param2=" + s_param2);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql + " - Param1=" + int_param1 + ",Param2=" + s_param2, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSQLValueString(String trxName, String sql, int int_param1) {
        String retValue = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, int_param1);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getString(1);
            } else {
                log.info("No Value " + sql + " - Param1=" + int_param1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql + " - Param1=" + int_param1, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal getSQLValueBD(String trxName, String sql, int int_param1) {
        BigDecimal retValue = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, int_param1);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getBigDecimal(1);
            } else {
                log.info("No Value " + sql + " - Param1=" + int_param1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql + " - Param1=" + int_param1 + " [" + trxName + "]", e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        return retValue;
    }

    public static KeyNamePair[] getKeyNamePairs(String sql, boolean optional) {
        CPreparedStatement pstmt = null;
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        if (optional) {
            list.add(new KeyNamePair(-1, ""));
        }
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        KeyNamePair[] retValue = new KeyNamePair[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static boolean isSOTrx(String TableName, String whereClause) {
        if (TableName == null || TableName.length() == 0) {
            log.severe("No TableName");
            return true;
        }
        if (whereClause == null || whereClause.length() == 0) {
            log.severe("No Where Clause");
            return true;
        }
        boolean isSOTrx = true;
        String sql = "SELECT IsSOTrx FROM " + TableName + " WHERE " + whereClause;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                isSOTrx = "Y".equals(rs.getString(1));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            if (TableName.endsWith("Line")) {
                String hdr = TableName.substring(0, TableName.indexOf("Line"));
                sql = "SELECT IsSOTrx FROM " + hdr + " h WHERE EXISTS (SELECT * FROM " + TableName + " l WHERE h." + hdr + "_ID=l." + hdr + "_ID AND " + whereClause + ")";
                CPreparedStatement pstmt2 = null;
                try {
                    pstmt2 = DB.prepareStatement(sql, null);
                    ResultSet rs2 = pstmt2.executeQuery();
                    if (rs2.next()) {
                        isSOTrx = "Y".equals(rs2.getString(1));
                    }
                    rs2.close();
                    pstmt2.close();
                    pstmt2 = null;
                }
                catch (Exception ee) {
                    log.finest(sql + " - " + e.getMessage());
                }
                try {
                    if (pstmt2 != null) {
                        pstmt2.close();
                    }
                    pstmt2 = null;
                }
                catch (Exception ee) {
                    pstmt2 = null;
                }
            }
            log.finest(TableName + " - No SOTrx");
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return isSOTrx;
    }

    public static int getNextID(Properties ctx, String TableName, String trxName) {
        if (ctx == null) {
            throw new IllegalArgumentException("Context missing");
        }
        if (TableName == null || TableName.length() == 0) {
            throw new IllegalArgumentException("TableName missing");
        }
        return DB.getNextID(Env.getAD_Client_ID(ctx), TableName, trxName);
    }

    public static int getNextID(int AD_Client_ID, String TableName, String trxName) {
        if ((trxName == null || trxName.length() == 0) && DB.isRemoteObjects()) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    int id = server.getNextID(AD_Client_ID, TableName, null);
                    log.finest("server => " + id);
                    if (id < 0) {
                        throw new DBException("No NextID");
                    }
                    return id;
                }
                log.log(Level.SEVERE, "AppsServer not found - " + TableName);
            }
            catch (RemoteException ex) {
                log.log(Level.SEVERE, "AppsServer error", ex);
            }
        }
        int id = MSequence.getNextID(AD_Client_ID, TableName, trxName);
        return id;
    }

    public static String getDocumentNo(int C_DocType_ID, String trxName) {
        String dn;
        if ((trxName == null || trxName.length() == 0) && DB.isRemoteObjects()) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    String dn2 = server.getDocumentNo(C_DocType_ID, trxName);
                    log.finest("Server => " + dn2);
                    if (dn2 != null) {
                        return dn2;
                    }
                }
                log.log(Level.SEVERE, "AppsServer not found - " + C_DocType_ID);
            }
            catch (RemoteException ex) {
                log.log(Level.SEVERE, "AppsServer error", ex);
            }
        }
        if ((dn = MSequence.getDocumentNo(C_DocType_ID, trxName)) == null) {
            dn = MSequence.getDocumentNo(C_DocType_ID, trxName);
        }
        return dn;
    }

    public static String getDocumentNo(int AD_Client_ID, String TableName, String trxName) {
        String dn;
        if ((trxName == null || trxName.length() == 0) && DB.isRemoteObjects()) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    String dn2 = server.getDocumentNo(AD_Client_ID, TableName, trxName);
                    log.finest("Server => " + dn2);
                    if (dn2 != null) {
                        return dn2;
                    }
                }
                log.log(Level.SEVERE, "AppsServer not found - " + TableName);
            }
            catch (RemoteException ex) {
                log.log(Level.SEVERE, "AppsServer error", ex);
            }
        }
        if ((dn = MSequence.getDocumentNo(AD_Client_ID, TableName, trxName)) == null) {
            dn = MSequence.getDocumentNo(AD_Client_ID, TableName, trxName);
        }
        if (dn == null) {
            throw new DBException("No DocumentNo");
        }
        return dn;
    }

    public static String getDocumentNo(Properties ctx, int WindowNo, String TableName, boolean onlyDocType, String trxName) {
        if (ctx == null || TableName == null || TableName.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing");
        }
        int AD_Client_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Client_ID");
        int C_DocType_ID = Env.getContextAsInt(ctx, WindowNo + "|C_DocTypeTarget_ID");
        if (C_DocType_ID == 0) {
            C_DocType_ID = Env.getContextAsInt(ctx, WindowNo + "|C_DocType_ID");
        }
        if (C_DocType_ID == 0) {
            log.fine("Window=" + WindowNo + " - Target=" + Env.getContextAsInt(ctx, WindowNo + "|C_DocTypeTarget_ID") + "/" + Env.getContextAsInt(ctx, WindowNo, "C_DocTypeTarget_ID") + " - Actual=" + Env.getContextAsInt(ctx, WindowNo + "|C_DocType_ID") + "/" + Env.getContextAsInt(ctx, WindowNo, "C_DocType_ID"));
            return DB.getDocumentNo(AD_Client_ID, TableName, trxName);
        }
        String retValue = DB.getDocumentNo(C_DocType_ID, trxName);
        if (!onlyDocType && retValue == null) {
            return DB.getDocumentNo(AD_Client_ID, TableName, trxName);
        }
        return retValue;
    }

    public static boolean isRemoteObjects() {
        return CConnection.get().isServerObjects() && CConnection.get().isAppsServerOK(false);
    }

    public static boolean isRemoteProcess() {
        return CConnection.get().isServerProcess() && CConnection.get().isAppsServerOK(false);
    }

    public static void printWarning(String comment, SQLWarning warning) {
        if (comment == null || warning == null || comment.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing");
        }
        log.warning(comment);
        if (warning == null) {
            return;
        }
        for (SQLWarning warn = warning; warn != null; warn = warn.getNextWarning()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(warn.getMessage()).append("; State=").append(warn.getSQLState()).append("; ErrorCode=").append(warn.getErrorCode());
            log.warning(buffer.toString());
        }
    }

    public static String TO_DATE(Timestamp time, boolean dayOnly) {
        return s_cc.getDatabase().TO_DATE(time, dayOnly);
    }

    public static String TO_DATE(Timestamp day) {
        return DB.TO_DATE(day, true);
    }

    public static String TO_CHAR(String columnName, int displayType, String AD_Language) {
        if (columnName == null || AD_Language == null || columnName.length() == 0) {
            throw new IllegalArgumentException("Required parameter missing");
        }
        return s_cc.getDatabase().TO_CHAR(columnName, displayType, AD_Language);
    }

    public String TO_NUMBER(BigDecimal number, int displayType) {
        return s_cc.getDatabase().TO_NUMBER(number, displayType);
    }

    public static String TO_STRING(String txt) {
        return DB.TO_STRING(txt, 0);
    }

    public static String TO_STRING(String txt, int maxLength) {
        if (txt == null || txt.length() == 0) {
            return "NULL";
        }
        String text = txt;
        if (maxLength != 0 && text.length() > maxLength) {
            text = txt.substring(0, maxLength);
        }
        StringBuffer out = new StringBuffer();
        out.append('\'');
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c = text.charAt(i2);
            if (c == '\'') {
                out.append("''");
                continue;
            }
            out.append(c);
        }
        out.append('\'');
        return out.toString();
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        MSystem system = MSystem.get(Env.getCtx());
        system.setIsJustMigrated(true);
        DB.afterMigration(Env.getCtx());
    }
}

