/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.Serializable;
import java.util.ArrayList;
import org.compiere.util.DB;

public class CStatementVO
implements Serializable {
    static final long serialVersionUID = -3393389471515956399L;
    private int m_resultSetType;
    private int m_resultSetConcurrency;
    private String m_sql;
    private ArrayList<Object> m_parameters = new ArrayList();

    public CStatementVO(int resultSetType, int resultSetConcurrency) {
        this.setResultSetType(resultSetType);
        this.setResultSetConcurrency(resultSetConcurrency);
    }

    public CStatementVO(int resultSetType, int resultSetConcurrency, String sql) {
        this(resultSetType, resultSetConcurrency);
        this.setSql(sql);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CStatementVO[");
        sb.append(this.getSql());
        for (int i2 = 0; i2 < this.m_parameters.size(); ++i2) {
            sb.append("; #").append(i2 + 1).append("=").append(this.m_parameters.get(i2));
        }
        sb.append("]");
        return sb.toString();
    }

    public void setParameter(int index1, Object element) {
        if (element != null && !(element instanceof Serializable)) {
            throw new RuntimeException("setParameter not Serializable - " + element.getClass().toString());
        }
        int zeroIndex = index1 - 1;
        if (this.m_parameters.size() == zeroIndex) {
            this.m_parameters.add(element);
        } else if (this.m_parameters.size() < zeroIndex) {
            while (this.m_parameters.size() < zeroIndex) {
                this.m_parameters.add(null);
            }
            this.m_parameters.add(element);
        } else {
            this.m_parameters.set(zeroIndex, element);
        }
    }

    public void clearParameters() {
        this.m_parameters = new ArrayList();
    }

    public ArrayList getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.size();
    }

    public String getSql() {
        return this.m_sql;
    }

    public void setSql(String sql) {
        if (sql != null && DB.isRemoteObjects()) {
            int pos = sql.indexOf("ROWID");
            int posTrim = sql.indexOf("TRIM(ROWID)");
            int posWhere = sql.indexOf("WHERE");
            this.m_sql = pos != -1 && posTrim == -1 && (posWhere == -1 || pos < posWhere) ? sql.substring(0, pos) + "TRIM(ROWID)" + sql.substring(pos + 5) : sql;
        } else {
            this.m_sql = sql;
        }
    }

    public int getResultSetConcurrency() {
        return this.m_resultSetConcurrency;
    }

    public int getResultSetType() {
        return this.m_resultSetType;
    }

    public void setResultSetType(int resultSetType) {
        this.m_resultSetType = resultSetType;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.m_resultSetConcurrency = resultSetConcurrency;
    }
}

