/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import org.compiere.util.DisplayType;

public class CMemoryUsage
extends MemoryUsage {
    private static DecimalFormat s_format = DisplayType.getNumberFormat(11);

    public CMemoryUsage(long init, long used, long committed, long max) {
        super(init, used, committed, max);
    }

    public CMemoryUsage(MemoryUsage usage) {
        super(usage.getInit(), usage.getUsed(), usage.getCommitted(), usage.getMax());
    }

    public long getFree() {
        return this.getCommitted() - this.getUsed();
    }

    public int getFreePercent() {
        long base = this.getCommitted();
        long no = this.getFree() * 100L;
        if (no == 0L) {
            return 0;
        }
        long percent = no / base;
        return (int)percent;
    }

    public int getCommittedPercent() {
        long base = this.getMax();
        long no = this.getCommitted() * 100L;
        if (no == 0L) {
            return 0;
        }
        long percent = no / base;
        return (int)percent;
    }

    private String format(long info) {
        long infoK = info / 1024L;
        if (infoK == 0L) {
            return String.valueOf(info);
        }
        long infoM = infoK / 1024L;
        if (infoM == 0L) {
            return s_format.format(info);
        }
        return s_format.format(infoK) + "k";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Init=").append(this.format(this.getInit())).append(", Used=").append(this.format(this.getUsed())).append(", Free=").append(this.format(this.getFree())).append(" ").append(this.getFreePercent()).append("%, Committed=").append(this.format(this.getCommitted())).append(" ").append(this.getCommittedPercent()).append("%, Max=").append(this.format(this.getMax()));
        return sb.toString();
    }
}

