/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.Serializable;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.compiere.util.CLogMgt;
import org.compiere.util.ValueNamePair;

public class CLogger
extends Logger
implements Serializable {
    private static CLogger s_logger = null;
    private static ValueNamePair s_lastError = null;
    private static Exception s_lastException = null;
    private static ValueNamePair s_lastWarning = null;
    private static ValueNamePair s_lastInfo = null;

    public static synchronized CLogger getCLogger(String className) {
        Logger result;
        LogManager manager = LogManager.getLogManager();
        if (className == null) {
            className = "";
        }
        if ((result = manager.getLogger(className)) != null && result instanceof CLogger) {
            return (CLogger)result;
        }
        CLogger newLogger = new CLogger(className, null);
        newLogger.setLevel(CLogMgt.getLevel());
        manager.addLogger(newLogger);
        return newLogger;
    }

    public static CLogger getCLogger(Class clazz) {
        if (clazz == null) {
            return CLogger.get();
        }
        return CLogger.getCLogger(clazz.getName());
    }

    public static CLogger get() {
        if (s_logger == null) {
            s_logger = CLogger.getCLogger("org.compiere.default");
        }
        return s_logger;
    }

    private CLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    public boolean saveError(String AD_Message, String message) {
        return this.saveError(AD_Message, message, true);
    }

    public boolean saveError(String AD_Message, Exception ex) {
        s_lastException = ex;
        return this.saveError(AD_Message, ex.getLocalizedMessage(), true);
    }

    public boolean saveError(String AD_Message, String message, boolean issueError) {
        s_lastError = new ValueNamePair(AD_Message, message);
        if (issueError) {
            this.severe(AD_Message + " - " + message);
        }
        return true;
    }

    public static ValueNamePair retrieveError() {
        ValueNamePair vp = s_lastError;
        s_lastError = null;
        return vp;
    }

    public static Exception retrieveException() {
        Exception ex = s_lastException;
        s_lastException = null;
        return ex;
    }

    public boolean saveWarning(String AD_Message, String message) {
        s_lastWarning = new ValueNamePair(AD_Message, message);
        this.warning(AD_Message + " - " + message);
        return true;
    }

    public static ValueNamePair retrieveWarning() {
        ValueNamePair vp = s_lastWarning;
        s_lastWarning = null;
        return vp;
    }

    public boolean saveInfo(String AD_Message, String message) {
        s_lastInfo = new ValueNamePair(AD_Message, message);
        return true;
    }

    public static ValueNamePair retrieveInfo() {
        ValueNamePair vp = s_lastInfo;
        s_lastInfo = null;
        return vp;
    }

    public static void resetLast() {
        s_lastError = null;
        s_lastException = null;
        s_lastWarning = null;
        s_lastInfo = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CLogger[");
        sb.append(this.getName()).append(",Level=").append(this.getLevel()).append("]");
        return sb.toString();
    }
}

