/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.compiere.model.MIssue;
import org.compiere.util.CLogFilter;
import org.compiere.util.CLogFormatter;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLogErrorBuffer
extends Handler {
    private static CLogErrorBuffer s_handler;
    private static final int ERROR_SIZE = 20;
    private LinkedList<LogRecord> m_errors = new LinkedList();
    private LinkedList<LogRecord[]> m_history = new LinkedList();
    private static final int LOG_SIZE = 100;
    private LinkedList<LogRecord> m_logs = new LinkedList();
    private volatile boolean m_issueError = true;

    public static CLogErrorBuffer get(boolean create) {
        if (s_handler == null && create) {
            s_handler = new CLogErrorBuffer();
        }
        return s_handler;
    }

    public CLogErrorBuffer() {
        if (s_handler == null) {
            s_handler = this;
        } else {
            this.reportError("Error Handler exists already", new IllegalStateException("Existing Handler"), 0);
        }
        this.initialize();
    }

    private void initialize() {
        this.setFormatter(CLogFormatter.get());
        super.setLevel(Level.INFO);
        this.setFilter(CLogFilter.get());
    }

    public boolean isIssueError() {
        return this.m_issueError;
    }

    public void setIssueError(boolean issueError) {
        this.m_issueError = issueError;
    }

    @Override
    public synchronized void setLevel(Level newLevel) throws SecurityException {
        if (newLevel == null) {
            return;
        }
        if (newLevel == Level.OFF) {
            super.setLevel(Level.SEVERE);
        } else if (newLevel == Level.ALL || newLevel == Level.FINEST || newLevel == Level.FINER) {
            super.setLevel(Level.FINE);
        } else {
            super.setLevel(newLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record) || this.m_logs == null) {
            return;
        }
        LinkedList<LogRecord> linkedList = this.m_logs;
        synchronized (linkedList) {
            if (this.m_logs.size() >= 100) {
                this.m_logs.removeFirst();
            }
            this.m_logs.add(record);
        }
        if (record.getLevel() == Level.SEVERE) {
            if (this.m_errors.size() >= 20) {
                this.m_errors.removeFirst();
                this.m_history.removeFirst();
            }
            this.m_errors.add(record);
            record.getSourceClassName();
            ArrayList<LogRecord> history = new ArrayList<LogRecord>();
            for (int i2 = this.m_logs.size() - 1; i2 >= 0; --i2) {
                LogRecord rec = this.m_logs.get(i2);
                if (rec.getLevel() == Level.SEVERE) {
                    if (history.size() != 0) break;
                    history.add(rec);
                    continue;
                }
                history.add(rec);
                if (history.size() > 10) break;
            }
            LogRecord[] historyArray = new LogRecord[history.size()];
            int no = 0;
            for (int i3 = history.size() - 1; i3 >= 0; --i3) {
                historyArray[no++] = (LogRecord)history.get(i3);
            }
            this.m_history.add(historyArray);
            if (this.m_issueError) {
                String loggerName = record.getLoggerName();
                String className = record.getSourceClassName();
                String methodName = record.getSourceMethodName();
                if (DB.isConnected() && !methodName.equals("saveError") && !methodName.equals("get_Value") && !methodName.equals("dataSave") && loggerName.indexOf("Issue") == -1 && loggerName.indexOf("CConnection") == -1) {
                    this.m_issueError = false;
                    MIssue.create(record);
                    this.m_issueError = true;
                }
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        if (this.m_logs != null) {
            this.m_logs.clear();
        }
        this.m_logs = null;
        if (this.m_errors != null) {
            this.m_errors.clear();
        }
        this.m_errors = null;
        if (this.m_history != null) {
            this.m_history.clear();
        }
        this.m_history = null;
    }

    public Vector<String> getColumnNames(Properties ctx) {
        Vector<String> cn = new Vector<String>();
        cn.add("Time");
        cn.add("Level");
        cn.add("Class.Method");
        cn.add("Message");
        cn.add("Parameter");
        cn.add("Trace");
        return cn;
    }

    public Vector<Vector> getLogData(boolean errorsOnly) {
        LogRecord[] records = this.getRecords(errorsOnly);
        Vector<Vector> rows = new Vector<Vector>(records.length);
        for (int i2 = 0; i2 < records.length; ++i2) {
            LogRecord record = records[i2];
            Vector<Object> cols = new Vector<Object>();
            cols.add(new Timestamp(record.getMillis()));
            cols.add(record.getLevel().getName());
            cols.add(CLogFormatter.getClassMethod(record));
            cols.add(record.getMessage());
            cols.add(CLogFormatter.getParameters(record));
            cols.add(CLogFormatter.getExceptionTrace(record));
            rows.add(cols);
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecord[] getRecords(boolean errorsOnly) {
        LogRecord[] retValue = null;
        if (errorsOnly) {
            LinkedList<LogRecord> linkedList = this.m_errors;
            synchronized (linkedList) {
                retValue = new LogRecord[this.m_errors.size()];
                this.m_errors.toArray(retValue);
            }
        }
        LinkedList<LogRecord> linkedList = this.m_logs;
        synchronized (linkedList) {
            retValue = new LogRecord[this.m_logs.size()];
            this.m_logs.toArray(retValue);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBuffer(boolean errorsOnly) {
        LinkedList<LogRecord> linkedList = this.m_errors;
        synchronized (linkedList) {
            this.m_errors.clear();
            this.m_history.clear();
        }
        if (!errorsOnly) {
            linkedList = this.m_logs;
            synchronized (linkedList) {
                this.m_logs.clear();
            }
        }
    }

    public String getErrorInfo(Properties ctx, boolean errorsOnly) {
        StringBuffer sb = new StringBuffer();
        if (errorsOnly) {
            for (int i2 = 0; i2 < this.m_history.size(); ++i2) {
                sb.append("-------------------------------\n");
                LogRecord[] records = this.m_history.get(i2);
                for (int j = 0; j < records.length; ++j) {
                    LogRecord record = records[j];
                    sb.append(this.getFormatter().format(record));
                }
            }
        } else {
            for (int i3 = 0; i3 < this.m_logs.size(); ++i3) {
                LogRecord record = this.m_logs.get(i3);
                sb.append(this.getFormatter().format(record));
            }
        }
        sb.append("\n");
        CLogMgt.getInfo(sb);
        CLogMgt.getInfoDetail(sb, ctx);
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CLogErrorBuffer[");
        sb.append("Errors=").append(this.m_errors.size()).append(",History=").append(this.m_history.size()).append(",Logs=").append(this.m_logs.size()).append(",Level=").append(this.getLevel()).append("]");
        return sb.toString();
    }
}

