/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_TH
implements AmtInWords {
    private static final String[] majorNames = new String[]{"", "\u0e25\u0e49\u0e32\u0e19 "};
    private static final String[] hundredThousandNames = new String[]{"", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e41\u0e2a\u0e19", "\u0e2a\u0e2d\u0e07\u0e41\u0e2a\u0e19", "\u0e2a\u0e32\u0e21\u0e41\u0e2a\u0e19", "\u0e2a\u0e35\u0e48\u0e41\u0e2a\u0e19", "\u0e2b\u0e49\u0e32\u0e41\u0e2a\u0e19", "\u0e2b\u0e01\u0e41\u0e2a\u0e19", "\u0e40\u0e08\u0e47\u0e14\u0e41\u0e2a\u0e19", "\u0e41\u0e1b\u0e14\u0e41\u0e2a\u0e19", "\u0e40\u0e01\u0e49\u0e32\u0e41\u0e2a\u0e19"};
    private static final String[] tenThousandNames = new String[]{"", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e2a\u0e2d\u0e07\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e2a\u0e32\u0e21\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e2a\u0e35\u0e48\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e2b\u0e49\u0e32\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e2b\u0e01\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e40\u0e08\u0e47\u0e14\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e41\u0e1b\u0e14\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e40\u0e01\u0e49\u0e32\u0e2b\u0e21\u0e37\u0e48\u0e19"};
    private static final String[] thousandNames = new String[]{"", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e1e\u0e31\u0e19", "\u0e2a\u0e2d\u0e07\u0e1e\u0e31\u0e19", "\u0e2a\u0e32\u0e21\u0e1e\u0e31\u0e19", "\u0e2a\u0e35\u0e48\u0e1e\u0e31\u0e19", "\u0e2b\u0e49\u0e32\u0e1e\u0e31\u0e19", "\u0e2b\u0e01\u0e1e\u0e31\u0e19", "\u0e40\u0e08\u0e47\u0e14\u0e1e\u0e31\u0e19", "\u0e41\u0e1b\u0e14\u0e1e\u0e31\u0e19", "\u0e40\u0e01\u0e49\u0e32\u0e1e\u0e31\u0e19"};
    private static final String[] hundredNames = new String[]{"", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e23\u0e49\u0e2d\u0e22", "\u0e2a\u0e2d\u0e07\u0e23\u0e49\u0e2d\u0e22", "\u0e2a\u0e32\u0e21\u0e23\u0e49\u0e2d\u0e22", "\u0e2a\u0e35\u0e48\u0e23\u0e49\u0e2d\u0e22", "\u0e2b\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22", "\u0e2b\u0e01\u0e23\u0e49\u0e2d\u0e22", "\u0e40\u0e08\u0e47\u0e14\u0e23\u0e49\u0e2d\u0e22", "\u0e41\u0e1b\u0e14\u0e23\u0e49\u0e2d\u0e22", "\u0e40\u0e01\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22"};
    private static final String[] tensNames = new String[]{"", "\u0e2a\u0e34\u0e1a", "\u0e22\u0e35\u0e48\u0e2a\u0e34\u0e1a", "\u0e2a\u0e32\u0e21\u0e2a\u0e34\u0e1a", "\u0e2a\u0e35\u0e48\u0e2a\u0e34\u0e1a", "\u0e2b\u0e49\u0e32\u0e2a\u0e34\u0e1a", "\u0e2b\u0e01\u0e2a\u0e34\u0e1a", "\u0e40\u0e08\u0e47\u0e14\u0e2a\u0e34\u0e1a", "\u0e41\u0e1b\u0e14\u0e2a\u0e34\u0e1a", "\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a"};
    private static final String[] numNames = new String[]{"", "\u0e2b\u0e19\u0e36\u0e48\u0e07", "\u0e2a\u0e2d\u0e07", "\u0e2a\u0e32\u0e21", "\u0e2a\u0e35\u0e48", "\u0e2b\u0e49\u0e32", "\u0e2b\u0e01", "\u0e40\u0e08\u0e47\u0e14", "\u0e41\u0e1b\u0e14", "\u0e40\u0e01\u0e49\u0e32", "\u0e2a\u0e34\u0e1a", "\u0e2a\u0e34\u0e1a\u0e40\u0e2d\u0e47\u0e14", "\u0e2a\u0e34\u0e1a\u0e2a\u0e2d\u0e07", "\u0e2a\u0e34\u0e1a\u0e2a\u0e32\u0e21", "\u0e2a\u0e34\u0e1a\u0e2a\u0e35\u0e48", "\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32", "\u0e2a\u0e34\u0e1a\u0e2b\u0e01", "\u0e2a\u0e34\u0e1a\u0e40\u0e08\u0e47\u0e14", "\u0e2a\u0e34\u0e1a\u0e41\u0e1b\u0e14", "\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32"};

    private String convertLessThanOneMillion(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            if (number != 1 && soFar.equals("\u0e2b\u0e19\u0e36\u0e48\u0e07")) {
                soFar = "\u0e40\u0e2d\u0e47\u0e14";
            }
            soFar = tensNames[(number /= 10) % 10] + soFar;
            soFar = hundredNames[(number /= 10) % 10] + soFar;
            soFar = thousandNames[(number /= 10) % 10] + soFar;
            soFar = tenThousandNames[(number /= 10) % 10] + soFar;
            soFar = hundredThousandNames[(number /= 10) % 10] + soFar;
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        return numNames[number] + "\u0e23\u0e49\u0e2d\u0e22\u0e25\u0e49\u0e32\u0e19" + soFar;
    }

    private String convert(double number) {
        if (number == 0.0) {
            return "\u0e28\u0e39\u0e19\u0e22\u0e4c";
        }
        String prefix = "";
        String subfix = "\u0e1a\u0e32\u0e17";
        if (number < 0.0) {
            number = -number;
            prefix = "\u0e25\u0e1a ";
        }
        String soFar = "";
        int place = 0;
        do {
            double d;
            int n;
            if ((n = (int)(d = number % 1000000.0)) != 0) {
                String s = this.convertLessThanOneMillion(n);
                place = place > 0 ? 1 : 0;
                soFar = s + majorNames[place] + soFar;
            }
            ++place;
        } while ((number /= 1000000.0) > 0.0);
        return (prefix + soFar + subfix).trim();
    }

    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        double pos = amount.lastIndexOf(46);
        double pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        amount = amount.replaceAll(",", "");
        int newpos = amount.lastIndexOf(46);
        double pesos = Double.parseDouble(amount.substring(0, newpos));
        sb.append(this.convert(pesos));
        for (int i2 = 0; i2 < oldamt.length(); ++i2) {
            if (pos != (double)i2) continue;
            String cents = oldamt.substring(i2 + 1);
            sb.append(' ').append(cents).append("/100");
            break;
        }
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_TH aiw = new AmtInWords_TH();
        aiw.print("0.23");
        aiw.print("1.23");
        aiw.print("11.45");
        aiw.print("121.45");
        aiw.print("1231.56");
        aiw.print("12341.78");
        aiw.print("123451.89");
        aiw.print("12234571.90");
        aiw.print("123234571.90");
        aiw.print("1987234571.90");
        aiw.print("11123234571.90");
        aiw.print("123123234571.90");
        aiw.print("2123123234571.90");
        aiw.print("23,123,123,234,571.90");
        aiw.print("100,000,000,000,000.90");
        aiw.print("0.00");
    }
}

