/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_PL
implements AmtInWords {
    private static final String[][] majorNames = new String[][]{{"", "", ""}, {"tysi\ufffdc", "tysi\ufffdce", "tysi\ufffdcy"}, {"milion", "miliony", "milion\ufffdw"}, {"miliard", "miliardy", "miliard\ufffdw"}, {"bilion", "biliony", "bilion\ufffdw"}, {"trylion", "tryliony", "trylion\ufffdw"}, {"quadrylion", "quadryliony", "quadrylion\ufffdw"}};
    private static final String[] tensNames = new String[]{"", "dziesi\ufffd\ufffd", "dwadzie\ufffdcia", "trzydzie\ufffdci", "czterdzie\ufffdci", "pi\ufffd\ufffddziesi\ufffdt", "sze\ufffd\ufffddziesi\ufffdt", "siedemdziesi\ufffdt", "osiemdziesi\ufffdt", "dziewi\ufffd\ufffddziesi\ufffdt"};
    private static final String[] hundredNames = new String[]{"", "sto", "dwie\ufffdcie", "trzysta", "czterysta", "pi\ufffd\ufffdset", "sze\ufffd\ufffdset", "siedemset", "osiemset", "dziewi\ufffd\ufffdset"};
    private static final String[] numNames = new String[]{"", "jeden", "dwa", "trzy", "cztery", "pi\ufffd\ufffd", "sze\ufffd\ufffd", "siedem", "osiem", "dzieiwi\ufffd\ufffd", "dziesi\ufffd\ufffd", "jedena\ufffdcie", "dwana\ufffdcie", "trzyna\ufffdcie", "czterna\ufffdcie", "pietna\ufffdcie", "szescna\ufffdcie", "siedemna\ufffdcie", "osiemna\ufffdcie", "dziewi\ufffdtna\ufffdcie"};

    private String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            soFar = tensNames[(number /= 10) % 10] + " " + soFar;
            number /= 10;
        }
        soFar = hundredNames[number % 10] + " " + soFar;
        number /= 10;
        return soFar;
    }

    private String convert(long number) {
        if (number == 0L) {
            return "zero";
        }
        String prefix = "";
        if (number < 0L) {
            number = -number;
            prefix = "minus ";
        }
        String soFar = "";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = this.convertLessThanOneThousand((int)n);
                int pos = number % 10L == 1L ? 0 : (number % 10L < 5L ? 1 : 2);
                if (number > 9L && number < 20L) {
                    pos = 2;
                }
                soFar = s + " " + majorNames[place][pos] + " " + soFar;
            }
            ++place;
        } while ((number /= 1000L) > 0L);
        return (prefix + soFar).trim();
    }

    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        amount = amount.replaceAll(",", "");
        int newpos = amount.lastIndexOf(46);
        long dollars = Long.parseLong(amount.substring(0, newpos));
        sb.append(this.convert(dollars));
        for (int i2 = 0; i2 < oldamt.length(); ++i2) {
            if (pos != i2) continue;
            String cents = oldamt.substring(i2 + 1);
            sb.append(' ').append(cents).append("/100");
            break;
        }
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_PL aiw = new AmtInWords_PL();
        aiw.print("0.23");
        aiw.print("1.23");
        aiw.print("12.345");
        aiw.print("123.45");
        aiw.print("1234.56");
        aiw.print("12345.78");
        aiw.print("10345.78");
        aiw.print("123457.89");
        aiw.print("323457.89");
        aiw.print("23457.89");
        aiw.print("1,234,578.90");
    }
}

