/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;
import org.compiere.util.CLogger;

public class AmtInWords_IN
implements AmtInWords {
    private static final String[] basenumbers = new String[]{"Nol", "Satu", "Dua", "Tiga", "Empat", "Lima", "Enam", "Tujuh", "Delapan", "Sembilan", "Sepuluh", "Sebelas"};
    private static final long POWER_THREE = 1000L;
    private static final long POWER_SIX = 1000000L;
    private static final long POWER_NINE = 1000000000L;
    private static final long POWER_TWELVE = 1000000000000L;
    private static final long POWER_FIFTEEN = 1000000000000000L;
    private static CLogger s_log = CLogger.getCLogger(AmtInWords_IN.class);

    public static String sayNumber(double number) {
        StringBuffer result = new StringBuffer();
        AmtInWords_IN.sayNumber(result, number);
        result.append(" Rupiah");
        return result.toString();
    }

    public static String sayNumber(StringBuffer appendTo, double number) throws IllegalArgumentException {
        double abs;
        if (number == Double.MIN_VALUE) {
            throw new IllegalArgumentException("Out of range");
        }
        if (number < 0.0) {
            appendTo.append("Minus ");
        }
        if ((abs = Math.abs(number)) < 1000.0) {
            AmtInWords_IN.saySimpleNumber(appendTo, (int)abs);
        } else if (abs < 2000.0) {
            int thousand = (int)(abs % 1000.0);
            appendTo.append("Seribu ");
            AmtInWords_IN.saySimpleNumber(appendTo, thousand);
        } else if (abs < 1000000.0) {
            int thousand = (int)(abs % 1000000.0 / 1000.0);
            AmtInWords_IN.saySimpleNumber(appendTo, thousand);
            appendTo.append(" Ribu");
            double remainder = abs - (double)((long)thousand * 1000L);
            if (remainder > 0.0) {
                appendTo.append(' ');
                AmtInWords_IN.sayNumber(appendTo, remainder);
            }
        } else if (abs < 1.0E9) {
            int million = (int)(abs % 1.0E9 / 1000000.0);
            AmtInWords_IN.saySimpleNumber(appendTo, million);
            appendTo.append(" Juta");
            double remainder = abs - (double)((long)million * 1000000L);
            if (remainder > 0.0) {
                appendTo.append(' ');
                AmtInWords_IN.sayNumber(appendTo, remainder);
            }
        } else if (abs < 1.0E12) {
            int billion = (int)(abs % 1.0E12 / 1.0E9);
            AmtInWords_IN.saySimpleNumber(appendTo, billion);
            appendTo.append(" Milyar");
            double remainder = abs - (double)((long)billion * 1000000000L);
            if (remainder > 0.0) {
                appendTo.append(' ');
                AmtInWords_IN.sayNumber(appendTo, remainder);
            }
        } else if (abs < 1.0E15) {
            int trillion = (int)(abs % 1.0E15 / 1.0E12);
            AmtInWords_IN.saySimpleNumber(appendTo, trillion);
            appendTo.append(" Trilyun");
            double remainder = abs - (double)((long)trillion * 1000000000000L);
            if (remainder > 0.0) {
                appendTo.append(' ');
                AmtInWords_IN.sayNumber(appendTo, remainder);
            }
        } else {
            appendTo.append("Lebih Dari Seribu Triliun");
        }
        return appendTo.toString();
    }

    static void saySimpleNumber(StringBuffer appendTo, int number) {
        assert (number < 1000 && number >= 0) : "Must be between 0 and 1000";
        if (number < 12) {
            assert (number < 12 && number >= 0) : "Must be between 0 and 11";
            appendTo.append(basenumbers[number]);
        } else if (number < 20) {
            assert (number >= 12 && number <= 19) : "Must be between 12 and 19";
            int belasan = number % 10;
            appendTo.append(basenumbers[belasan]);
            appendTo.append(" Belas");
        } else if (number < 100) {
            assert (number >= 20 && number <= 99) : "Must be between 20 and 99";
            int puluhan = number / 10;
            appendTo.append(basenumbers[puluhan]);
            appendTo.append(" Puluh");
            int remainder = number - puluhan * 10;
            if (remainder > 0) {
                appendTo.append(' ');
                AmtInWords_IN.saySimpleNumber(appendTo, remainder);
            }
        } else if (number < 200) {
            assert (number >= 100 && number <= 199) : "Must be between 100 and 199";
            appendTo.append("Seratus");
            int remainder = number - 100;
            if (remainder > 0) {
                appendTo.append(' ');
                AmtInWords_IN.saySimpleNumber(appendTo, remainder);
            }
        } else if (number != 0) {
            assert (number >= 200 && number <= 999) : "Must be between 200 and 999";
            int ratusan = number % 1000 / 100;
            assert (ratusan > 0 && ratusan < 10) : "1-9";
            appendTo.append(basenumbers[ratusan]);
            appendTo.append(" Ratus");
            int remainder = number - ratusan * 100;
            if (remainder > 0) {
                appendTo.append(' ');
                AmtInWords_IN.saySimpleNumber(appendTo, remainder);
            }
        }
    }

    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer result = new StringBuffer();
        int pos = amount.lastIndexOf(46);
        String oldamt = amount;
        amount = amount.replaceAll(",", "");
        String cents = pos > 0 ? oldamt.substring(pos + 1) : null;
        double numDouble = Double.parseDouble(amount);
        AmtInWords_IN.sayNumber(result, numDouble);
        if (cents != null) {
            result.append(" Koma ");
            numDouble = Double.parseDouble(cents);
            AmtInWords_IN.sayNumber(result, numDouble);
        }
        result.append(" Rupiah");
        return result.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_IN aiw = new AmtInWords_IN();
        aiw.print("0.00");
        aiw.print("0.23");
        aiw.print("1.23876787");
        aiw.print("11.45");
        aiw.print("121.45");
        aiw.print("1231.56");
        aiw.print("10341.78");
        aiw.print("12341.78");
        aiw.print("123451.89");
        aiw.print("12234571.90");
        aiw.print("123234571.90");
        aiw.print("1987234571.90");
        aiw.print("11123234571.90");
        aiw.print("123123234571.90");
        aiw.print("2123123234571.90");
        aiw.print("23,123,123,234,571.90");
        aiw.print("100,000,000,000,000.90");
        aiw.print("111,111,111");
        aiw.print("222,222,222,222,222");
        aiw.print("222,222,222,222,222,222,222");
    }
}

