/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_FR
implements AmtInWords {
    private static final String[] majorNames = new String[]{"", " mille", " million", " milliard", " trillion", " quadrillion", " quintillion"};
    private static final String[] tensNames = new String[]{"", " dix", " vingt", " trente", " quarante", " cinquante", " soixante", " soixante-dix", " quatre-vingt", " quatre-vingt-dix"};
    private static final String[] numNames = new String[]{"", " un", " deux", " trois", " quatre", " cinq", " six", " sept", " huit", " neuf", " dix", " onze", " douze", " treize", " quatorze", " quinze", " seize", " dix-sept", " dix-huit", " dix-neuf"};

    private String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            soFar = tensNames[(number /= 10) % 10] + soFar;
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        if (number == 1) {
            return " cent" + soFar;
        }
        return numNames[number] + " cent" + soFar;
    }

    private String convert(int number) {
        if (number == 0) {
            return "zero";
        }
        String prefix = "";
        if (number < 0) {
            number = -number;
            prefix = "moins";
        }
        String soFar = "";
        int place = 0;
        boolean pluralPossible = true;
        boolean pluralForm = false;
        do {
            int n;
            if ((n = number % 1000) != 0) {
                String s = this.convertLessThanOneThousand(n);
                if (s.trim().equals("un") && place == 1) {
                    soFar = majorNames[place] + soFar;
                } else {
                    if (place == 0) {
                        if (s.trim().endsWith("cent") && !s.trim().startsWith("cent")) {
                            pluralForm = true;
                        } else {
                            pluralPossible = false;
                        }
                    }
                    if (place > 0 && pluralPossible) {
                        if (!s.trim().startsWith("un")) {
                            pluralForm = true;
                        } else {
                            pluralPossible = false;
                        }
                    }
                    soFar = s + majorNames[place] + soFar;
                }
            }
            ++place;
        } while ((number /= 1000) > 0);
        String result = (prefix + soFar).trim();
        return pluralForm ? result + "s" : result;
    }

    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        amount = amount.replaceAll(",", "");
        int newpos = amount.lastIndexOf(46);
        int pesos = Integer.parseInt(amount.substring(0, newpos));
        sb.append(this.convert(pesos));
        for (int i2 = 0; i2 < oldamt.length(); ++i2) {
            if (pos != i2) continue;
            String cents = oldamt.substring(i2 + 1);
            sb.append(' ').append(cents).append("/100");
            break;
        }
        return sb.toString();
    }
}

