/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CEditor;

public class CToggleButton
extends JToggleButton
implements CEditor {
    private boolean m_mandatory = false;

    public CToggleButton() {
        this(null, null, false);
    }

    public CToggleButton(Icon icon) {
        this(null, icon, false);
    }

    public CToggleButton(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public CToggleButton(String text) {
        this(text, null, false);
    }

    public CToggleButton(String text, boolean selected) {
        this(text, null, selected);
    }

    public CToggleButton(Action a2) {
        this(null, null, false);
        this.setAction(a2);
    }

    public CToggleButton(String text, Icon icon) {
        this(text, icon, false);
    }

    public CToggleButton(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
    }

    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
    }

    public void setBackground(boolean error) {
    }

    public void setBackgroundColor() {
        this.setBackgroundColor(null);
    }

    public void setBackgroundColor(CompiereColor bg) {
        if (bg == null) {
            bg = new CompiereColor(AdempierePLAF.getFormBackground());
        }
        this.setOpaque(true);
        this.putClientProperty("CompiereBackground", bg);
        super.setBackground(bg.getFlatColor());
    }

    public CompiereColor getBackgroundColor() {
        try {
            return (CompiereColor)this.getClientProperty("CompiereBackground");
        }
        catch (Exception e) {
            System.err.println("CButton - ClientProperty: " + e.getMessage());
            return null;
        }
    }

    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    public boolean isMandatory() {
        return this.m_mandatory;
    }

    public void setReadWrite(boolean rw) {
        if (super.isEnabled() != rw) {
            super.setEnabled(rw);
        }
    }

    public boolean isReadWrite() {
        return super.isEnabled();
    }

    public void setValue(Object value) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
    }

    public Object getValue() {
        return this.getText();
    }

    public String getDisplay() {
        return this.getText();
    }
}

