/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.compiere.util.MSort;

public class CTable
extends JTable {
    protected int p_lastSortIndex = -1;
    protected boolean p_asc = true;
    private final int SLACK = 15;
    private final int MAXSIZE = 250;
    protected int p_keyColumnIndex = -1;
    private static Logger log = Logger.getLogger(CTable.class.getName());

    public CTable() {
        super(new DefaultTableModel());
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.setAutoResizeMode(0);
        this.getTableHeader().addMouseListener(new CTableMouseListener());
        this.setSurrendersFocusOnKeystroke(true);
        this.setRowHeight(this.getFont().getSize() + 8);
    }

    public void setKeyColumnIndex(int keyColumnIndex) {
        this.p_keyColumnIndex = keyColumnIndex;
    }

    public int getKeyColumnIndex() {
        return this.p_keyColumnIndex;
    }

    public Object getSelectedKeyColumnValue() {
        int row = this.getSelectedRow();
        if (row != -1 && this.p_keyColumnIndex != -1) {
            return this.getModel().getValueAt(row, this.p_keyColumnIndex);
        }
        return null;
    }

    public Object getSelectedValue() {
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1 || col == -1) {
            return null;
        }
        return this.getValueAt(row, col);
    }

    public void stopEditor(boolean saveValue) {
        ChangeEvent ce = new ChangeEvent(this);
        if (saveValue) {
            this.editingStopped(ce);
        } else {
            this.editingCanceled(ce);
        }
        if (this.getInputContext() != null) {
            this.getInputContext().endComposition();
        }
        this.transferFocus();
    }

    public void autoSize(boolean useColumnIdentifier) {
        TableModel model = this.getModel();
        int size = model.getColumnCount();
        for (int c = 0; c < size; ++c) {
            TableColumn column = this.getColumnModel().getColumn(c);
            if (useColumnIdentifier && (column.getIdentifier() == null || column.getMaxWidth() == 0 || column.getIdentifier().toString().length() == 0)) continue;
            int width = 0;
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = new DefaultTableCellRenderer();
            }
            Component comp = null;
            if (renderer != null) {
                comp = renderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0);
            }
            if (comp != null) {
                width = comp.getPreferredSize().width;
                width = Math.max(width, comp.getWidth());
                int col = column.getModelIndex();
                int maxRow = Math.min(20, this.getRowCount());
                try {
                    for (int row = 0; row < maxRow; ++row) {
                        renderer = this.getCellRenderer(row, col);
                        comp = renderer.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col);
                        int rowWidth = comp.getPreferredSize().width;
                        width = Math.max(width, rowWidth);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, column.getIdentifier().toString(), e);
                }
                width = Math.min(250, width + 15);
            }
            column.setPreferredWidth(width);
        }
    }

    protected void sort(int modelColumnIndex) {
        int selCol;
        int rows = this.getRowCount();
        if (rows == 0) {
            return;
        }
        this.p_asc = modelColumnIndex != this.p_lastSortIndex ? true : !this.p_asc;
        this.p_lastSortIndex = modelColumnIndex;
        log.config("#" + modelColumnIndex + " - rows=" + rows + ", asc=" + this.p_asc);
        Object selected = null;
        int selRow = this.getSelectedRow();
        int n = selCol = this.p_keyColumnIndex == -1 ? 0 : this.p_keyColumnIndex;
        if (this.getSelectedRow() >= 0) {
            selected = this.getValueAt(selRow, selCol);
        }
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        MSort sort = new MSort(0, null);
        sort.setSortAsc(this.p_asc);
        block0: while (true) {
            int i2;
            ArrayList<MSort> sortList = new ArrayList<MSort>(rows);
            for (i2 = 0; i2 < rows; ++i2) {
                Object value = model.getValueAt(i2, modelColumnIndex);
                sortList.add(new MSort(i2, value));
            }
            Collections.sort(sortList, sort);
            for (i2 = 0; i2 < rows; ++i2) {
                int index = ((MSort)sortList.get((int)i2)).index;
                if (i2 == index) continue;
                model.moveRow(i2, i2, index);
                continue block0;
            }
            break;
        }
        this.clearSelection();
        if (selected != null) {
            for (int r = 0; r < rows; ++r) {
                if (!selected.equals(this.getValueAt(r, selCol))) continue;
                this.setRowSelectionInterval(r, r);
                break;
            }
        }
    }

    public String toString() {
        return new StringBuffer("CTable[").append(this.getModel()).append("]").toString();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setRowHeight(this.getFont().getSize() + 8);
    }

    class CTableMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            int vc = CTable.this.getColumnModel().getColumnIndexAtX(e.getX());
            int mc = CTable.this.convertColumnIndexToModel(vc);
            CTable.this.sort(mc);
        }
    }
}

