/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CEditor;

public class CButton
extends JButton
implements CEditor {
    private boolean m_mandatory = false;
    private boolean m_readWrite = true;

    public CButton() {
        this(null, null);
    }

    public CButton(Icon icon) {
        this(null, icon);
    }

    public CButton(String text) {
        this(text, null);
    }

    public CButton(Action a2) {
        super(a2);
    }

    public CButton(String text, Icon icon) {
        super(text, icon);
    }

    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
        this.setBackgroundColor(new CompiereColor(bg));
        this.repaint();
    }

    public void setBackground(boolean error) {
    }

    public void setBackgroundColor() {
        this.setBackgroundColor(null);
    }

    public void setBackgroundColor(CompiereColor bg) {
        if (bg == null) {
            bg = new CompiereColor(AdempierePLAF.getFormBackground());
        }
        this.putClientProperty("CompiereBackground", bg);
        super.setBackground(bg.getFlatColor());
        this.repaint();
    }

    public CompiereColor getBackgroundColor() {
        try {
            return (CompiereColor)this.getClientProperty("CompiereBackground");
        }
        catch (Exception e) {
            System.err.println("CButton - ClientProperty: " + e.getMessage());
            return null;
        }
    }

    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    public boolean isMandatory() {
        return this.m_mandatory;
    }

    public void setReadWrite(boolean rw) {
        if (this.isEnabled() != rw) {
            this.setEnabled(rw);
        }
        this.m_readWrite = rw;
    }

    public boolean isReadWrite() {
        return this.m_readWrite;
    }

    public void setValue(Object value) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
    }

    public Object getValue() {
        return this.getText();
    }

    public String getDisplay() {
        return this.getText();
    }

    public void setText(String text) {
        char mnemonic;
        if (text == null) {
            super.setText(text);
            return;
        }
        int pos = text.indexOf("&");
        if (pos != -1 && (mnemonic = text.toUpperCase().charAt(pos + 1)) != ' ') {
            this.setMnemonic((int)mnemonic);
            text = text.substring(0, pos) + text.substring(pos + 1);
        }
        super.setText(text);
        if (this.getName() == null) {
            this.setName(text);
        }
    }

    public void setToolTipText(String text) {
        char mnemonic;
        if (text == null) {
            super.setText(text);
            return;
        }
        int pos = text.indexOf("&");
        if (pos != -1 && (mnemonic = text.toUpperCase().charAt(pos + 1)) != ' ') {
            this.setMnemonic((int)mnemonic);
            text = text.substring(0, pos) + text.substring(pos + 1);
        }
        super.setToolTipText(text);
        if (this.getName() == null) {
            this.setName(text);
        }
    }

    public void setActionCommand(String actionCommand) {
        super.setActionCommand(actionCommand);
        if (this.getName() == null && actionCommand != null && actionCommand.length() > 0) {
            this.setName(actionCommand);
        }
    }
}

