/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.sla;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MSLAGoal;
import org.compiere.model.MSLAMeasure;
import org.compiere.sla.SLACriteria;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class DeliveryAccuracy
extends SLACriteria {
    protected CLogger log = CLogger.getCLogger(this.getClass());

    public int createMeasures(MSLAGoal goal) {
        String sql = "SELECT M_InOut_ID, io.MovementDate-o.DatePromised, io.MovementDate, o.DatePromised, o.DocumentNo FROM M_InOut io INNER JOIN C_Order o ON (io.C_Order_ID=o.C_Order_ID) WHERE io.C_BPartner_ID=? AND NOT EXISTS (SELECT * FROM PA_SLA_Measure m WHERE m.PA_SLA_Goal_ID=? AND m.AD_Table_ID=319 AND m.Record_ID=io.M_InOut_ID)";
        int counter = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, goal.getC_BPartner_ID());
            pstmt.setInt(2, goal.getPA_SLA_Goal_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int M_InOut_ID = rs.getInt(1);
                BigDecimal MeasureActual = rs.getBigDecimal(2);
                Timestamp MovementDate = rs.getTimestamp(3);
                String Description = rs.getString(5) + ": " + rs.getTimestamp(4);
                if (!goal.isDateValid(MovementDate)) continue;
                MSLAMeasure measure = new MSLAMeasure(goal, MovementDate, MeasureActual, Description);
                measure.setLink(319, M_InOut_ID);
                if (!measure.save()) continue;
                ++counter;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "createMeasures", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return counter;
    }

    public BigDecimal calculateMeasure(MSLAGoal goal) {
        BigDecimal retValue = Env.ZERO;
        BigDecimal total = Env.ZERO;
        int count = 0;
        MSLAMeasure[] measures = goal.getAllMeasures();
        for (int i2 = 0; i2 < measures.length; ++i2) {
            MSLAMeasure measure = measures[i2];
            if (!measure.isActive() || goal.getValidFrom() != null && measure.getDateTrx().before(goal.getValidFrom()) || goal.getValidTo() != null && measure.getDateTrx().after(goal.getValidTo())) continue;
            total = total.add(measure.getMeasureActual());
            ++count;
            if (measure.isProcessed()) continue;
            measure.setProcessed(true);
            measure.save();
        }
        if (goal.getValidTo() != null && goal.getValidTo().after(new Timestamp(System.currentTimeMillis()))) {
            goal.setProcessed(true);
        }
        if (count != 0) {
            retValue = total.divide(new BigDecimal(count), 2, 4);
        }
        return retValue;
    }
}

