/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report.core;

import java.awt.Component;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.report.core.RColumn;
import org.compiere.report.core.RModel;
import org.compiere.util.DisplayType;

class ResultTableCellRenderer
extends DefaultTableCellRenderer
implements TableCellRenderer {
    private RModel m_rm = null;
    private RColumn m_rc = null;
    private DecimalFormat m_nFormat = null;
    private SimpleDateFormat m_dFormat = null;
    private JCheckBox m_check;

    public ResultTableCellRenderer(RModel rm, RColumn rc) {
        this.m_rm = rm;
        this.m_rc = rc;
        int dt = this.m_rc.getDisplayType();
        if (DisplayType.isNumeric(dt)) {
            super.setHorizontalAlignment(11);
            this.m_nFormat = DisplayType.getNumberFormat(dt);
        } else if (DisplayType.isDate(this.m_rc.getDisplayType())) {
            super.setHorizontalAlignment(11);
            this.m_dFormat = DisplayType.getDateFormat(dt);
        } else if (dt == 20) {
            this.m_check = new JCheckBox();
            this.m_check.setMargin(new Insets(0, 0, 0, 0));
            this.m_check.setHorizontalAlignment(0);
        }
    }

    public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component c = this.m_check;
        if (c == null) {
            c = super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, col);
        }
        if (this.m_rm.isCellEditable(row, col)) {
            c.setBackground(AdempierePLAF.getFieldBackground_Normal());
        } else {
            c.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        }
        if (this.m_rm.isGroupRow(row)) {
            c.setFont(c.getFont().deriveFont(1));
        }
        this.setValue(value);
        return c;
    }

    protected void setValue(Object value) {
        if (this.m_check != null) {
            boolean sel = false;
            if (value != null && ((Boolean)value).booleanValue()) {
                sel = true;
            }
            this.m_check.setSelected(sel);
            return;
        }
        if (value == null) {
            this.setText("");
        } else if (this.m_nFormat != null) {
            try {
                this.setText(this.m_nFormat.format(value));
            }
            catch (Exception e) {
                this.setText(value.toString());
            }
        } else if (this.m_dFormat != null) {
            try {
                this.setText(this.m_dFormat.format(value));
            }
            catch (Exception e) {
                this.setText(value.toString());
            }
        } else {
            this.setText(value.toString());
        }
    }
}

