/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.compiere.report.core.RColumn;
import org.compiere.report.core.RModelData;
import org.compiere.util.CLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RModel
implements Serializable {
    public static final String TABLE_ALIAS = "zz";
    public static final String FUNCTION_COUNT = "Count";
    public static final String FUNCTION_SUM = "Sum";
    private RModelData m_data = null;
    private boolean m_editable = false;
    private static CLogger log = CLogger.getCLogger(RModel.class);

    public RModel(String TableName) {
        this.m_data = new RModelData(TableName);
    }

    protected RColumn getRColumn(int col) {
        if (col < 0 || col > this.m_data.cols.size()) {
            throw new IllegalArgumentException("Column invalid");
        }
        return this.m_data.cols.get(col);
    }

    public void addColumn(RColumn rc) {
        this.m_data.cols.add(rc);
    }

    public void addColumn(RColumn rc, int index) {
        this.m_data.cols.add(index, rc);
    }

    public void addRow() {
        this.m_data.rows.add(new ArrayList());
        this.m_data.rowsMeta.add(null);
    }

    public void addRow(int index) {
        this.m_data.rows.add(index, new ArrayList());
        this.m_data.rowsMeta.add(index, null);
    }

    public void addRow(ArrayList<Object> l) {
        this.m_data.rows.add(l);
        this.m_data.rowsMeta.add(null);
    }

    public void addRow(ArrayList<Object> l, int index) {
        this.m_data.rows.add(index, l);
        this.m_data.rowsMeta.add(index, null);
    }

    public int getColumnIndex(String columnName) {
        if (columnName == null || columnName.length() == 0) {
            return -1;
        }
        for (int i2 = 0; i2 < this.m_data.cols.size(); ++i2) {
            RColumn rc = this.m_data.cols.get(i2);
            if (!rc.getColSQL().startsWith(columnName)) continue;
            log.fine("Column " + i2 + " " + rc.getColSQL() + " = " + columnName);
            return i2;
        }
        return -1;
    }

    public void query(Properties ctx, String whereClause, String orderClause) {
        this.m_data.query(ctx, whereClause, orderClause);
    }

    public void setGroup(String columnName) {
        this.setGroup(this.getColumnIndex(columnName));
    }

    public void setGroup(int col) {
        log.config("RModel.setGroup col=" + col);
        if (col < 0 || col >= this.m_data.cols.size()) {
            return;
        }
        Integer ii = new Integer(col);
        if (!this.m_data.groups.contains(ii)) {
            this.m_data.groups.add(ii);
        }
    }

    public boolean isGroupRow(int row) {
        return this.m_data.isGroupRow(row);
    }

    public void setFunction(String columnName, String function) {
        this.setFunction(this.getColumnIndex(columnName), function);
    }

    public void setFunction(int col, String function) {
        log.config("RModel.setFunction col=" + col + " - " + function);
        if (col < 0 || col >= this.m_data.cols.size()) {
            return;
        }
        this.m_data.functions.put(new Integer(col), function);
    }

    public int getRowCount() {
        return this.m_data.rows.size();
    }

    public int getColumnCount() {
        return this.m_data.cols.size();
    }

    public String getColumnName(int col) {
        if (col < 0 || col > this.m_data.cols.size()) {
            throw new IllegalArgumentException("Column invalid");
        }
        RColumn rc = this.m_data.cols.get(col);
        if (rc != null) {
            return rc.getColHeader();
        }
        return null;
    }

    public Class getColumnClass(int col) {
        if (col < 0 || col > this.m_data.cols.size()) {
            throw new IllegalArgumentException("Column invalid");
        }
        RColumn rc = this.m_data.cols.get(col);
        if (rc != null) {
            return rc.getColClass();
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.m_editable;
    }

    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.m_data.rows.size()) {
            return null;
        }
        if (col < 0 || col >= this.m_data.cols.size()) {
            return null;
        }
        ArrayList<Object> myRow = this.m_data.rows.get(row);
        if (myRow == null || col >= myRow.size()) {
            return null;
        }
        return myRow.get(col);
    }

    public void setValueAt(Object aValue, int row, int col) {
        if (row < 0 || row >= this.m_data.rows.size()) {
            throw new IllegalArgumentException("Row invalid");
        }
        if (col < 0 || col >= this.m_data.cols.size()) {
            throw new IllegalArgumentException("Column invalid");
        }
        if (!this.isCellEditable(row, col)) {
            throw new IllegalArgumentException("Cell is read only");
        }
        ArrayList<Object> myRow = this.m_data.rows.get(row);
        if (myRow == null) {
            throw new IllegalArgumentException("Row not initialized");
        }
        if (col >= myRow.size()) {
            while (myRow.size() < this.m_data.cols.size()) {
                myRow.add(null);
            }
        }
        myRow.set(col, aValue);
    }

    public void moveRow(int from, int to) {
        this.m_data.moveRow(from, to);
    }
}

