/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class FinBalance
extends SvrProcess {
    protected static CLogger s_log = CLogger.getCLogger(FinBalance.class);
    private int p_C_AcctSchema_ID = 0;
    private boolean p_IsRecreate = false;

    public FinBalance() {
        this.log.info(" ");
    }

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("IsRecreate")) {
                this.p_IsRecreate = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.fine("C_AcctSchema_ID=" + this.p_C_AcctSchema_ID + ", IsRecreate=" + this.p_IsRecreate);
        if (this.p_C_AcctSchema_ID != 0) {
            FinBalance.updateBalance(this.p_C_AcctSchema_ID, this.p_IsRecreate);
        } else {
            FinBalance.updateBalanceClient(this.getCtx(), this.getAD_Client_ID(), this.p_IsRecreate);
        }
        return "";
    }

    public static String deleteBalance(int C_AcctSchema_ID) {
        StringBuffer sql = new StringBuffer("DELETE FROM Fact_Acct_Balance WHERE ");
        if (C_AcctSchema_ID != 0) {
            sql.append("C_AcctSchema_ID=").append(C_AcctSchema_ID);
        }
        int no = DB.executeUpdate(sql.toString(), null);
        String msg = "@Deleted@=" + no;
        s_log.fine("C_AcctSchema_ID=" + C_AcctSchema_ID + " #=" + no);
        return msg;
    }

    public static String updateBalance(int C_AcctSchema_ID, boolean deleteFirst) {
        int no;
        s_log.info("C_AcctSchema_ID=" + C_AcctSchema_ID + " - DeleteFirst=" + deleteFirst);
        long start = System.currentTimeMillis();
        if (deleteFirst) {
            int no2 = DB.executeUpdate("DELETE Fact_Acct_Balance WHERE C_AcctSchema_ID=?", C_AcctSchema_ID, null);
            s_log.fine("Deleted=" + no2);
        }
        String sql = "UPDATE Fact_Acct_Balance ab SET (AmtAcctDr, AmtAcctCr, Qty)= (SELECT COALESCE(SUM(AmtAcctDr),0), COALESCE(SUM(AmtAcctCr),0), COALESCE(SUM(Qty),0) FROM Fact_Acct a WHERE a.AD_Client_ID=ab.AD_Client_ID AND a.AD_Org_ID=ab.AD_Org_ID AND a.C_AcctSchema_ID=ab.C_AcctSchema_ID AND TRUNC(a.DateAcct)=TRUNC(ab.DateAcct) AND a.Account_ID=ab.Account_ID AND a.PostingType=ab.PostingType AND COALESCE(a.M_Product_ID,0)=COALESCE(ab.M_Product_ID,0) AND COALESCE(a.C_BPartner_ID,0)=COALESCE(ab.C_BPartner_ID,0) AND COALESCE(a.C_Project_ID,0)=COALESCE(ab.C_Project_ID,0) AND COALESCE(a.AD_OrgTrx_ID,0)=COALESCE(ab.AD_OrgTrx_ID,0) AND COALESCE(a.C_SalesRegion_ID,0)=COALESCE(ab.C_SalesRegion_ID,0) AND COALESCE(a.C_Activity_ID,0)=COALESCE(ab.C_Activity_ID,0) AND COALESCE(a.C_Campaign_ID,0)=COALESCE(ab.C_Campaign_ID,0) AND COALESCE(a.C_LocTo_ID,0)=COALESCE(ab.C_LocTo_ID,0) AND COALESCE(a.C_LocFrom_ID,0)=COALESCE(ab.C_LocFrom_ID,0) AND COALESCE(a.User1_ID,0)=COALESCE(ab.User1_ID,0) AND COALESCE(a.User2_ID,0)=COALESCE(ab.User2_ID,0) AND COALESCE(a.GL_Budget_ID,0)=COALESCE(ab.GL_Budget_ID,0) GROUP BY AD_Client_ID,AD_Org_ID, C_AcctSchema_ID, TRUNC(DateAcct), Account_ID, PostingType, M_Product_ID, C_BPartner_ID, C_Project_ID, AD_OrgTrx_ID, C_SalesRegion_ID, C_Activity_ID, C_Campaign_ID, C_LocTo_ID, C_LocFrom_ID, User1_ID, User2_ID, GL_Budget_ID) WHERE C_AcctSchema_ID=" + C_AcctSchema_ID + " AND EXISTS (SELECT 1 FROM Fact_Acct a " + "WHERE a.AD_Client_ID=ab.AD_Client_ID AND a.AD_Org_ID=ab.AD_Org_ID" + " AND a.C_AcctSchema_ID=ab.C_AcctSchema_ID AND TRUNC(a.DateAcct)=TRUNC(ab.DateAcct)" + " AND a.Account_ID=ab.Account_ID AND a.PostingType=ab.PostingType" + " AND COALESCE(a.M_Product_ID,0)=COALESCE(ab.M_Product_ID,0) AND COALESCE(a.C_BPartner_ID,0)=COALESCE(ab.C_BPartner_ID,0)" + " AND COALESCE(a.C_Project_ID,0)=COALESCE(ab.C_Project_ID,0) AND COALESCE(a.AD_OrgTrx_ID,0)=COALESCE(ab.AD_OrgTrx_ID,0)" + "\tAND COALESCE(a.C_SalesRegion_ID,0)=COALESCE(ab.C_SalesRegion_ID,0) AND COALESCE(a.C_Activity_ID,0)=COALESCE(ab.C_Activity_ID,0)" + " AND COALESCE(a.C_Campaign_ID,0)=COALESCE(ab.C_Campaign_ID,0) AND COALESCE(a.C_LocTo_ID,0)=COALESCE(ab.C_LocTo_ID,0) AND COALESCE(a.C_LocFrom_ID,0)=COALESCE(ab.C_LocFrom_ID,0)" + " AND COALESCE(a.User1_ID,0)=COALESCE(ab.User1_ID,0) AND COALESCE(a.User2_ID,0)=COALESCE(ab.User2_ID,0) AND COALESCE(a.GL_Budget_ID,0)=COALESCE(ab.GL_Budget_ID,0) " + "GROUP BY AD_Client_ID,AD_Org_ID," + " C_AcctSchema_ID, TRUNC(DateAcct)," + " Account_ID, PostingType," + " M_Product_ID, C_BPartner_ID," + " C_Project_ID, AD_OrgTrx_ID," + " C_SalesRegion_ID, C_Activity_ID," + " C_Campaign_ID, C_LocTo_ID, C_LocFrom_ID," + " User1_ID, User2_ID, GL_Budget_ID)";
        if (!deleteFirst) {
            no = DB.executeUpdate(sql, null);
            s_log.fine("Updates=" + no);
        }
        sql = "INSERT INTO Fact_Acct_Balance (AD_Client_ID, AD_Org_ID, C_AcctSchema_ID, DateAcct, Account_ID, PostingType, M_Product_ID, C_BPartner_ID,\tC_Project_ID, AD_OrgTrx_ID,\tC_SalesRegion_ID,C_Activity_ID, C_Campaign_ID, C_LocTo_ID, C_LocFrom_ID, User1_ID, User2_ID, GL_Budget_ID, AmtAcctDr, AmtAcctCr, Qty) SELECT AD_Client_ID, AD_Org_ID, C_AcctSchema_ID, TRUNC(DateAcct), Account_ID, PostingType, M_Product_ID, C_BPartner_ID, C_Project_ID, AD_OrgTrx_ID, C_SalesRegion_ID,C_Activity_ID, C_Campaign_ID, C_LocTo_ID, C_LocFrom_ID, User1_ID, User2_ID, GL_Budget_ID, COALESCE(SUM(AmtAcctDr),0), COALESCE(SUM(AmtAcctCr),0), COALESCE(SUM(Qty),0) FROM Fact_Acct a WHERE C_AcctSchema_ID=" + C_AcctSchema_ID;
        if (!deleteFirst) {
            sql = sql + " AND NOT EXISTS (SELECT 1 FROM Fact_Acct_Balance x WHERE a.AD_Client_ID=x.AD_Client_ID AND a.AD_Org_ID=x.AD_Org_ID AND a.C_AcctSchema_ID=x.C_AcctSchema_ID AND TRUNC(a.DateAcct)=TRUNC(x.DateAcct) AND a.Account_ID=x.Account_ID AND a.PostingType=x.PostingType AND COALESCE(a.M_Product_ID,0)=COALESCE(x.M_Product_ID,0) AND COALESCE(a.C_BPartner_ID,0)=COALESCE(x.C_BPartner_ID,0) AND COALESCE(a.C_Project_ID,0)=COALESCE(x.C_Project_ID,0) AND COALESCE(a.AD_OrgTrx_ID,0)=COALESCE(x.AD_OrgTrx_ID,0) AND COALESCE(a.C_SalesRegion_ID,0)=COALESCE(x.C_SalesRegion_ID,0) AND COALESCE(a.C_Activity_ID,0)=COALESCE(x.C_Activity_ID,0) AND COALESCE(a.C_Campaign_ID,0)=COALESCE(x.C_Campaign_ID,0) AND COALESCE(a.C_LocTo_ID,0)=COALESCE(x.C_LocTo_ID,0) AND COALESCE(a.C_LocFrom_ID,0)=COALESCE(x.C_LocFrom_ID,0) AND COALESCE(a.User1_ID,0)=COALESCE(x.User1_ID,0) AND COALESCE(a.User2_ID,0)=COALESCE(x.User2_ID,0) AND COALESCE(a.GL_Budget_ID,0)=COALESCE(x.GL_Budget_ID,0) )";
        }
        sql = sql + " GROUP BY AD_Client_ID,AD_Org_ID, C_AcctSchema_ID, TRUNC(DateAcct), Account_ID, PostingType, M_Product_ID, C_BPartner_ID, C_Project_ID, AD_OrgTrx_ID, C_SalesRegion_ID, C_Activity_ID, C_Campaign_ID, C_LocTo_ID, C_LocFrom_ID, User1_ID, User2_ID, GL_Budget_ID";
        no = DB.executeUpdate(sql, null);
        s_log.fine("Inserts=" + no);
        start = System.currentTimeMillis() - start;
        s_log.info(start / 1000L + " sec");
        return "";
    }

    public static String updateBalanceClient(Properties ctx, int AD_Client_ID, boolean deleteFirst) {
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(ctx, AD_Client_ID);
        for (int i2 = 0; i2 < ass.length; ++i2) {
            FinBalance.updateBalance(ass[i2].getC_AcctSchema_ID(), deleteFirst);
        }
        return "";
    }

    public static void main(String[] args) {
        FinBalance finBalance1 = new FinBalance();
    }
}

