/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MField;
import org.compiere.model.MTab;
import org.compiere.model.MWindow;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;

public class WindowCopy
extends SvrProcess {
    private int p_AD_WindowTo_ID = 0;
    private int p_AD_WindowFrom_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Window_ID")) {
                this.p_AD_WindowFrom_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.p_AD_WindowTo_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        this.log.info("doIt - To AD_Window_ID=" + this.p_AD_WindowTo_ID + ", From=" + this.p_AD_WindowFrom_ID);
        MWindow from = new MWindow(this.getCtx(), this.p_AD_WindowFrom_ID, this.get_TrxName());
        if (from.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ (from->) @AD_Window_ID@");
        }
        MWindow to = new MWindow(this.getCtx(), this.p_AD_WindowTo_ID, this.get_TrxName());
        if (to.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ (to<-) @AD_Window_ID@");
        }
        int tabCount = 0;
        int fieldCount = 0;
        MTab[] oldTabs = from.getTabs(false, this.get_TrxName());
        for (int i2 = 0; i2 < oldTabs.length; ++i2) {
            MTab oldTab = oldTabs[i2];
            MTab newTab = new MTab(to, oldTab);
            if (newTab.save()) {
                ++tabCount;
                MField[] oldFields = oldTab.getFields(false, this.get_TrxName());
                for (int j = 0; j < oldFields.length; ++j) {
                    MField oldField = oldFields[j];
                    MField newField = new MField(newTab, oldField);
                    if (newField.save()) {
                        ++fieldCount;
                        continue;
                    }
                    throw new AdempiereUserError("@Error@ @AD_Field_ID@");
                }
                continue;
            }
            throw new AdempiereUserError("@Error@ @AD_Tab_ID@");
        }
        return "@Copied@ #" + tabCount + "/" + fieldCount;
    }
}

