/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MTree;
import org.compiere.model.MTree_Base;
import org.compiere.model.MTree_Node;
import org.compiere.model.MTree_NodeBP;
import org.compiere.model.MTree_NodePR;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class TreeMaintenance
extends SvrProcess {
    private int m_AD_Tree_ID;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.m_AD_Tree_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        this.log.info("doIt - AD_Tree_ID=" + this.m_AD_Tree_ID);
        if (this.m_AD_Tree_ID == 0) {
            throw new IllegalArgumentException("Tree_ID = 0");
        }
        MTree tree = new MTree(this.getCtx(), this.m_AD_Tree_ID, this.get_TrxName());
        if (tree == null || tree.getAD_Tree_ID() == 0) {
            throw new IllegalArgumentException("No Tree -" + tree);
        }
        if ("BB".equals(tree.getTreeType())) {
            return "BOM Trees not implemented";
        }
        return this.verifyTree(tree);
    }

    private String verifyTree(MTree_Base tree) {
        CharSequence sql;
        String nodeTableName = tree.getNodeTableName();
        String sourceTableName = tree.getSourceTableName(true);
        String sourceTableKey = sourceTableName + "_ID";
        int AD_Client_ID = tree.getAD_Client_ID();
        int C_Element_ID = 0;
        if ("EV".equals(tree.getTreeType()) && (C_Element_ID = DB.getSQLValue(null, (String)(sql = "SELECT C_Element_ID FROM C_Element WHERE AD_Tree_ID=" + tree.getAD_Tree_ID()))) <= 0) {
            throw new IllegalStateException("No Account Element found");
        }
        sql = new StringBuffer();
        ((StringBuffer)sql).append("DELETE ").append(nodeTableName).append(" WHERE AD_Tree_ID=").append(tree.getAD_Tree_ID()).append(" AND Node_ID NOT IN (SELECT ").append(sourceTableKey).append(" FROM ").append(sourceTableName).append(" WHERE AD_Client_ID=").append(AD_Client_ID);
        if (C_Element_ID > 0) {
            ((StringBuffer)sql).append(" AND C_Element_ID=").append(C_Element_ID);
        }
        ((StringBuffer)sql).append(")");
        this.log.finer(((StringBuffer)sql).toString());
        int deletes = DB.executeUpdate(((StringBuffer)sql).toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(deletes), tree.getName() + " Deleted");
        if (!tree.isAllNodes()) {
            return tree.getName() + " OK";
        }
        int inserts = 0;
        sql = new StringBuffer();
        ((StringBuffer)sql).append("SELECT ").append(sourceTableKey).append(" FROM ").append(sourceTableName).append(" WHERE AD_Client_ID=").append(AD_Client_ID);
        if (C_Element_ID > 0) {
            ((StringBuffer)sql).append(" AND C_Element_ID=").append(C_Element_ID);
        }
        ((StringBuffer)sql).append(" AND ").append(sourceTableKey).append("  NOT IN (SELECT Node_ID FROM ").append(nodeTableName).append(" WHERE AD_Tree_ID=").append(tree.getAD_Tree_ID()).append(")");
        this.log.finer(((StringBuffer)sql).toString());
        boolean ok = true;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(((StringBuffer)sql).toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int Node_ID = rs.getInt(1);
                PO node = null;
                if (nodeTableName.equals("AD_TreeNode")) {
                    node = new MTree_Node(tree, Node_ID);
                } else if (nodeTableName.equals("AD_TreeNodeBP")) {
                    node = new MTree_NodeBP(tree, Node_ID);
                } else if (nodeTableName.equals("AD_TreeNodePR")) {
                    node = new MTree_NodePR(tree, Node_ID);
                }
                if (node == null) {
                    this.log.log(Level.SEVERE, "verifyTree - no Model for " + nodeTableName);
                    continue;
                }
                if (node.save()) {
                    ++inserts;
                    continue;
                }
                this.log.log(Level.SEVERE, "verifyTree - Could not add to " + tree + " Node_ID=" + Node_ID);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "verifyTree", e);
            ok = false;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.addLog(0, null, new BigDecimal(inserts), tree.getName() + " Inserted");
        return tree.getName() + (ok ? " OK" : " Error");
    }
}

