/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MTab;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class TabCreateFields
extends SvrProcess {
    private int p_AD_Tab_ID = 0;

    protected void prepare() {
        this.p_AD_Tab_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MTab tab = new MTab(this.getCtx(), this.p_AD_Tab_ID, this.get_TrxName());
        if (this.p_AD_Tab_ID == 0 || tab == null || tab.get_ID() == 0) {
            throw new AdempiereSystemError("@NotFound@: @AD_Tab_ID@ " + this.p_AD_Tab_ID);
        }
        this.log.info(tab.toString());
        int count = 0;
        String sql = "SELECT * FROM AD_Column c WHERE NOT EXISTS (SELECT * FROM AD_Field f WHERE c.AD_Column_ID=f.AD_Column_ID AND c.AD_Table_ID=? AND f.AD_Tab_ID=?) AND AD_Table_ID=? AND NOT (Name LIKE 'Created%' OR Name LIKE 'Updated%') AND IsActive='Y' ORDER BY Name";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, tab.getAD_Table_ID());
            pstmt.setInt(2, tab.getAD_Tab_ID());
            pstmt.setInt(3, tab.getAD_Table_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MColumn column = new MColumn(this.getCtx(), rs, this.get_TrxName());
                MField field = new MField(tab);
                field.setColumn(column);
                if (column.isKey()) {
                    field.setIsDisplayed(false);
                }
                if (!field.save()) continue;
                this.addLog(0, null, null, column.getName());
                ++count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return "@Created@ #" + count;
    }
}

