/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MSequence;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class SequenceCheck
extends SvrProcess {
    private static CLogger s_log = CLogger.getCLogger(SequenceCheck.class);

    protected void prepare() {
    }

    protected String doIt() throws Exception {
        this.log.info("");
        SequenceCheck.checkTableSequences(Env.getCtx(), this);
        SequenceCheck.checkTableID(Env.getCtx(), this);
        SequenceCheck.checkClientSequences(Env.getCtx(), this);
        return "Sequence Check";
    }

    public static void validate(Properties ctx) {
        try {
            SequenceCheck.checkTableSequences(ctx, null);
            SequenceCheck.checkTableID(ctx, null);
            SequenceCheck.checkClientSequences(ctx, null);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "validate", e);
        }
    }

    private static void checkTableSequences(Properties ctx, SvrProcess sp) {
        String trxName = null;
        if (sp != null) {
            trxName = sp.get_TrxName();
        }
        String sql = "SELECT TableName FROM AD_Table t WHERE IsActive='Y' AND IsView='N' AND NOT EXISTS (SELECT * FROM AD_Sequence s WHERE UPPER(s.Name)=UPPER(t.TableName) AND s.IsTableID='Y')";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString(1);
                if (MSequence.createTableSequence(ctx, tableName, trxName)) {
                    if (sp != null) {
                        sp.addLog(0, null, null, tableName);
                        continue;
                    }
                    s_log.fine(tableName);
                    continue;
                }
                rs.close();
                throw new Exception("Error creating Table Sequence for " + tableName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        sql = "UPDATE AD_Sequence s SET Name = (SELECT TableName FROM AD_Table t WHERE t.IsView='N' AND UPPER(s.Name)=UPPER(t.TableName)) WHERE s.IsTableID='Y' AND EXISTS (SELECT * FROM AD_Table t WHERE t.IsActive='Y' AND t.IsView='N' AND UPPER(s.Name)=UPPER(t.TableName) AND s.Name<>t.TableName)";
        int no = DB.executeUpdate(sql, trxName);
        if (no > 0) {
            if (sp != null) {
                sp.addLog(0, null, null, "SyncName #" + no);
            } else {
                s_log.fine("Sync #" + no);
            }
        }
        if (no >= 0) {
            return;
        }
        sql = "SELECT TableName, s.Name FROM AD_Table t, AD_Sequence s WHERE t.IsActive='Y' AND t.IsView='N' AND UPPER(s.Name)=UPPER(t.TableName) AND s.Name<>t.TableName";
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String TableName = rs.getString(1);
                String SeqName = rs.getString(2);
                sp.addLog(0, null, null, "ERROR: TableName=" + TableName + " - Sequence=" + SeqName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
    }

    private static void checkTableID(Properties ctx, SvrProcess sp) {
        int IDRangeEnd = DB.getSQLValue(null, "SELECT IDRangeEnd FROM AD_System");
        if (IDRangeEnd <= 0) {
            IDRangeEnd = DB.getSQLValue(null, "SELECT MIN(IDRangeStart)-1 FROM AD_Replication");
        }
        s_log.info("IDRangeEnd = " + IDRangeEnd);
        String sql = "SELECT * FROM AD_Sequence WHERE IsTableID='Y' ORDER BY Name";
        int counter = 0;
        CPreparedStatement pstmt = null;
        String trxName = null;
        if (sp != null) {
            trxName = sp.get_TrxName();
        }
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String msg;
                MSequence seq = new MSequence(ctx, rs, trxName);
                int old = seq.getCurrentNext();
                int oldSys = seq.getCurrentNextSys();
                if (!seq.validateTableIDValue()) continue;
                if (seq.getCurrentNext() != old) {
                    msg = seq.getName() + " ID  " + old + " -> " + seq.getCurrentNext();
                    if (sp != null) {
                        sp.addLog(0, null, null, msg);
                    } else {
                        s_log.fine(msg);
                    }
                }
                if (seq.getCurrentNextSys() != oldSys) {
                    msg = seq.getName() + " Sys " + oldSys + " -> " + seq.getCurrentNextSys();
                    if (sp != null) {
                        sp.addLog(0, null, null, msg);
                    } else {
                        s_log.fine(msg);
                    }
                }
                if (seq.save()) {
                    ++counter;
                    continue;
                }
                s_log.severe("Not updated: " + seq);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        s_log.fine("#" + counter);
    }

    private static void checkClientSequences(Properties ctx, SvrProcess sp) {
        String trxName = null;
        if (sp != null) {
            trxName = sp.get_TrxName();
        }
        MClient[] clients = MClient.getAll(ctx);
        for (int i2 = 0; i2 < clients.length; ++i2) {
            MClient client = clients[i2];
            if (!client.isActive()) continue;
            MSequence.checkClientSequences(ctx, client.getAD_Client_ID(), trxName);
        }
    }
}

