/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class RoleAccessUpdate
extends SvrProcess {
    private int p_AD_Role_ID = 0;
    private int p_AD_Client_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Role_ID")) {
                this.p_AD_Role_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Client_ID")) {
                this.p_AD_Client_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("AD_Client_ID=" + this.p_AD_Client_ID + ", AD_Role_ID=" + this.p_AD_Role_ID);
        if (this.p_AD_Role_ID != 0) {
            this.updateRole(new MRole(this.getCtx(), this.p_AD_Role_ID, this.get_TrxName()));
        } else {
            String sql = "SELECT * FROM AD_Role ";
            if (this.p_AD_Client_ID != 0) {
                sql = sql + "WHERE AD_Client_ID=? ";
            }
            sql = sql + "ORDER BY AD_Client_ID, Name";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                if (this.p_AD_Client_ID != 0) {
                    pstmt.setInt(1, this.p_AD_Client_ID);
                }
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.updateRole(new MRole(this.getCtx(), rs, this.get_TrxName()));
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                Object var2_2 = null;
            }
        }
        return "";
    }

    private void updateRole(MRole role) {
        this.addLog(0, null, null, role.getName() + ": " + role.updateAccessRecords());
    }
}

