/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.sql.RowSet;
import org.compiere.model.MSystem;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.RemoteMergeDataVO;
import org.compiere.process.RemoteSetupVO;
import org.compiere.process.RemoteUpdateVO;
import org.compiere.process.ReplicationLocal;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class ReplicationRemote
extends SvrProcess {
    private MSystem m_system = null;
    private Timestamp m_startDate = new Timestamp(System.currentTimeMillis());

    public void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.m_system = MSystem.get(this.getCtx());
    }

    public String doIt() throws Exception {
        ProcessInfo pi = this.getProcessInfo();
        this.log.info("doIt - " + pi.getTitle());
        if (pi.getSerializableObject() instanceof RemoteSetupVO) {
            return this.setupRemote();
        }
        if (pi.getSerializableObject() instanceof RemoteMergeDataVO) {
            return this.mergeDataWithCentral();
        }
        if (pi.getSerializableObject() instanceof RemoteUpdateVO) {
            return this.receiveUpdateFromCentral();
        }
        if (pi.getSerializableObject() instanceof Timestamp) {
            return this.exit();
        }
        throw new Exception("ReplicationRemote - unknown VO - " + pi.getSerializableObject());
    }

    private String setupRemote() throws Exception {
        ProcessInfo pi = this.getProcessInfo();
        RemoteSetupVO data = (RemoteSetupVO)pi.getSerializableObject();
        this.log.info("setupRemote Start (" + pi + ") " + data);
        RowSet rs = data.ReplicationTable;
        try {
            if (data.IDRangeStart == null || data.IDRangeEnd == null) {
                throw new Exception("setupRemote - IDRange cannot be null");
            }
            if (!data.Test.booleanValue()) {
                this.setupRemoteAD_System(data.IDRangeStart, data.IDRangeEnd);
                this.setupRemoteAD_Sequence(data.IDRangeStart);
                this.setupRemoteC_DocType(data.AD_Client_ID, data.Prefix, data.Suffix);
            }
            while (rs.next()) {
                int AD_Table_ID = rs.getInt(1);
                String ReplicationType = rs.getString(2);
                String TableName = rs.getString(3);
                this.log.fine("setupRemote - " + TableName + " - " + ReplicationType);
                if (data.Test.booleanValue()) continue;
                this.setupRemoteAD_Table(TableName, ReplicationType);
            }
            pi.setSummary("OK - Test=" + data.Test, false);
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "setupRemote", ex);
            pi.setSummary(ex.toString(), true);
        }
        Object result = this.doIt(ReplicationLocal.START, "init", new Object[]{this.m_system});
        if (result == null || !Boolean.TRUE.equals(result)) {
            throw new Exception("setupRemote - Init Error - " + result);
        }
        pi.setSerializableObject(null);
        pi.addLog(0, 0, this.m_startDate, null, null);
        this.log.info("setupRemote End (" + pi + ") " + data);
        return "Remote SetupRemote OK";
    }

    private void setupRemoteAD_System(BigDecimal IDRangeStart, BigDecimal IDRangeEnd) throws Exception {
        this.m_system.setIDRangeStart(IDRangeStart);
        this.m_system.setIDRangeEnd(IDRangeEnd);
        this.m_system.setReplicationType("M");
        this.m_system.save();
    }

    private void setupRemoteAD_Sequence(BigDecimal IDRangeStart) throws Exception {
        String sql = "UPDATE AD_Sequence SET StartNo = " + IDRangeStart + " WHERE IsTableID='Y' AND StartNo < " + IDRangeStart;
        int no = DB.executeUpdate(sql, this.get_TrxName());
        if (no == -1) {
            throw new Exception("setupRemoteAD_Sequence_Start");
        }
        sql = "UPDATE AD_Sequence SET CurrentNext = " + IDRangeStart + " WHERE IsTableID='Y' AND CurrentNext < " + IDRangeStart;
        no = DB.executeUpdate(sql, this.get_TrxName());
        if (no == -1) {
            throw new Exception("setupRemoteAD_Sequence_Next");
        }
        sql = "UPDATE AD_Sequence SET CurrentNextSys = -1 WHERE IsTableID='Y' AND CurrentNextSys <> -1";
        no = DB.executeUpdate(sql, this.get_TrxName());
        if (no == -1) {
            throw new Exception("setupRemoteAD_Sequence_Sys");
        }
    }

    private void setupRemoteC_DocType(int AD_Client_ID, String Prefix, String Suffix) throws Exception {
        String sql;
        int no;
        if (Prefix == null) {
            Prefix = "";
        }
        if (Suffix == null) {
            Suffix = "";
        }
        if ((no = DB.executeUpdate(sql = "UPDATE AD_Sequence SET Prefix=" + DB.TO_STRING(Prefix) + ", Suffix=" + DB.TO_STRING(Suffix) + " WHERE AD_Sequence_ID IN (SELECT DocNoSequence_ID FROM C_DocType" + " WHERE AD_Client_ID=" + AD_Client_ID + " AND DocNoSequence_ID IS NOT NULL)", this.get_TrxName())) == -1) {
            throw new Exception("setupRemoteC_DocType_DocNo");
        }
        sql = "UPDATE AD_Sequence SET Prefix=" + DB.TO_STRING(Prefix) + ", Suffix=" + DB.TO_STRING(Suffix) + " WHERE AD_Sequence_ID IN (SELECT BatchNoSequence_ID FROM C_DocType" + " WHERE AD_Client_ID=" + AD_Client_ID + " AND BatchNoSequence_ID IS NOT NULL)";
        no = DB.executeUpdate(sql, this.get_TrxName());
        if (no == -1) {
            throw new Exception("setupRemoteC_DocType_Batch");
        }
    }

    private void setupRemoteAD_Table(String TableName, String ReplicationType) throws Exception {
        String sql = "UPDATE AD_Table SET ReplicationType = '" + ReplicationType + "' WHERE TableName='" + TableName + "' AND ReplicationType <> '" + ReplicationType + "'";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        if (no == -1) {
            throw new Exception("setupRemoteAD_Table");
        }
    }

    private String mergeDataWithCentral() throws Exception {
        ProcessInfo pi = this.getProcessInfo();
        RemoteMergeDataVO data = (RemoteMergeDataVO)pi.getSerializableObject();
        this.log.info("mergeDataWithCentral Start (" + pi + ") " + data);
        RowSet sourceRS = data.CentralData;
        if (sourceRS == null) {
            this.log.log(Level.SEVERE, "mergeDataWithCentral - No Data - " + data);
        } else if (!data.Test.booleanValue()) {
            RowSet targetRS = ReplicationLocal.getRowSet(data.Sql, null);
            Object result = this.doIt(ReplicationLocal.START, "sync", new Object[]{data.TableName, data.KeyColumns, sourceRS, targetRS, data.Test, Boolean.TRUE});
            this.log.fine("receiveUpdateFromCentral - " + data.TableName + " - " + result);
            pi.setSerializableObject(null);
            boolean replicated = ReplicationLocal.isReplicated(result);
            if (!replicated) {
                pi.setError(true);
            }
            if (result != null) {
                pi.addLog(0, null, null, result.toString());
            }
            if (Boolean.FALSE.equals(result)) {
                throw new Exception("receiveUpdateFromCentral - " + data.TableName + " - " + result);
            }
        }
        RowSet rowset = ReplicationLocal.getRowSet(data.Sql, null);
        pi.setSerializableObject((Serializable)((Object)rowset));
        this.log.info("mergeDataWithCentral End (" + pi + ") " + data);
        return "Remote MergeDataWithCentral - " + data.TableName;
    }

    private String receiveUpdateFromCentral() throws Exception {
        ProcessInfo pi = this.getProcessInfo();
        RemoteUpdateVO data = (RemoteUpdateVO)pi.getSerializableObject();
        this.log.info("receiveUpdateFromCentral Start (" + pi + ") - " + data);
        RowSet sourceRS = data.CentralData;
        if (sourceRS == null) {
            this.log.log(Level.SEVERE, "receiveUpdateFromCentral - No Data - " + data);
            pi.setSummary("NoData", true);
        } else if (!data.Test.booleanValue()) {
            RowSet targetRS = ReplicationLocal.getRowSet(data.Sql, null);
            Object result = this.doIt(ReplicationLocal.START, "sync", new Object[]{data.TableName, data.KeyColumns, sourceRS, targetRS, data.Test, Boolean.FALSE});
            this.log.fine("receiveUpdateFromCentral - " + data.TableName + " - " + result);
            pi.setSerializableObject(null);
            boolean replicated = ReplicationLocal.isReplicated(result);
            if (!replicated) {
                pi.setError(true);
            }
            if (result != null) {
                pi.addLog(0, null, null, result.toString());
            }
            if (Boolean.FALSE.equals(result)) {
                throw new Exception("receiveUpdateFromCentral - " + data.TableName + " - " + result);
            }
        }
        pi.setSerializableObject(null);
        this.log.info("receiveUpdateFromCentral End (" + pi + ") - " + data);
        return "Remote Receive Update from Central OK";
    }

    private String exit() throws Exception {
        this.log.info("exit");
        ProcessInfo pi = this.getProcessInfo();
        Object result = this.doIt(ReplicationLocal.START, "exit", null);
        return "exit";
    }
}

