/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.sql.RowSet;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.interfaces.ServerHome;
import org.compiere.model.MReplication;
import org.compiere.model.MReplicationLog;
import org.compiere.model.MReplicationRun;
import org.compiere.model.MSystem;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.RemoteMergeDataVO;
import org.compiere.process.RemoteSetupVO;
import org.compiere.process.RemoteUpdateVO;
import org.compiere.process.SvrProcess;
import org.compiere.util.CCachedRowSet;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ReplicationLocal
extends SvrProcess {
    private MSystem m_system = null;
    private MReplication m_replication = null;
    private MReplicationRun m_replicationRun = null;
    private Boolean m_test = Boolean.FALSE;
    private boolean m_replicated = true;
    private Server m_serverRemote = null;
    private long m_start = System.currentTimeMillis();
    private Timestamp m_replicationStart = new Timestamp(this.m_start);
    private static CLogger s_log = CLogger.getCLogger(ReplicationLocal.class);
    private static String REMOTE = "org.compiere.process.ReplicationRemote";
    protected static String START = "com.adempiere.client.StartReplication";

    public void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("IsTest")) {
                this.m_test = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.m_system = MSystem.get(this.getCtx());
    }

    public String doIt() throws Exception {
        if (this.m_system == null || !this.m_system.isValid()) {
            return "SystemNotSetupForReplication";
        }
        this.log.info("doIt - Record_ID=" + this.getRecord_ID() + ", test=" + this.m_test);
        this.connectRemote();
        this.setupRemote();
        this.mergeData();
        this.sendUpdates();
        this.log.info("doIt - Replicated=" + this.m_replicated + " - " + this.m_replicationStart);
        this.m_replicationRun.setIsReplicated(this.m_replicated);
        double sec = System.currentTimeMillis() - this.m_start;
        this.m_replicationRun.setDescription((sec /= 1000.0) + " s");
        this.m_replicationRun.save();
        if (this.m_replicated) {
            this.m_replication.setDateLastRun(this.m_replicationStart);
            this.m_replication.save();
        }
        this.exit();
        return this.m_replicated ? "Replicated" : "Replication Error";
    }

    private void connectRemote() throws Exception {
        this.m_replication = new MReplication(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        String AppsHost = this.m_replication.getHostAddress();
        int AppsPort = this.m_replication.getHostPort();
        boolean RMIoverHTTP = this.m_replication.isRMIoverHTTP();
        this.log.info(AppsHost + ":" + AppsPort + " - HTTP Tunnel=" + RMIoverHTTP);
        InitialContext ic = CConnection.getInitialContext(CConnection.getInitialEnvironment(AppsHost, AppsPort, RMIoverHTTP));
        if (ic == null) {
            throw new Exception("NoInitialContext");
        }
        try {
            ServerHome serverHome = (ServerHome)ic.lookup("adempiere/Server");
            if (serverHome == null) {
                throw new Exception("NoServer");
            }
            this.m_serverRemote = serverHome.create();
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "connectRemote", ex);
            throw new Exception(ex);
        }
    }

    private void setupRemote() throws Exception {
        this.log.info("setupRemote");
        String sql = "SELECT rt.AD_Table_ID, rt.ReplicationType, t.TableName FROM AD_ReplicationTable rt INNER JOIN AD_Table t ON (rt.AD_Table_ID=t.AD_Table_ID) WHERE rt.IsActive='Y' AND t.IsActive='Y' AND AD_ReplicationStrategy_ID=? ORDER BY t.LoadSeq";
        RowSet rowset = ReplicationLocal.getRowSet(sql, new Object[]{new Integer(this.m_replication.getAD_ReplicationStrategy_ID())});
        if (rowset == null) {
            throw new Exception("setupRemote - No RowSet Data");
        }
        RemoteSetupVO data = new RemoteSetupVO();
        data.Test = this.m_test;
        data.ReplicationTable = rowset;
        data.IDRangeStart = this.m_replication.getIDRangeStart();
        data.IDRangeEnd = this.m_replication.getIDRangeEnd();
        data.AD_Client_ID = this.m_replication.getRemote_Client_ID();
        data.AD_Org_ID = this.m_replication.getRemote_Org_ID();
        data.Prefix = this.m_replication.getPrefix();
        data.Suffix = this.m_replication.getSuffix();
        ProcessInfo pi = new ProcessInfo(data.toString(), 0);
        pi.setClassName(REMOTE);
        pi.setSerializableObject(data);
        Object result = this.doIt(START, "init", new Object[]{this.m_system});
        if (result == null || !Boolean.TRUE.equals(result)) {
            throw new Exception("setupRemote - Init Error - " + result);
        }
        pi = this.m_serverRemote.process(new Properties(), pi);
        ProcessInfoLog[] logs = pi.getLogs();
        Timestamp dateRun = null;
        if (logs != null && logs.length > 0) {
            dateRun = logs[0].getP_Date();
        }
        this.log.info("setupRemote - " + pi + " - Remote Timestamp = " + dateRun);
        if (dateRun != null) {
            this.m_replicationStart = dateRun;
        }
        this.m_replicationRun = new MReplicationRun(this.getCtx(), this.m_replication.getAD_Replication_ID(), this.m_replicationStart, this.get_TrxName());
        this.m_replicationRun.save();
    }

    private void mergeData() throws Exception {
        this.log.info("mergeData");
        String sql = "SELECT rt.AD_Table_ID, rt.ReplicationType, t.TableName, rt.AD_ReplicationTable_ID FROM AD_ReplicationTable rt INNER JOIN AD_Table t ON (rt.AD_Table_ID=t.AD_Table_ID) WHERE rt.IsActive='Y' AND t.IsActive='Y' AND AD_ReplicationStrategy_ID=? AND rt.ReplicationType='M' ORDER BY t.LoadSeq";
        RowSet rowset = ReplicationLocal.getRowSet(sql, new Object[]{new Integer(this.m_replication.getAD_ReplicationStrategy_ID())});
        try {
            while (rowset.next()) {
                this.mergeDataTable(rowset.getInt(1), rowset.getString(3), rowset.getInt(4));
            }
            rowset.close();
            rowset = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, "mergeData", ex);
            this.m_replicated = false;
        }
    }

    private boolean mergeDataTable(int AD_Table_ID, String TableName, int AD_ReplicationTable_ID) throws Exception {
        RemoteMergeDataVO data = new RemoteMergeDataVO();
        data.Test = this.m_test;
        data.TableName = TableName;
        StringBuffer sql = new StringBuffer("SELECT * FROM ").append(TableName).append(" WHERE AD_Client_ID=").append(this.m_replication.getRemote_Client_ID());
        if (this.m_replication.getRemote_Org_ID() != 0) {
            sql.append(" AND AD_Org_ID IN (0,").append(this.m_replication.getRemote_Org_ID()).append(")");
        }
        if (this.m_replication.getDateLastRun() != null) {
            sql.append(" AND Updated >= ").append(DB.TO_DATE(this.m_replication.getDateLastRun(), false));
        }
        sql.append(" ORDER BY ");
        data.KeyColumns = this.getKeyColumns(AD_Table_ID);
        if (data.KeyColumns == null || data.KeyColumns.length == 0) {
            this.log.log(Level.SEVERE, "mergeDataTable - No KeyColumns for " + TableName);
            this.m_replicated = false;
            return false;
        }
        for (int i2 = 0; i2 < data.KeyColumns.length; ++i2) {
            if (i2 > 0) {
                sql.append(",");
            }
            sql.append(data.KeyColumns[i2]);
        }
        data.Sql = sql.toString();
        data.CentralData = ReplicationLocal.getRowSet(data.Sql, null);
        if (data.CentralData == null) {
            this.log.fine("mergeDataTable - CentralData is Null - " + TableName);
            this.m_replicated = false;
            return false;
        }
        ProcessInfo pi = new ProcessInfo("MergeData", 0);
        pi.setClassName(REMOTE);
        pi.setSerializableObject(data);
        pi = this.m_serverRemote.process(new Properties(), pi);
        ProcessInfoLog[] logs = pi.getLogs();
        String msg = "< ";
        if (logs != null && logs.length > 0) {
            msg = msg + logs[0].getP_Msg();
        }
        this.log.info("mergeDataTable - " + pi);
        MReplicationLog rLog = new MReplicationLog(this.getCtx(), this.m_replicationRun.getAD_Replication_Run_ID(), AD_ReplicationTable_ID, msg, this.get_TrxName());
        if (pi.isError()) {
            this.log.severe("mergeDataTable Error - " + pi);
            this.m_replicated = false;
            rLog.setIsReplicated(false);
        } else {
            RowSet targetRS;
            RowSet sourceRS = (RowSet)((Object)pi.getSerializableObject());
            Object result = this.doIt(START, "sync", new Object[]{data.TableName, data.KeyColumns, sourceRS, targetRS = ReplicationLocal.getRowSet(data.Sql, null), this.m_test, Boolean.TRUE});
            boolean replicated = ReplicationLocal.isReplicated(result);
            if (replicated) {
                this.log.fine("mergeDataTable -> " + TableName + " - " + result);
            } else {
                this.m_replicated = false;
                this.log.severe("mergeDataTable -> " + TableName + " - " + result);
            }
            rLog.setIsReplicated(replicated);
            if (result != null) {
                rLog.setP_Msg("< " + result.toString());
            }
            sourceRS.close();
            sourceRS = null;
            targetRS.close();
            targetRS = null;
        }
        rLog.save();
        return !pi.isError();
    }

    public String[] getKeyColumns(int AD_Table_ID) {
        ArrayList<String> list = new ArrayList<String>();
        CPreparedStatement pstmt = null;
        try {
            String sql = "SELECT ColumnName FROM AD_Column WHERE AD_Table_ID=? AND IsKey='Y'";
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            rs.close();
            if (list.size() == 0) {
                sql = "SELECT ColumnName FROM AD_Column WHERE AD_Table_ID=? AND IsParent='Y'";
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, AD_Table_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                rs.close();
            }
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getKeyColumns", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    private void sendUpdates() throws Exception {
        this.log.info("sendUpdates");
        String sql = "SELECT rt.AD_Table_ID, rt.ReplicationType, t.TableName, rt.AD_ReplicationTable_ID FROM AD_ReplicationTable rt INNER JOIN AD_Table t ON (rt.AD_Table_ID=t.AD_Table_ID) WHERE rt.IsActive='Y' AND t.IsActive='Y' AND AD_ReplicationStrategy_ID=? AND rt.ReplicationType='R' ORDER BY t.LoadSeq";
        RowSet rowset = ReplicationLocal.getRowSet(sql, new Object[]{new Integer(this.m_replication.getAD_ReplicationStrategy_ID())});
        try {
            while (rowset.next()) {
                this.sendUpdatesTable(rowset.getInt(1), rowset.getString(3), rowset.getInt(4));
            }
            rowset.close();
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, "sendUpdates", ex);
            this.m_replicated = false;
        }
    }

    private boolean sendUpdatesTable(int AD_Table_ID, String TableName, int AD_ReplicationTable_ID) throws Exception {
        RemoteUpdateVO data = new RemoteUpdateVO();
        data.Test = this.m_test;
        data.TableName = TableName;
        StringBuffer sql = new StringBuffer("SELECT * FROM ").append(TableName).append(" WHERE AD_Client_ID=").append(this.m_replication.getRemote_Client_ID());
        if (this.m_replication.getRemote_Org_ID() != 0) {
            sql.append(" AND AD_Org_ID IN (0,").append(this.m_replication.getRemote_Org_ID()).append(")");
        }
        if (this.m_replication.getDateLastRun() != null) {
            sql.append(" AND Updated >= ").append(DB.TO_DATE(this.m_replication.getDateLastRun(), false));
        }
        sql.append(" ORDER BY ");
        data.KeyColumns = this.getKeyColumns(AD_Table_ID);
        if (data.KeyColumns == null || data.KeyColumns.length == 0) {
            this.log.log(Level.SEVERE, "sendUpdatesTable - No KeyColumns for " + TableName);
            this.m_replicated = false;
            return false;
        }
        for (int i2 = 0; i2 < data.KeyColumns.length; ++i2) {
            if (i2 > 0) {
                sql.append(",");
            }
            sql.append(data.KeyColumns[i2]);
        }
        data.Sql = sql.toString();
        data.CentralData = ReplicationLocal.getRowSet(data.Sql, null);
        if (data.CentralData == null) {
            this.log.fine("sendUpdatesTable - Null - " + TableName);
            this.m_replicated = false;
            return false;
        }
        int rows = 0;
        try {
            if (data.CentralData.last()) {
                rows = data.CentralData.getRow();
            }
            data.CentralData.beforeFirst();
        }
        catch (SQLException ex) {
            this.log.fine("RowCheck  " + ex);
            this.m_replicated = false;
            return false;
        }
        if (rows == 0) {
            this.log.fine("No Rows - " + TableName);
            return true;
        }
        this.log.fine(TableName + " #" + rows);
        ProcessInfo pi = new ProcessInfo("SendUpdates", 0);
        pi.setClassName(REMOTE);
        pi.setSerializableObject(data);
        pi = this.m_serverRemote.process(new Properties(), pi);
        this.log.info("sendUpdatesTable - " + pi);
        ProcessInfoLog[] logs = pi.getLogs();
        String msg = "> ";
        if (logs != null && logs.length > 0) {
            msg = msg + logs[0].getP_Msg();
        }
        MReplicationLog rLog = new MReplicationLog(this.getCtx(), this.m_replicationRun.getAD_Replication_Run_ID(), AD_ReplicationTable_ID, msg, this.get_TrxName());
        if (pi.isError()) {
            this.m_replicated = false;
        }
        rLog.setIsReplicated(!pi.isError());
        rLog.save();
        return !pi.isError();
    }

    private void exit() {
        this.log.info("exit");
        Object result = this.doIt(START, "exit", null);
        ProcessInfo pi = new ProcessInfo("Exit", 0);
        pi.setClassName(REMOTE);
        pi.setSerializableObject(this.m_replicationStart);
        try {
            this.m_serverRemote.process(new Properties(), pi);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static RowSet getRowSet(String sql, Object[] args) {
        Connection conn = DB.getConnectionRO();
        PreparedStatement pstmt = null;
        RowSet rowSet = null;
        try {
            pstmt = conn.prepareStatement(sql, 1004, 1007);
            if (args != null) {
                for (int i2 = 0; i2 < args.length; ++i2) {
                    if (args[i2] == null) {
                        s_log.log(Level.SEVERE, "NULL Argument " + i2);
                        continue;
                    }
                    if (args[i2] instanceof Integer) {
                        pstmt.setInt(i2 + 1, (Integer)args[i2]);
                        continue;
                    }
                    if (args[i2] instanceof Timestamp) {
                        pstmt.setTimestamp(i2 + 1, (Timestamp)args[i2]);
                        continue;
                    }
                    if (args[i2] instanceof BigDecimal) {
                        pstmt.setBigDecimal(i2 + 1, (BigDecimal)args[i2]);
                        continue;
                    }
                    pstmt.setString(i2 + 1, args[i2].toString());
                }
            }
            ResultSet rs = pstmt.executeQuery();
            rowSet = CCachedRowSet.getRowSet(rs);
            pstmt.close();
            pstmt = null;
        }
        catch (Exception ex) {
            s_log.log(Level.SEVERE, sql, ex);
            throw new RuntimeException(ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "close pstmt", e);
        }
        return rowSet;
    }

    public static boolean isReplicated(Object result) {
        boolean replicated;
        boolean bl = replicated = result != null && !Boolean.FALSE.equals(result);
        if (replicated) {
            replicated = result.toString().endsWith("Errors=0");
        }
        return replicated;
    }
}

