/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Client;
import org.compiere.model.X_C_Order;
import org.compiere.model.X_M_Requisition;
import org.compiere.model.X_M_Warehouse;
import org.compiere.model.X_T_Replenish;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ReplenishInterface;

public class ReplenishReport
extends SvrProcess {
    private int p_M_Warehouse_ID = 0;
    private int p_C_BPartner_ID = 0;
    private String p_ReplenishmentCreate = null;
    private int p_C_DocType_ID = 0;
    private String m_info = "";

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("ReplenishmentCreate")) {
                this.p_ReplenishmentCreate = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("C_DocType_ID")) {
                this.p_C_DocType_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("M_Warehouse_ID=" + this.p_M_Warehouse_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + " - ReplenishmentCreate=" + this.p_ReplenishmentCreate + ", C_DocType_ID=" + this.p_C_DocType_ID);
        if (this.p_ReplenishmentCreate != null && this.p_C_DocType_ID == 0) {
            throw new AdempiereUserError("@FillMandatory@ @C_DocType_ID@");
        }
        MWarehouse wh = MWarehouse.get(this.getCtx(), this.p_M_Warehouse_ID);
        if (wh.get_ID() == 0) {
            throw new AdempiereSystemError("@FillMandatory@ @M_Warehouse_ID@");
        }
        this.prepareTable();
        this.fillTable(wh);
        if (this.p_ReplenishmentCreate == null) {
            return "OK";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.p_C_DocType_ID);
        if (!dt.getDocBaseType().equals(this.p_ReplenishmentCreate)) {
            throw new AdempiereSystemError("@C_DocType_ID@=" + dt.getName() + " <> " + this.p_ReplenishmentCreate);
        }
        if (this.p_ReplenishmentCreate.equals("POO")) {
            this.createPO();
        } else if (this.p_ReplenishmentCreate.equals("POR")) {
            this.createRequisition();
        } else if (this.p_ReplenishmentCreate.equals("MMM")) {
            this.createMovements();
        }
        return this.m_info;
    }

    private void prepareTable() {
        String sql = "UPDATE M_Replenish SET Level_Max = Level_Min WHERE Level_Max < Level_Min";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        if (no != 0) {
            this.log.fine("Corrected Max_Level=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE M_Product_PO SET Order_Min = 1 WHERE Order_Min IS NULL OR Order_Min < 1", this.get_TrxName())) != 0) {
            this.log.fine("Corrected Order Min=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE M_Product_PO SET Order_Pack = 1 WHERE Order_Pack IS NULL OR Order_Pack < 1", this.get_TrxName())) != 0) {
            this.log.fine("Corrected Order Pack=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE M_Product_PO p SET IsCurrentVendor='Y' WHERE IsCurrentVendor<>'Y' AND EXISTS (SELECT * FROM M_Product_PO pp WHERE p.M_Product_ID=pp.M_Product_ID GROUP BY pp.M_Product_ID HAVING COUNT(*) = 1)", this.get_TrxName())) != 0) {
            this.log.fine("Corrected CurrentVendor(Y)=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE M_Product_PO p SET IsCurrentVendor='N' WHERE IsCurrentVendor = 'Y' AND EXISTS (SELECT * FROM M_Product_PO pp WHERE p.M_Product_ID=pp.M_Product_ID AND pp.IsCurrentVendor='Y' GROUP BY pp.M_Product_ID HAVING COUNT(*) > 1)", this.get_TrxName())) != 0) {
            this.log.fine("Corrected CurrentVendor(N)=" + no);
        }
        if ((no = DB.executeUpdate(sql = "DELETE T_Replenish WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Delete Existing Temp=" + no);
        }
    }

    private void fillTable(MWarehouse wh) throws Exception {
        String className;
        String sql = "INSERT INTO T_Replenish (AD_PInstance_ID, M_Warehouse_ID, M_Product_ID, AD_Client_ID, AD_Org_ID, ReplenishType, Level_Min, Level_Max, C_BPartner_ID, Order_Min, Order_Pack, QtyToOrder, ReplenishmentCreate) SELECT " + this.getAD_PInstance_ID() + ", r.M_Warehouse_ID, r.M_Product_ID, r.AD_Client_ID, r.AD_Org_ID," + " r.ReplenishType, r.Level_Min, r.Level_Max," + " po.C_BPartner_ID, po.Order_Min, po.Order_Pack, 0, ";
        sql = this.p_ReplenishmentCreate == null ? sql + "null" : sql + "'" + this.p_ReplenishmentCreate + "'";
        sql = sql + " FROM M_Replenish r INNER JOIN M_Product_PO po ON (r.M_Product_ID=po.M_Product_ID) WHERE po.IsCurrentVendor='Y' AND r.ReplenishType<>'0' AND po.IsActive='Y' AND r.IsActive='Y' AND r.M_Warehouse_ID=" + this.p_M_Warehouse_ID;
        if (this.p_C_BPartner_ID != 0) {
            sql = sql + " AND po.C_BPartner_ID=" + this.p_C_BPartner_ID;
        }
        int no = DB.executeUpdate(sql, this.get_TrxName());
        this.log.finest(sql);
        this.log.fine("Insert (1) #" + no);
        if (this.p_C_BPartner_ID == 0) {
            sql = "INSERT INTO T_Replenish (AD_PInstance_ID, M_Warehouse_ID, M_Product_ID, AD_Client_ID, AD_Org_ID, ReplenishType, Level_Min, Level_Max, C_BPartner_ID, Order_Min, Order_Pack, QtyToOrder, ReplenishmentCreate) SELECT " + this.getAD_PInstance_ID() + ", r.M_Warehouse_ID, r.M_Product_ID, r.AD_Client_ID, r.AD_Org_ID," + " r.ReplenishType, r.Level_Min, r.Level_Max," + " null, 1, 1, 0, ";
            sql = this.p_ReplenishmentCreate == null ? sql + "null" : sql + "'" + this.p_ReplenishmentCreate + "'";
            sql = sql + " FROM M_Replenish r WHERE r.ReplenishType<>'0' AND r.IsActive='Y' AND r.M_Warehouse_ID=" + this.p_M_Warehouse_ID + " AND NOT EXISTS (SELECT * FROM T_Replenish t " + "WHERE r.M_Product_ID=t.M_Product_ID" + " AND AD_PInstance_ID=" + this.getAD_PInstance_ID() + ")";
            no = DB.executeUpdate(sql, this.get_TrxName());
            this.log.fine("Insert (BP) #" + no);
        }
        sql = "UPDATE T_Replenish t SET QtyOnHand = (SELECT SUM(QtyOnHand) FROM M_Storage s, M_Locator l WHERE t.M_Product_ID=s.M_Product_ID AND l.M_Locator_ID=s.M_Locator_ID AND l.M_Warehouse_ID=t.M_Warehouse_ID),QtyReserved = (SELECT SUM(QtyReserved) FROM M_Storage s, M_Locator l WHERE t.M_Product_ID=s.M_Product_ID AND l.M_Locator_ID=s.M_Locator_ID AND l.M_Warehouse_ID=t.M_Warehouse_ID),QtyOrdered = (SELECT SUM(QtyOrdered) FROM M_Storage s, M_Locator l WHERE t.M_Product_ID=s.M_Product_ID AND l.M_Locator_ID=s.M_Locator_ID AND l.M_Warehouse_ID=t.M_Warehouse_ID)";
        if (this.p_C_DocType_ID != 0) {
            sql = sql + ", C_DocType_ID=" + this.p_C_DocType_ID;
        }
        if ((no = DB.executeUpdate(sql = sql + " WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Update #" + no);
        }
        if ((no = DB.executeUpdate(sql = "DELETE T_Replenish r WHERE (EXISTS (SELECT * FROM M_Product p WHERE p.M_Product_ID=r.M_Product_ID AND p.IsActive='N') OR EXISTS (SELECT * FROM M_Replenish rr  WHERE rr.M_Product_ID=r.M_Product_ID AND rr.IsActive='N')) AND AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Delete Inactive=" + no);
        }
        sql = "UPDATE T_Replenish SET QtyOnHand = 0 WHERE QtyOnHand IS NULL";
        no = DB.executeUpdate(sql, this.get_TrxName());
        sql = "UPDATE T_Replenish SET QtyReserved = 0 WHERE QtyReserved IS NULL";
        no = DB.executeUpdate(sql, this.get_TrxName());
        sql = "UPDATE T_Replenish SET QtyOrdered = 0 WHERE QtyOrdered IS NULL";
        no = DB.executeUpdate(sql, this.get_TrxName());
        sql = "UPDATE T_Replenish SET QtyToOrder = Level_Min - QtyOnHand + QtyReserved - QtyOrdered WHERE ReplenishType='1' AND AD_PInstance_ID=" + this.getAD_PInstance_ID();
        no = DB.executeUpdate(sql, this.get_TrxName());
        if (no != 0) {
            this.log.fine("Update Type-1=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE T_Replenish SET QtyToOrder = Level_Max - QtyOnHand + QtyReserved - QtyOrdered WHERE ReplenishType='2' AND AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Update Type-2=" + no);
        }
        if ((no = DB.executeUpdate(sql = "DELETE T_Replenish WHERE QtyToOrder < 1 AND AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Delete No QtyToOrder=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE T_Replenish SET QtyToOrder = Order_Min WHERE QtyToOrder < Order_Min AND AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Set MinOrderQty=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE T_Replenish SET QtyToOrder = QtyToOrder - MOD(QtyToOrder, Order_Pack) + Order_Pack WHERE MOD(QtyToOrder, Order_Pack) <> 0 AND AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Set OrderPackQty=" + no);
        }
        if (wh.getM_WarehouseSource_ID() != 0 && (no = DB.executeUpdate(sql = "UPDATE T_Replenish SET M_WarehouseSource_ID=" + wh.getM_WarehouseSource_ID() + " WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Set Source Warehouse=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE T_Replenish SET M_WarehouseSource_ID = NULL WHERE M_Warehouse_ID=M_WarehouseSource_ID AND AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Set same Source Warehouse=" + no);
        }
        if ((className = wh.getReplenishmentClass()) == null || className.length() == 0) {
            return;
        }
        ReplenishInterface custom = null;
        try {
            Class<?> clazz = Class.forName(className);
            custom = (ReplenishInterface)clazz.newInstance();
        }
        catch (Exception e) {
            throw new AdempiereUserError("No custom Replenishment class " + className + " - " + e.toString());
        }
        X_T_Replenish[] replenishs = this.getReplenish("ReplenishType='9'");
        for (int i2 = 0; i2 < replenishs.length; ++i2) {
            X_T_Replenish replenish = replenishs[i2];
            if (!replenish.getReplenishType().equals("9")) continue;
            BigDecimal qto = null;
            try {
                qto = custom.getQtyToOrder(wh, replenish);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, custom.toString(), e);
            }
            if (qto == null) {
                qto = Env.ZERO;
            }
            replenish.setQtyToOrder(qto);
            replenish.save();
        }
    }

    private void createPO() {
        int noOrders = 0;
        String info = "";
        X_C_Order order = null;
        X_M_Warehouse wh = null;
        X_T_Replenish[] replenishs = this.getReplenish("M_WarehouseSource_ID IS NULL");
        for (int i2 = 0; i2 < replenishs.length; ++i2) {
            X_T_Replenish replenish = replenishs[i2];
            if (wh == null || wh.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                wh = MWarehouse.get(this.getCtx(), replenish.getM_Warehouse_ID());
            }
            if (order == null || order.getC_BPartner_ID() != replenish.getC_BPartner_ID() || order.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                order.setIsSOTrx(false);
                order.setC_DocTypeTarget_ID(this.p_C_DocType_ID);
                MBPartner bp = new MBPartner(this.getCtx(), replenish.getC_BPartner_ID(), this.get_TrxName());
                ((MOrder)order).setBPartner(bp);
                order.setSalesRep_ID(this.getAD_User_ID());
                order.setDescription(Msg.getMsg(this.getCtx(), "Replenishment"));
                order.setAD_Org_ID(wh.getAD_Org_ID());
                ((MOrder)order).setM_Warehouse_ID(wh.getM_Warehouse_ID());
                if (!order.save()) {
                    return;
                }
                this.log.fine(((MOrder)order).toString());
                ++noOrders;
                info = info + " - " + order.getDocumentNo();
            }
            MOrderLine line = new MOrderLine((MOrder)order);
            line.setM_Product_ID(replenish.getM_Product_ID());
            line.setQty(replenish.getQtyToOrder());
            line.setPrice();
            line.save();
        }
        this.m_info = "#" + noOrders + info;
        this.log.info(this.m_info);
    }

    private void createRequisition() {
        int noReqs = 0;
        String info = "";
        X_M_Requisition requisition = null;
        X_M_Warehouse wh = null;
        X_T_Replenish[] replenishs = this.getReplenish("M_WarehouseSource_ID IS NULL");
        for (int i2 = 0; i2 < replenishs.length; ++i2) {
            X_T_Replenish replenish = replenishs[i2];
            if (wh == null || wh.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                wh = MWarehouse.get(this.getCtx(), replenish.getM_Warehouse_ID());
            }
            if (requisition == null || requisition.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                requisition = new MRequisition(this.getCtx(), 0, this.get_TrxName());
                requisition.setAD_User_ID(this.getAD_User_ID());
                requisition.setC_DocType_ID(this.p_C_DocType_ID);
                requisition.setDescription(Msg.getMsg(this.getCtx(), "Replenishment"));
                requisition.setAD_Org_ID(wh.getAD_Org_ID());
                requisition.setM_Warehouse_ID(wh.getM_Warehouse_ID());
                if (!requisition.save()) {
                    return;
                }
                this.log.fine(((MRequisition)requisition).toString());
                ++noReqs;
                info = info + " - " + requisition.getDocumentNo();
            }
            MRequisitionLine line = new MRequisitionLine((MRequisition)requisition);
            line.setM_Product_ID(replenish.getM_Product_ID());
            line.setC_BPartner_ID(replenish.getC_BPartner_ID());
            line.setQty(replenish.getQtyToOrder());
            line.setPrice();
            line.save();
        }
        this.m_info = "#" + noReqs + info;
        this.log.info(this.m_info);
    }

    private void createMovements() {
        int noMoves = 0;
        String info = "";
        PO client = null;
        MMovement move = null;
        int M_Warehouse_ID = 0;
        int M_WarehouseSource_ID = 0;
        X_M_Warehouse whSource = null;
        X_M_Warehouse wh = null;
        X_T_Replenish[] replenishs = this.getReplenish("M_WarehouseSource_ID IS NOT NULL");
        block0: for (int i2 = 0; i2 < replenishs.length; ++i2) {
            X_T_Replenish replenish = replenishs[i2];
            if (whSource == null || whSource.getM_WarehouseSource_ID() != replenish.getM_WarehouseSource_ID()) {
                whSource = MWarehouse.get(this.getCtx(), replenish.getM_WarehouseSource_ID());
            }
            if (wh == null || wh.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                wh = MWarehouse.get(this.getCtx(), replenish.getM_Warehouse_ID());
            }
            if (client == null || client.getAD_Client_ID() != whSource.getAD_Client_ID()) {
                client = MClient.get(this.getCtx(), whSource.getAD_Client_ID());
            }
            if (move == null || M_WarehouseSource_ID != replenish.getM_WarehouseSource_ID() || M_Warehouse_ID != replenish.getM_Warehouse_ID()) {
                M_WarehouseSource_ID = replenish.getM_WarehouseSource_ID();
                M_Warehouse_ID = replenish.getM_Warehouse_ID();
                move = new MMovement(this.getCtx(), 0, this.get_TrxName());
                move.setC_DocType_ID(this.p_C_DocType_ID);
                move.setDescription(Msg.getMsg(this.getCtx(), "Replenishment") + ": " + whSource.getName() + "->" + wh.getName());
                move.setAD_Org_ID(whSource.getAD_Org_ID());
                if (!move.save()) {
                    return;
                }
                this.log.fine(move.toString());
                ++noMoves;
                info = info + " - " + move.getDocumentNo();
            }
            int M_LocatorTo_ID = ((MWarehouse)wh).getDefaultLocator().getM_Locator_ID();
            MProduct product = MProduct.get(this.getCtx(), replenish.getM_Product_ID());
            MProductCategory pc = MProductCategory.get(this.getCtx(), product.getM_Product_Category_ID());
            String MMPolicy = pc.getMMPolicy();
            if (MMPolicy == null || MMPolicy.length() == 0) {
                MMPolicy = ((X_AD_Client)client).getMMPolicy();
            }
            MStorage[] storages = MStorage.getWarehouse(this.getCtx(), whSource.getM_Warehouse_ID(), replenish.getM_Product_ID(), 0, 0, true, null, "F".equals(MMPolicy), this.get_TrxName());
            BigDecimal target = replenish.getQtyToOrder();
            for (int j = 0; j < storages.length; ++j) {
                MStorage storage = storages[j];
                if (storage.getQtyOnHand().signum() <= 0) continue;
                BigDecimal moveQty = target;
                if (storage.getQtyOnHand().compareTo(moveQty) < 0) {
                    moveQty = storage.getQtyOnHand();
                }
                MMovementLine line = new MMovementLine(move);
                line.setM_Product_ID(replenish.getM_Product_ID());
                line.setMovementQty(moveQty);
                if (replenish.getQtyToOrder().compareTo(moveQty) != 0) {
                    line.setDescription("Total: " + replenish.getQtyToOrder());
                }
                line.setM_Locator_ID(storage.getM_Locator_ID());
                line.setM_AttributeSetInstance_ID(storage.getM_AttributeSetInstance_ID());
                line.setM_LocatorTo_ID(M_LocatorTo_ID);
                line.setM_AttributeSetInstanceTo_ID(storage.getM_AttributeSetInstance_ID());
                line.save();
                target = target.subtract(moveQty);
                if (target.signum() == 0) continue block0;
            }
        }
        if (replenishs.length == 0) {
            this.m_info = "No Source Warehouse";
            this.log.warning(this.m_info);
        } else {
            this.m_info = "#" + noMoves + info;
            this.log.info(this.m_info);
        }
    }

    private X_T_Replenish[] getReplenish(String where) {
        String sql = "SELECT * FROM T_Replenish WHERE AD_PInstance_ID=? AND C_BPartner_ID > 0 ";
        if (where != null && where.length() > 0) {
            sql = sql + " AND " + where;
        }
        sql = sql + " ORDER BY M_Warehouse_ID, M_WarehouseSource_ID, C_BPartner_ID";
        ArrayList<X_T_Replenish> list = new ArrayList<X_T_Replenish>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_PInstance_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new X_T_Replenish(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        X_T_Replenish[] retValue = new X_T_Replenish[list.size()];
        list.toArray(retValue);
        return retValue;
    }
}

