/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MProductPricing;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;

public class ProjectLinePricing
extends SvrProcess {
    private int m_C_ProjectLine_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.m_C_ProjectLine_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.m_C_ProjectLine_ID == 0) {
            throw new IllegalArgumentException("No Project Line");
        }
        MProjectLine projectLine = new MProjectLine(this.getCtx(), this.m_C_ProjectLine_ID, this.get_TrxName());
        this.log.info("doIt - " + projectLine);
        if (projectLine.getM_Product_ID() == 0) {
            throw new IllegalArgumentException("No Product");
        }
        MProject project = new MProject(this.getCtx(), projectLine.getC_Project_ID(), this.get_TrxName());
        if (project.getM_PriceList_ID() == 0) {
            throw new IllegalArgumentException("No PriceList");
        }
        boolean isSOTrx = true;
        MProductPricing pp = new MProductPricing(projectLine.getM_Product_ID(), project.getC_BPartner_ID(), projectLine.getPlannedQty(), isSOTrx);
        pp.setM_PriceList_ID(project.getM_PriceList_ID());
        pp.setPriceDate(project.getDateContract());
        projectLine.setPlannedPrice(pp.getPriceStd());
        projectLine.setPlannedMarginAmt(pp.getPriceStd().subtract(pp.getPriceLimit()));
        projectLine.save();
        String retValue = Msg.getElement(this.getCtx(), "PriceList") + pp.getPriceList() + " - " + Msg.getElement(this.getCtx(), "PriceStd") + pp.getPriceStd() + " - " + Msg.getElement(this.getCtx(), "PriceLimit") + pp.getPriceLimit();
        return retValue;
    }
}

