/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.DB;

public class ProductCategoryAcctCopy
extends SvrProcess {
    private int p_M_Product_Category_ID = 0;
    private int p_C_AcctSchema_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("M_Product_Category_ID")) {
                this.p_M_Product_Category_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("C_AcctSchema_ID=" + this.p_C_AcctSchema_ID);
        if (this.p_C_AcctSchema_ID == 0) {
            throw new AdempiereSystemError("C_AcctSchema_ID=0");
        }
        MAcctSchema as = MAcctSchema.get(this.getCtx(), this.p_C_AcctSchema_ID);
        if (as.get_ID() == 0) {
            throw new AdempiereSystemError("Not Found - C_AcctSchema_ID=" + this.p_C_AcctSchema_ID);
        }
        String sql = "UPDATE M_Product_Acct pa SET (P_Revenue_Acct,P_Expense_Acct,P_CostAdjustment_Acct,P_InventoryClearing_Acct,P_Asset_Acct,P_COGS_Acct, P_PurchasePriceVariance_Acct,P_InvoicePriceVariance_Acct, P_TradeDiscountRec_Acct,P_TradeDiscountGrant_Acct)= (SELECT P_Revenue_Acct,P_Expense_Acct,P_CostAdjustment_Acct,P_InventoryClearing_Acct,P_Asset_Acct,P_COGS_Acct, P_PurchasePriceVariance_Acct,P_InvoicePriceVariance_Acct, P_TradeDiscountRec_Acct,P_TradeDiscountGrant_Acct FROM M_Product_Category_Acct pca WHERE pca.M_Product_Category_ID=" + this.p_M_Product_Category_ID + " AND pca.C_AcctSchema_ID=" + this.p_C_AcctSchema_ID + "), Updated=SysDate, UpdatedBy=0 " + "WHERE pa.C_AcctSchema_ID=" + this.p_C_AcctSchema_ID + " AND EXISTS (SELECT * FROM M_Product p " + "WHERE p.M_Product_ID=pa.M_Product_ID" + " AND p.M_Product_Category_ID=" + this.p_M_Product_Category_ID + ")";
        int updated = DB.executeUpdate(sql, this.get_TrxName());
        this.addLog(0, null, new BigDecimal(updated), "@Updated@");
        sql = "INSERT INTO M_Product_Acct (M_Product_ID, C_AcctSchema_ID, AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, P_Revenue_Acct, P_Expense_Acct, P_CostAdjustment_Acct, P_InventoryClearing_Acct, P_Asset_Acct, P_CoGs_Acct, P_PurchasePriceVariance_Acct, P_InvoicePriceVariance_Acct, P_TradeDiscountRec_Acct, P_TradeDiscountGrant_Acct) SELECT p.M_Product_ID, acct.C_AcctSchema_ID, p.AD_Client_ID, p.AD_Org_ID, 'Y', SysDate, 0, SysDate, 0, acct.P_Revenue_Acct, acct.P_Expense_Acct, acct.P_CostAdjustment_Acct, acct.P_InventoryClearing_Acct, acct.P_Asset_Acct, acct.P_CoGs_Acct, acct.P_PurchasePriceVariance_Acct, acct.P_InvoicePriceVariance_Acct, acct.P_TradeDiscountRec_Acct, acct.P_TradeDiscountGrant_Acct FROM M_Product p INNER JOIN M_Product_Category_Acct acct ON (acct.M_Product_Category_ID=p.M_Product_Category_ID)WHERE acct.C_AcctSchema_ID=" + this.p_C_AcctSchema_ID + " AND p.M_Product_Category_ID=" + this.p_M_Product_Category_ID + " AND NOT EXISTS (SELECT * FROM M_Product_Acct pa " + "WHERE pa.M_Product_ID=p.M_Product_ID" + " AND pa.C_AcctSchema_ID=acct.C_AcctSchema_ID)";
        int created = DB.executeUpdate(sql, this.get_TrxName());
        this.addLog(0, null, new BigDecimal(created), "@Created@");
        return "@Created@=" + created + ", @Updated@=" + updated;
    }
}

