/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentValidate;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;

public class PaymentOnline
extends SvrProcess {
    private int m_C_Payment_ID = -1;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("Record_ID=" + this.getRecord_ID());
        MPayment pp = new MPayment(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        String msg = MPaymentValidate.validateCreditCardNumber(pp.getCreditCardNumber(), pp.getCreditCardType());
        if (msg != null && msg.length() > 0) {
            throw new IllegalArgumentException(Msg.getMsg(this.getCtx(), msg));
        }
        msg = MPaymentValidate.validateCreditCardExp(pp.getCreditCardExpMM(), pp.getCreditCardExpYY());
        if (msg != null && msg.length() > 0) {
            throw new IllegalArgumentException(Msg.getMsg(this.getCtx(), msg));
        }
        if (pp.getCreditCardVV().length() > 0 && (msg = MPaymentValidate.validateCreditCardVV(pp.getCreditCardVV(), pp.getCreditCardType())) != null && msg.length() > 0) {
            throw new IllegalArgumentException(Msg.getMsg(this.getCtx(), msg));
        }
        boolean ok = pp.processOnline();
        pp.save();
        if (!ok) {
            throw new Exception(pp.getErrorMessage());
        }
        return "OK";
    }
}

