/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class OrderBatchProcess
extends SvrProcess {
    private int p_C_DocTypeTarget_ID = 0;
    private String p_DocStatus = null;
    private int p_C_BPartner_ID = 0;
    private String p_IsSelfService = null;
    private Timestamp p_DateOrdered_From = null;
    private Timestamp p_DateOrdered_To = null;
    private String p_DocAction = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_DocTypeTarget_ID")) {
                this.p_C_DocTypeTarget_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("DocStatus")) {
                this.p_DocStatus = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("IsSelfService")) {
                this.p_IsSelfService = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("DateOrdered")) {
                this.p_DateOrdered_From = (Timestamp)para[i2].getParameter();
                this.p_DateOrdered_To = (Timestamp)para[i2].getParameter_To();
                continue;
            }
            if (name.equals("DocAction")) {
                this.p_DocAction = (String)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("C_DocTypeTarget_ID=" + this.p_C_DocTypeTarget_ID + ", DocStatus=" + this.p_DocStatus + ", IsSelfService=" + this.p_IsSelfService + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", DateOrdered=" + this.p_DateOrdered_From + "->" + this.p_DateOrdered_To + ", DocAction=" + this.p_DocAction);
        if (this.p_C_DocTypeTarget_ID == 0) {
            throw new AdempiereUserError("@NotFound@: @C_DocTypeTarget_ID@");
        }
        if (this.p_DocStatus == null || this.p_DocStatus.length() != 2) {
            throw new AdempiereUserError("@NotFound@: @DocStatus@");
        }
        if (this.p_DocAction == null || this.p_DocAction.length() != 2) {
            throw new AdempiereUserError("@NotFound@: @DocAction@");
        }
        StringBuffer sql = new StringBuffer("SELECT * FROM C_Order WHERE C_DocTypeTarget_ID=? AND DocStatus=?");
        if (this.p_IsSelfService != null && this.p_IsSelfService.length() == 1) {
            sql.append(" AND IsSelfService='").append(this.p_IsSelfService).append("'");
        }
        if (this.p_C_BPartner_ID != 0) {
            sql.append(" AND C_BPartner_ID=").append(this.p_C_BPartner_ID);
        }
        if (this.p_DateOrdered_From != null) {
            sql.append(" AND TRUNC(DateOrdered) >= ").append(DB.TO_DATE(this.p_DateOrdered_From, true));
        }
        if (this.p_DateOrdered_To != null) {
            sql.append(" AND TRUNC(DateOrdered) <= ").append(DB.TO_DATE(this.p_DateOrdered_To, true));
        }
        int counter = 0;
        int errCounter = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            pstmt.setInt(1, this.p_C_DocTypeTarget_ID);
            pstmt.setString(2, this.p_DocStatus);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (this.process(new MOrder(this.getCtx(), rs, this.get_TrxName()))) {
                    ++counter;
                    continue;
                }
                ++errCounter;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return "@Updated@=" + counter + ", @Errors@=" + errCounter;
    }

    private boolean process(MOrder order) {
        this.log.info(order.toString());
        order.setDocAction(this.p_DocAction);
        if (order.processIt(this.p_DocAction)) {
            order.save();
            this.addLog(0, null, null, order.getDocumentNo() + ": OK");
            return true;
        }
        this.addLog(0, null, null, order.getDocumentNo() + ": Error " + order.getProcessMsg());
        return false;
    }
}

