/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.X_M_Product;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ValueNamePair;

public class M_Product_BOM_Check
extends SvrProcess {
    private int p_Record_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_Record_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        StringBuffer sql1 = null;
        int no = 0;
        this.log.info("Check BOM Structure");
        X_M_Product xp = new X_M_Product(Env.getCtx(), this.p_Record_ID, this.get_TrxName());
        if (!xp.isBOM()) {
            this.log.info("NOT BOM Product");
            xp.setIsVerified(true);
            xp.save(this.get_TrxName());
            return "OK";
        }
        sql1 = new StringBuffer("DELETE FROM T_Selection2 WHERE Query_ID = 0");
        no = DB.executeUpdate(sql1.toString(), this.get_TrxName());
        sql1 = new StringBuffer("INSERT INTO T_Selection2 (Query_ID, T_Selection_ID) VALUES (0, " + this.p_Record_ID + ")");
        no = DB.executeUpdate(sql1.toString(), this.get_TrxName());
        sql1 = new StringBuffer("DELETE FROM T_Selection");
        no = DB.executeUpdate(sql1.toString(), this.get_TrxName());
        sql1 = new StringBuffer("INSERT INTO T_Selection (T_Selection_ID) VALUES (" + this.p_Record_ID + ")");
        no = DB.executeUpdate(sql1.toString(), this.get_TrxName());
        while (true) {
            int countno = 0;
            try {
                CPreparedStatement pstmt = DB.prepareStatement("SELECT COUNT(*) FROM T_Selection", this.get_TrxName());
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    countno = rs.getInt(1);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                throw new Exception("count t_selection", e);
            }
            this.log.fine("Count T_Selection =" + countno);
            if (countno == 0) break;
            try {
                sql1 = new StringBuffer("INSERT INTO T_Selection2 (Query_ID, T_Selection_ID) SELECT 0, p.M_Product_ID FROM M_Product p WHERE IsBOM='Y' AND EXISTS (SELECT * FROM M_Product_BOM b WHERE p.M_Product_ID=b.M_ProductBOM_ID AND b.M_Product_ID IN (SELECT T_Selection_ID FROM T_Selection))");
                no = DB.executeUpdate(sql1.toString(), this.get_TrxName());
                if (no == -1) {
                    this.raiseError("InsertingRoot:ERROR", sql1.toString());
                }
                if ((no = DB.executeUpdate((sql1 = new StringBuffer("DELETE FROM T_Selection2 WHERE Query_ID = 1")).toString(), this.get_TrxName())) == -1) {
                    this.raiseError("InsertingRoot:ERROR", sql1.toString());
                }
                if ((no = DB.executeUpdate((sql1 = new StringBuffer("INSERT INTO T_Selection2 (Query_ID, T_Selection_ID) SELECT 1, p.M_Product_ID FROM M_Product p WHERE IsBOM='Y' AND EXISTS (SELECT * FROM M_Product_BOM b WHERE p.M_Product_ID=b.M_ProductBOM_ID AND b.M_Product_ID IN (SELECT T_Selection_ID FROM T_Selection))")).toString(), this.get_TrxName())) == -1) {
                    this.raiseError("InsertingRoot:ERROR", sql1.toString());
                }
                if ((no = DB.executeUpdate((sql1 = new StringBuffer("DELETE FROM T_Selection")).toString(), this.get_TrxName())) == -1) {
                    this.raiseError("InsertingRoot:ERROR", sql1.toString());
                }
                if ((no = DB.executeUpdate((sql1 = new StringBuffer("INSERT INTO T_Selection (T_Selection_ID) SELECT T_Selection_ID FROM T_Selection2 WHERE Query_ID = 1")).toString(), this.get_TrxName())) != -1) continue;
                this.raiseError("InsertingRoot:ERROR", sql1.toString());
            }
            catch (Exception e) {
                throw new Exception("root insert", e);
            }
        }
        xp.setIsVerified(true);
        xp.save(this.get_TrxName());
        return "OK";
    }

    private void raiseError(String string, String sql) throws Exception {
        DB.rollback(false, this.get_TrxName());
        String msg = string;
        ValueNamePair pp = CLogger.retrieveError();
        if (pp != null) {
            msg = pp.getName() + " - ";
        }
        msg = msg + sql;
        throw new AdempiereUserError(msg);
    }
}

