/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInventoryLineMA;
import org.compiere.model.MStorage;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class InventoryCountUpdate
extends SvrProcess {
    private int p_M_Inventory_ID = 0;
    private boolean p_InventoryCountSetZero = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("InventoryCountSet")) {
                this.p_InventoryCountSetZero = "Z".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_M_Inventory_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        this.log.info("M_Inventory_ID=" + this.p_M_Inventory_ID);
        MInventory inventory = new MInventory(this.getCtx(), this.p_M_Inventory_ID, this.get_TrxName());
        if (inventory.get_ID() == 0) {
            throw new AdempiereSystemError("Not found: M_Inventory_ID=" + this.p_M_Inventory_ID);
        }
        String sql = "UPDATE M_InventoryLine SET IsActive='N' WHERE M_Inventory_ID=" + this.p_M_Inventory_ID + " AND (M_Product_ID, M_Locator_ID, M_AttributeSetInstance_ID) IN " + "(SELECT M_Product_ID, M_Locator_ID, M_AttributeSetInstance_ID " + "FROM M_InventoryLine " + "WHERE M_Inventory_ID=" + this.p_M_Inventory_ID + " GROUP BY M_Product_ID, M_Locator_ID, M_AttributeSetInstance_ID " + "HAVING COUNT(*) > 1)";
        int multiple = DB.executeUpdate(sql, this.get_TrxName());
        this.log.info("Multiple=" + multiple);
        int delMA = MInventoryLineMA.deleteInventoryMA(this.p_M_Inventory_ID, this.get_TrxName());
        this.log.info("DeletedMA=" + delMA);
        sql = "UPDATE M_InventoryLine l SET (QtyBook,QtyCount) = (SELECT QtyOnHand,QtyOnHand FROM M_Storage s WHERE s.M_Product_ID=l.M_Product_ID AND s.M_Locator_ID=l.M_Locator_ID AND s.M_AttributeSetInstance_ID=l.M_AttributeSetInstance_ID), Updated=SysDate, UpdatedBy=" + this.getAD_User_ID() + " WHERE M_Inventory_ID=" + this.p_M_Inventory_ID + " AND EXISTS (SELECT * FROM M_Storage s " + "WHERE s.M_Product_ID=l.M_Product_ID AND s.M_Locator_ID=l.M_Locator_ID" + " AND s.M_AttributeSetInstance_ID=l.M_AttributeSetInstance_ID)";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        this.log.info("Update with ASI=" + no);
        int noMA = this.updateWithMA();
        if (this.p_InventoryCountSetZero) {
            sql = "UPDATE M_InventoryLine l SET QtyCount=0 WHERE M_Inventory_ID=" + this.p_M_Inventory_ID;
            no = DB.executeUpdate(sql, this.get_TrxName());
            this.log.info("Set Cont to Zero=" + no);
        }
        if (multiple > 0) {
            return "@M_InventoryLine_ID@ - #" + (no + noMA) + " --> @InventoryProductMultiple@";
        }
        return "@M_InventoryLine_ID@ - #" + no;
    }

    private int updateWithMA() {
        int no = 0;
        String sql = "SELECT * FROM M_InventoryLine WHERE M_Inventory_ID=? AND M_AttributeSetInstance_ID=0";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.p_M_Inventory_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MInventoryLine il = new MInventoryLine(this.getCtx(), rs, this.get_TrxName());
                BigDecimal onHand = Env.ZERO;
                MStorage[] storages = MStorage.getAll(this.getCtx(), il.getM_Product_ID(), il.getM_Locator_ID(), this.get_TrxName());
                MInventoryLineMA ma = null;
                for (int i2 = 0; i2 < storages.length; ++i2) {
                    MStorage storage = storages[i2];
                    if (storage.getQtyOnHand().signum() == 0) continue;
                    onHand = onHand.add(storage.getQtyOnHand());
                    if ((storage.getM_AttributeSetInstance_ID() != 0 || storages.length != 1) && (ma = new MInventoryLineMA(il, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand())).save()) continue;
                }
                il.setQtyBook(onHand);
                il.setQtyCount(onHand);
                if (!il.save()) continue;
                ++no;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.log.info("#" + no);
        return no;
    }
}

