/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MConversionRate;
import org.compiere.model.X_I_Conversion_Rate;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ImportConversionRate
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_C_ConversionType_ID = 0;
    private Timestamp p_ValidFrom = null;
    private boolean p_CreateReciprocalRate = false;
    private boolean p_DeleteOldImported = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Client_ID")) {
                this.p_AD_Client_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_ConversionType_ID")) {
                this.p_C_ConversionType_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("ValidFrom")) {
                this.p_ValidFrom = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("CreateReciprocalRate")) {
                this.p_CreateReciprocalRate = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.p_DeleteOldImported = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("doIt - AD_Client_ID=" + this.p_AD_Client_ID + ",AD_Org_ID=" + this.p_AD_Org_ID + ",C_ConversionType_ID=" + this.p_C_ConversionType_ID + ",ValidFrom=" + this.p_ValidFrom + ",CreateReciprocalRate=" + this.p_CreateReciprocalRate);
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.p_AD_Client_ID;
        if (this.p_DeleteOldImported) {
            sql = new StringBuffer("DELETE I_Conversion_Rate WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_Conversion_Rate SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.p_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID,").append(this.p_AD_Org_ID).append("),");
        if (this.p_C_ConversionType_ID != 0) {
            sql.append(" C_ConversionType_ID = COALESCE (C_ConversionType_ID,").append(this.p_C_ConversionType_ID).append("),");
        }
        if (this.p_ValidFrom != null) {
            sql.append(" ValidFrom = COALESCE (ValidFrom,").append(DB.TO_DATE(this.p_ValidFrom)).append("),");
        } else {
            sql.append(" ValidFrom = COALESCE (ValidFrom,SysDate),");
        }
        sql.append(" CreateReciprocalRate = COALESCE (CreateReciprocalRate,'").append(this.p_CreateReciprocalRate ? "Y" : "N").append("'), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = ").append(this.getAD_User_ID()).append(", I_ErrorMsg = NULL, Processed = 'N', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.info("Reset =" + no);
        sql = new StringBuffer("UPDATE I_Conversion_Rate o SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, 'WHERE (AD_Org_ID IS NULL OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N'))) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Org =" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Conversion_Rate i SET C_ConversionType_ID = (SELECT C_ConversionType_ID FROM C_ConversionType c WHERE c.Value=i.ConversionTypeValue AND c.AD_Client_ID IN (0,i.AD_Client_ID) AND c.IsActive='Y') WHERE C_ConversionType_ID IS NULL AND ConversionTypeValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) > 0) {
            this.log.fine("Set ConversionType =" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Conversion_Rate i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid ConversionType, ' WHERE (C_ConversionType_ID IS NULL OR NOT EXISTS (SELECT * FROM C_ConversionType c WHERE i.C_ConversionType_ID=c.C_ConversionType_ID AND c.IsActive='Y' AND c.AD_Client_ID IN (0,i.AD_Client_ID))) AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("Invalid ConversionType =" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Conversion_Rate i SET C_Currency_ID = (SELECT C_Currency_ID FROM C_Currency c\tWHERE c.ISO_Code=i.ISO_Code AND c.AD_Client_ID IN (0,i.AD_Client_ID) AND c.IsActive='Y') WHERE C_Currency_ID IS NULL AND ISO_Code IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) > 0) {
            this.log.fine("Set Currency =" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Conversion_Rate i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Currency, ' WHERE (C_Currency_ID IS NULL OR NOT EXISTS (SELECT * FROM C_Currency c WHERE i.C_Currency_ID=c.C_Currency_ID AND c.IsActive='Y' AND c.AD_Client_ID IN (0,i.AD_Client_ID))) AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("Invalid Currency =" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Conversion_Rate i SET C_Currency_ID_To = (SELECT C_Currency_ID FROM C_Currency c\tWHERE c.ISO_Code=i.ISO_Code_To AND c.AD_Client_ID IN (0,i.AD_Client_ID) AND c.IsActive='Y') WHERE C_Currency_ID_To IS NULL AND ISO_Code_To IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) > 0) {
            this.log.fine("Set Currency To =" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Conversion_Rate i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Currency To, ' WHERE (C_Currency_ID_To IS NULL OR NOT EXISTS (SELECT * FROM C_Currency c WHERE i.C_Currency_ID_To=c.C_Currency_ID AND c.IsActive='Y' AND c.AD_Client_ID IN (0,i.AD_Client_ID))) AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("Invalid Currency To =" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Conversion_Rate i SET MultiplyRate = 1 / DivideRate WHERE (MultiplyRate IS NULL OR MultiplyRate = 0) AND DivideRate IS NOT NULL AND DivideRate<>0 AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) > 0) {
            this.log.fine("Set MultiplyRate =" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Conversion_Rate i SET DivideRate = 1 / MultiplyRate WHERE (DivideRate IS NULL OR DivideRate = 0) AND MultiplyRate IS NOT NULL AND MultiplyRate<>0 AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) > 0) {
            this.log.fine("Set DivideRate =" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Conversion_Rate i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Rates, ' WHERE (MultiplyRate IS NULL OR MultiplyRate = 0 OR DivideRate IS NULL OR DivideRate = 0) AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("Invalid Rates =" + no);
        }
        this.commit();
        int noInsert = 0;
        sql = new StringBuffer("SELECT * FROM I_Conversion_Rate WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY C_Currency_ID, C_Currency_ID_To, ValidFrom");
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_I_Conversion_Rate imp = new X_I_Conversion_Rate(this.getCtx(), rs, this.get_TrxName());
                MConversionRate rate = new MConversionRate(imp, imp.getC_ConversionType_ID(), imp.getC_Currency_ID(), imp.getC_Currency_ID_To(), imp.getMultiplyRate(), imp.getValidFrom());
                if (imp.getValidTo() != null) {
                    rate.setValidTo(imp.getValidTo());
                }
                if (!rate.save()) continue;
                imp.setC_Conversion_Rate_ID(rate.getC_Conversion_Rate_ID());
                imp.setI_IsImported(true);
                imp.setProcessed(true);
                imp.save();
                ++noInsert;
                if (!imp.isCreateReciprocalRate()) continue;
                rate = new MConversionRate(imp, imp.getC_ConversionType_ID(), imp.getC_Currency_ID_To(), imp.getC_Currency_ID(), imp.getDivideRate(), imp.getValidFrom());
                if (imp.getValidTo() != null) {
                    rate.setValidTo(imp.getValidTo());
                }
                if (!rate.save()) continue;
                ++noInsert;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        sql = new StringBuffer("UPDATE I_Conversion_Rate SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_Conversion_Rate_ID@: @Inserted@");
        return "";
    }
}

