/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class ExpenseAPInvoice
extends SvrProcess {
    private int m_C_BPartner_ID = 0;
    private Timestamp m_DateFrom = null;
    private Timestamp m_DateTo = null;
    private int m_noInvoices = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_BPartner_ID")) {
                this.m_C_BPartner_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("DateReport")) {
                this.m_DateFrom = (Timestamp)para[i2].getParameter();
                this.m_DateTo = (Timestamp)para[i2].getParameter_To();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doIt() throws Exception {
        StringBuffer sql = new StringBuffer("SELECT * FROM S_TimeExpense e WHERE e.Processed='Y' AND e.AD_Client_ID=?");
        if (this.m_C_BPartner_ID != 0) {
            sql.append(" AND e.C_BPartner_ID=?");
        }
        if (this.m_DateFrom != null) {
            sql.append(" AND e.DateReport >= ?");
        }
        if (this.m_DateTo != null) {
            sql.append(" AND e.DateReport <= ?");
        }
        sql.append(" AND EXISTS (SELECT * FROM S_TimeExpenseLine el WHERE e.S_TimeExpense_ID=el.S_TimeExpense_ID AND el.C_InvoiceLine_ID IS NULL AND el.ConvertedAmt<>0) ORDER BY e.C_BPartner_ID, e.S_TimeExpense_ID");
        int old_BPartner_ID = -1;
        MInvoice invoice = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            int par = 1;
            pstmt.setInt(par++, this.getAD_Client_ID());
            if (this.m_C_BPartner_ID != 0) {
                pstmt.setInt(par++, this.m_C_BPartner_ID);
            }
            if (this.m_DateFrom != null) {
                pstmt.setTimestamp(par++, this.m_DateFrom);
            }
            if (this.m_DateTo != null) {
                pstmt.setTimestamp(par++, this.m_DateTo);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MTimeExpense te = new MTimeExpense(this.getCtx(), rs, this.get_TrxName());
                if (te.getC_BPartner_ID() != old_BPartner_ID) {
                    this.completeInvoice(invoice);
                    MBPartner bp = new MBPartner(this.getCtx(), te.getC_BPartner_ID(), this.get_TrxName());
                    this.log.info("New Invoice for " + bp);
                    invoice = new MInvoice(this.getCtx(), 0, null);
                    invoice.setClientOrg(te.getAD_Client_ID(), te.getAD_Org_ID());
                    invoice.setC_DocTypeTarget_ID("API");
                    invoice.setDocumentNo(te.getDocumentNo());
                    invoice.setBPartner(bp);
                    if (invoice.getC_BPartner_Location_ID() == 0) {
                        this.log.log(Level.SEVERE, "No BP Location: " + bp);
                        this.addLog(0, te.getDateReport(), null, "No Location: " + te.getDocumentNo() + " " + bp.getName());
                        invoice = null;
                        break;
                    }
                    invoice.setM_PriceList_ID(te.getM_PriceList_ID());
                    invoice.setSalesRep_ID(te.getDoc_User_ID());
                    String descr = Msg.translate(this.getCtx(), "S_TimeExpense_ID") + ": " + te.getDocumentNo() + " " + DisplayType.getDateFormat(15).format(te.getDateReport());
                    invoice.setDescription(descr);
                    if (!invoice.save()) {
                        new IllegalStateException("Cannot save Invoice");
                    }
                    old_BPartner_ID = bp.getC_BPartner_ID();
                }
                MTimeExpenseLine[] tel = te.getLines(false);
                for (int i2 = 0; i2 < tel.length; ++i2) {
                    MTimeExpenseLine line = tel[i2];
                    if (line.getC_InvoiceLine_ID() != 0 || Env.ZERO.compareTo(line.getQtyReimbursed()) == 0 || Env.ZERO.compareTo(line.getPriceReimbursed()) == 0) continue;
                    if (line.getC_Activity_ID() != 0 && line.getC_Activity_ID() != invoice.getC_Activity_ID()) {
                        invoice.setC_Activity_ID(line.getC_Activity_ID());
                    }
                    if (line.getC_Campaign_ID() != 0 && line.getC_Campaign_ID() != invoice.getC_Campaign_ID()) {
                        invoice.setC_Campaign_ID(line.getC_Campaign_ID());
                    }
                    if (line.getC_Project_ID() != 0 && line.getC_Project_ID() != invoice.getC_Project_ID()) {
                        invoice.setC_Project_ID(line.getC_Project_ID());
                    }
                    if (!invoice.save()) {
                        new IllegalStateException("Cannot save Invoice");
                    }
                    MInvoiceLine il = new MInvoiceLine(invoice);
                    if (line.getM_Product_ID() != 0) {
                        il.setM_Product_ID(line.getM_Product_ID(), true);
                    }
                    il.setQty(line.getQtyReimbursed());
                    il.setDescription(line.getDescription());
                    il.setC_Project_ID(line.getC_Project_ID());
                    il.setC_ProjectPhase_ID(line.getC_ProjectPhase_ID());
                    il.setC_ProjectTask_ID(line.getC_ProjectTask_ID());
                    il.setC_Activity_ID(line.getC_Activity_ID());
                    il.setC_Campaign_ID(line.getC_Campaign_ID());
                    il.setPrice(line.getPriceReimbursed());
                    il.setTax();
                    if (!il.save()) {
                        new IllegalStateException("Cannot save Invoice Line");
                    }
                    line.setC_InvoiceLine_ID(il.getC_InvoiceLine_ID());
                    line.save();
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        this.completeInvoice(invoice);
        return "@Created@=" + this.m_noInvoices;
    }

    private void completeInvoice(MInvoice invoice) {
        if (invoice == null) {
            return;
        }
        invoice.setDocAction("PR");
        invoice.processIt("PR");
        if (!invoice.save()) {
            new IllegalStateException("Cannot save Invoice");
        }
        ++this.m_noInvoices;
        this.addLog(invoice.get_ID(), invoice.getDateInvoiced(), invoice.getGrandTotal(), invoice.getDocumentNo());
    }
}

