/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDunningLevel;
import org.compiere.model.MDunningRun;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.MMailText;
import org.compiere.model.MQuery;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.EMail;
import org.compiere.util.Language;

public class DunningPrint
extends SvrProcess {
    private boolean p_EMailPDF = false;
    private int p_R_MailText_ID = 0;
    private int p_C_DunningRun_ID = 0;
    private boolean p_IsOnlyIfBPBalance = true;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("EMailPDF")) {
                this.p_EMailPDF = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("R_MailText_ID")) {
                this.p_R_MailText_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_DunningRun_ID")) {
                this.p_C_DunningRun_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("IsOnlyIfBPBalance")) {
                this.p_IsOnlyIfBPBalance = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        MDunningRun run;
        this.log.info("C_DunningRun_ID=" + this.p_C_DunningRun_ID + ",R_MailText_ID=" + this.p_R_MailText_ID + ", EmailPDF=" + this.p_EMailPDF + ",IsOnlyIfBPBalance=" + this.p_IsOnlyIfBPBalance);
        if (this.p_EMailPDF && this.p_R_MailText_ID == 0) {
            throw new AdempiereUserError("@NotFound@: @R_MailText_ID@");
        }
        String subject = "";
        MMailText mText = null;
        if (this.p_EMailPDF) {
            mText = new MMailText(this.getCtx(), this.p_R_MailText_ID, this.get_TrxName());
            if (this.p_EMailPDF && mText.get_ID() == 0) {
                throw new AdempiereUserError("@NotFound@: @R_MailText_ID@ - " + this.p_R_MailText_ID);
            }
            subject = mText.getMailHeader();
        }
        if ((run = new MDunningRun(this.getCtx(), this.p_C_DunningRun_ID, this.get_TrxName())).get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@: @C_DunningRun_ID@ - " + this.p_C_DunningRun_ID);
        }
        MDunningLevel level = new MDunningLevel(this.getCtx(), run.getC_DunningLevel_ID(), this.get_TrxName());
        MPrintFormat format = MPrintFormat.get(this.getCtx(), level.getDunning_PrintFormat_ID(), false);
        MClient client = MClient.get(this.getCtx());
        int count = 0;
        int errors = 0;
        MDunningRunEntry[] entries = run.getEntries(false);
        for (int i2 = 0; i2 < entries.length; ++i2) {
            MDunningRunEntry entry = entries[i2];
            if (this.p_IsOnlyIfBPBalance && entry.getAmt().signum() <= 0) continue;
            MBPartner bp = new MBPartner(this.getCtx(), entry.getC_BPartner_ID(), this.get_TrxName());
            if (bp.get_ID() == 0) {
                this.addLog(entry.get_ID(), null, null, "@NotFound@: @C_BPartner_ID@ " + entry.getC_BPartner_ID());
                ++errors;
                continue;
            }
            MUser to = new MUser(this.getCtx(), entry.getAD_User_ID(), this.get_TrxName());
            if (this.p_EMailPDF) {
                if (to.get_ID() == 0) {
                    this.addLog(entry.get_ID(), null, null, "@NotFound@: @AD_User_ID@ - " + bp.getName());
                    ++errors;
                    continue;
                }
                if (to.getEMail() == null || to.getEMail().length() == 0) {
                    this.addLog(entry.get_ID(), null, null, "@NotFound@: @EMail@ - " + to.getName());
                    ++errors;
                    continue;
                }
            }
            Language language = Language.getLoginLanguage();
            String tableName = "C_Dunning_Header_v";
            if (client.isMultiLingualDocument()) {
                tableName = tableName + "t";
                String AD_Language = bp.getAD_Language();
                if (AD_Language != null) {
                    language = Language.getLanguage(AD_Language);
                }
            }
            format.setLanguage(language);
            format.setTranslationLanguage(language);
            MQuery query = new MQuery(tableName);
            query.addRestriction("C_DunningRunEntry_ID", "=", new Integer(entry.getC_DunningRunEntry_ID()));
            PrintInfo info = new PrintInfo(bp.getName(), 527, entry.getC_DunningRunEntry_ID(), entry.getC_BPartner_ID());
            info.setDescription(bp.getName() + ", Amt=" + entry.getAmt());
            ReportEngine re = new ReportEngine(this.getCtx(), format, query, info);
            boolean printed = false;
            if (this.p_EMailPDF) {
                EMail email = client.createEMail(to.getEMail(), null, null);
                if (!email.isValid()) {
                    this.addLog(entry.get_ID(), null, null, "@RequestActionEMailError@ Invalid EMail: " + to);
                    ++errors;
                    continue;
                }
                mText.setUser(to);
                mText.setBPartner(bp);
                mText.setPO(entry);
                String message = mText.getMailText(true);
                if (mText.isHtml()) {
                    email.setMessageHTML(mText.getMailHeader(), message);
                } else {
                    email.setSubject(mText.getMailHeader());
                    email.setMessageText(message);
                }
                File attachment = re.getPDF(File.createTempFile("Dunning", ".pdf"));
                this.log.fine(to + " - " + attachment);
                email.addAttachment(attachment);
                String msg = email.send();
                MUserMail um = new MUserMail(mText, entry.getAD_User_ID(), email);
                um.save();
                if (msg.equals("OK")) {
                    this.addLog(entry.get_ID(), null, null, bp.getName() + " @RequestActionEMailOK@");
                    ++count;
                    printed = true;
                } else {
                    this.addLog(entry.get_ID(), null, null, bp.getName() + " @RequestActionEMailError@ " + msg);
                    ++errors;
                }
            } else {
                re.print();
                ++count;
                printed = true;
            }
            if (!printed) continue;
            entry.setProcessed(true);
            entry.save();
        }
        if (this.p_EMailPDF) {
            return "@Sent@=" + count + " - @Errors@=" + errors;
        }
        return "@Printed@=" + count;
    }
}

