/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.PO;
import org.compiere.process.AdempiereServer;
import org.compiere.process.StateEngine;

public class AdempiereService
extends StateEngine {
    private AdempiereServer m_server = null;
    private Class m_serverClass = null;
    private PO m_processor = null;

    public AdempiereService(PO processor, Class serverClass) {
        this.m_processor = processor;
        this.m_serverClass = serverClass;
    }

    public AdempiereServer getCompierServer() {
        this.getState();
        return this.m_server;
    }

    public String getState() {
        if (this.isRunning() && (this.m_server == null || !this.m_server.isAlive())) {
            this.terminate();
        }
        return super.getState();
    }

    public boolean start() {
        if (!super.start()) {
            return false;
        }
        boolean ok = false;
        try {
            this.m_server = (AdempiereServer)this.m_serverClass.newInstance();
            this.m_server.setProcessor(this.m_processor);
            this.m_server.start();
            ok = true;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "start", e);
            ok = false;
        }
        if (!ok) {
            return this.abort();
        }
        this.log.info("start - " + ok);
        this.getState();
        return ok;
    }

    public boolean resume() {
        if (!super.resume()) {
            return false;
        }
        boolean ok = false;
        try {
            this.m_server = (AdempiereServer)this.m_serverClass.newInstance();
            this.m_server.setProcessor(this.m_processor);
            this.m_server.start();
            ok = true;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "resume", e);
            ok = false;
        }
        if (!ok) {
            return this.abort();
        }
        this.log.info("resume - " + ok);
        this.getState();
        return ok;
    }

    public boolean complete() {
        if (!super.complete()) {
            return false;
        }
        boolean ok = false;
        if (this.m_server != null && this.m_server.isAlive()) {
            try {
                this.m_server.interrupt();
                this.m_server.join();
                ok = true;
            }
            catch (Exception e) {
                return this.abort();
            }
        }
        this.log.info("complete - " + ok);
        return ok;
    }

    public boolean suspend() {
        if (!super.suspend()) {
            return false;
        }
        boolean ok = false;
        if (this.m_server != null && this.m_server.isAlive()) {
            try {
                this.m_server.interrupt();
                this.m_server.join();
                ok = true;
            }
            catch (Exception e) {
                return this.abort();
            }
        }
        this.log.info("suspend - " + ok);
        return ok;
    }

    public boolean abort() {
        if (super.abort()) {
            if (this.m_server != null && this.m_server.isAlive()) {
                try {
                    this.m_server.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.log.info("abort - done");
            return true;
        }
        return false;
    }

    public boolean terminate() {
        if (super.terminate()) {
            if (this.m_server != null && this.m_server.isAlive()) {
                try {
                    this.m_server.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.log.info("terminate - done");
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AdempiereService[");
        sb.append(this.getStateInfo()).append(" - ").append(this.m_server);
        sb.append("]");
        return sb.toString();
    }
}

