/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.compiere.model.MQuery;
import org.compiere.print.ArchiveEngine;
import org.compiere.print.CPaper;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.print.layout.Page;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;

public class View
extends CPanel {
    private LayoutEngine m_layout;
    private int m_zoomLevel = 0;
    public static final String[] ZOOM_OPTIONS = new String[]{"100%", "75%", "50%"};
    public static int MARGIN = 5;
    private static Color COLOR_BACKGROUND = Color.lightGray;
    private static CLogger log = CLogger.getCLogger(View.class);

    public View(LayoutEngine layout) {
        this.m_layout = layout;
    }

    public Dimension getMinimumSize() {
        return this.getMaximumSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.getPaperWidth() + 2 * MARGIN, (this.getPaperHeight() + MARGIN) * this.getPageCount() + MARGIN);
    }

    public Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    public boolean isArchivable() {
        return ArchiveEngine.isValid(this.m_layout);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        Rectangle bounds = g2D.getClipBounds();
        g2D.setColor(COLOR_BACKGROUND);
        g2D.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        for (int page = 0; page < this.m_layout.getPages().size(); ++page) {
            Rectangle pageRectangle = this.getRectangleOfPage(page + 1);
            if (!bounds.intersects(pageRectangle)) continue;
            Page p2 = (Page)this.m_layout.getPages().get(page);
            p2.paint(g2D, pageRectangle, true, false);
            this.m_layout.getHeaderFooter().paint(g2D, pageRectangle, true);
        }
    }

    public void setZoomLevel(int level) {
        this.m_zoomLevel = level;
    }

    public void setZoomLevel(String levelString) {
        for (int i2 = 0; i2 < ZOOM_OPTIONS.length; ++i2) {
            if (!ZOOM_OPTIONS[i2].equals(levelString)) continue;
            this.m_zoomLevel = i2;
            break;
        }
    }

    public int getZoomLevel() {
        return this.m_zoomLevel;
    }

    public Rectangle getRectangleOfPage(int pageNo) {
        int y = MARGIN + (pageNo - 1) * (this.getPaperHeight() + MARGIN);
        return new Rectangle(MARGIN, y, this.getPaperWidth(), this.getPaperHeight());
    }

    public float getPageNoAt(Point p2) {
        float y = p2.y;
        float pageHeight = this.getPaperHeight() + MARGIN;
        return 1.0f + y / pageHeight;
    }

    public int getPageCount() {
        return this.m_layout.getPages().size();
    }

    public String getPageInfo(int pageNo) {
        return this.m_layout.getPageInfo(pageNo);
    }

    public String getPageInfoMax() {
        return this.m_layout.getPageInfoMax();
    }

    public CPaper getPaper() {
        return this.m_layout.getPaper();
    }

    public int getPaperHeight() {
        return (int)this.m_layout.getPaper().getHeight(true);
    }

    public int getPaperWidth() {
        return (int)this.m_layout.getPaper().getWidth(true);
    }

    public MQuery getDrillDown(Point absolutePoint) {
        int pageNo = (int)this.getPageNoAt(absolutePoint);
        Rectangle pageRectangle = this.getRectangleOfPage(pageNo);
        Point relativePoint = new Point(absolutePoint.x - pageRectangle.x, absolutePoint.y - pageRectangle.y);
        Page page = (Page)this.m_layout.getPages().get(pageNo - 1);
        log.config("Relative=" + relativePoint + ", " + page);
        MQuery retValue = page.getDrillDown(relativePoint);
        if (retValue == null) {
            retValue = this.m_layout.getHeaderFooter().getDrillDown(relativePoint);
        }
        return retValue;
    }

    public MQuery getDrillAcross(Point absolutePoint) {
        int pageNo = (int)this.getPageNoAt(absolutePoint);
        Rectangle pageRectangle = this.getRectangleOfPage(pageNo);
        Point relativePoint = new Point(absolutePoint.x - pageRectangle.x, absolutePoint.y - pageRectangle.y);
        Page page = (Page)this.m_layout.getPages().get(pageNo - 1);
        log.config("Relative=" + relativePoint + ", " + page);
        return page.getDrillAcross(relativePoint);
    }
}

