/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.util.logging.Level;
import javax.swing.JFrame;
import org.compiere.apps.ADialog;
import org.compiere.apps.AMenu;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MQuery;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.print.Viewer;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ReportCtl {
    private static CLogger s_log = CLogger.getCLogger(ReportCtl.class);

    private ReportCtl() {
    }

    public static boolean start(ProcessInfo pi, boolean IsDirectPrint) {
        s_log.info("start - " + pi);
        if (pi.getAD_Process_ID() == 110) {
            return ReportCtl.startDocumentPrint(0, pi.getRecord_ID(), IsDirectPrint);
        }
        if (pi.getAD_Process_ID() == 116) {
            return ReportCtl.startDocumentPrint(2, pi.getRecord_ID(), IsDirectPrint);
        }
        if (pi.getAD_Process_ID() == 117) {
            return ReportCtl.startDocumentPrint(1, pi.getRecord_ID(), IsDirectPrint);
        }
        if (pi.getAD_Process_ID() == 217) {
            return ReportCtl.startDocumentPrint(3, pi.getRecord_ID(), IsDirectPrint);
        }
        if (pi.getAD_Process_ID() == 276) {
            return ReportCtl.startDocumentPrint(4, pi.getRecord_ID(), IsDirectPrint);
        }
        if (pi.getAD_Process_ID() == 313) {
            return ReportCtl.startCheckPrint(pi.getRecord_ID(), IsDirectPrint);
        }
        if (pi.getAD_Process_ID() == 290) {
            return ReportCtl.startDocumentPrint(8, pi.getRecord_ID(), IsDirectPrint);
        }
        if (pi.getAD_Process_ID() == 159) {
            return ReportCtl.startDocumentPrint(7, pi.getRecord_ID(), IsDirectPrint);
        }
        if (pi.getAD_Process_ID() == 202 || pi.getAD_Process_ID() == 204) {
            return ReportCtl.startFinReport(pi);
        }
        return ReportCtl.startStandardReport(pi, IsDirectPrint);
    }

    public static boolean startStandardReport(ProcessInfo pi, boolean IsDirectPrint) {
        ReportEngine re = ReportEngine.get(Env.getCtx(), pi);
        if (re == null) {
            pi.setSummary("No ReportEngine");
            return false;
        }
        if (IsDirectPrint) {
            re.print();
        } else {
            ReportCtl.preview(re);
        }
        return true;
    }

    public static boolean startFinReport(ProcessInfo pi) {
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        String TableName = pi.getAD_Process_ID() == 202 ? "T_Report" : "T_ReportStatement";
        MQuery query = MQuery.get(Env.getCtx(), pi.getAD_PInstance_ID(), TableName);
        MPrintFormat format = (MPrintFormat)pi.getTransientObject();
        if (format == null) {
            format = (MPrintFormat)pi.getSerializableObject();
        }
        if (format == null) {
            s_log.log(Level.SEVERE, "startFinReport - No PrintFormat");
            return false;
        }
        PrintInfo info = new PrintInfo(pi);
        ReportEngine re = new ReportEngine(Env.getCtx(), format, query, info);
        ReportCtl.preview(re);
        return true;
    }

    public static boolean startDocumentPrint(int type, int Record_ID, boolean IsDirectPrint) {
        ReportEngine re = ReportEngine.get(Env.getCtx(), type, Record_ID);
        if (re == null) {
            ADialog.error(0, null, "NoDocPrintFormat");
            return false;
        }
        if (IsDirectPrint) {
            re.print();
            ReportEngine.printConfirm(type, Record_ID);
        } else {
            ReportCtl.preview(re);
        }
        return true;
    }

    public static boolean startCheckPrint(int C_Payment_ID, boolean IsDirectPrint) {
        int C_PaySelectionCheck_ID = 0;
        MPaySelectionCheck psc = MPaySelectionCheck.getOfPayment(Env.getCtx(), C_Payment_ID, null);
        if (psc != null) {
            C_PaySelectionCheck_ID = psc.getC_PaySelectionCheck_ID();
        } else {
            psc = MPaySelectionCheck.createForPayment(Env.getCtx(), C_Payment_ID, null);
            if (psc != null) {
                C_PaySelectionCheck_ID = psc.getC_PaySelectionCheck_ID();
            }
        }
        return ReportCtl.startDocumentPrint(6, C_PaySelectionCheck_ID, IsDirectPrint);
    }

    private static void preview(ReportEngine re) {
        Viewer viewer = new Viewer(re);
        JFrame top = Env.getWindow(0);
        if (top instanceof AMenu) {
            ((AMenu)top).getWindowManager().add(viewer);
        }
    }
}

