/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.compiere.apps.ADialog;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.print.Viewer;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;

public class AReport
implements ActionListener {
    private MQuery m_query;
    private JPopupMenu m_popup = new JPopupMenu("ReportMenu");
    private ArrayList<KeyNamePair> m_list = new ArrayList();
    private static CLogger log = CLogger.getCLogger(AReport.class);

    public AReport(int AD_Table_ID, JComponent invoker, MQuery query) {
        log.config("AD_Table_ID=" + AD_Table_ID + " " + query);
        if (!MRole.getDefault().isCanReport(AD_Table_ID)) {
            ADialog.error(0, invoker, "AccessCannotReport", query.getTableName());
            return;
        }
        this.m_query = query;
        this.getPrintFormats(AD_Table_ID, invoker);
    }

    private void getPrintFormats(int AD_Table_ID, JComponent invoker) {
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        String sql = MRole.getDefault().addAccessSQL("SELECT AD_PrintFormat_ID, Name, AD_Client_ID FROM AD_PrintFormat WHERE AD_Table_ID=? AND IsTableBased='Y' ORDER BY AD_Client_ID DESC, IsDefault DESC, Name", "AD_PrintFormat", false, false);
        KeyNamePair pp = null;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                if (rs.getInt(3) != AD_Client_ID) continue;
                this.m_list.add(pp);
                this.m_popup.add(pp.toString()).addActionListener(this);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (this.m_list.size() == 0) {
            if (pp == null) {
                this.createNewFormat(AD_Table_ID);
            } else {
                this.copyFormat(pp.getKey(), AD_Client_ID);
            }
        } else if (this.m_list.size() == 1 || invoker == null) {
            this.launchReport(this.m_list.get(0));
        } else if (invoker.isShowing()) {
            this.m_popup.show(invoker, 0, invoker.getHeight());
        }
    }

    private void createNewFormat(int AD_Table_ID) {
        MPrintFormat pf = MPrintFormat.createFromTable(Env.getCtx(), AD_Table_ID);
        this.launchReport(pf);
    }

    private void copyFormat(int AD_PrintFormat_ID, int To_Client_ID) {
        MPrintFormat pf = MPrintFormat.copyToClient(Env.getCtx(), AD_PrintFormat_ID, To_Client_ID);
        this.launchReport(pf);
    }

    private void launchReport(KeyNamePair pp) {
        MPrintFormat pf = MPrintFormat.get(Env.getCtx(), pp.getKey(), false);
        this.launchReport(pf);
    }

    private void launchReport(MPrintFormat pf) {
        int Record_ID = 0;
        if (this.m_query.getRestrictionCount() == 1 && this.m_query.getCode(0) instanceof Integer) {
            Record_ID = (Integer)this.m_query.getCode(0);
        }
        PrintInfo info = new PrintInfo(pf.getName(), pf.getAD_Table_ID(), Record_ID);
        info.setDescription(this.m_query.getInfo());
        ReportEngine re = new ReportEngine(Env.getCtx(), pf, this.m_query, info);
        new Viewer(re);
    }

    public void actionPerformed(ActionEvent e) {
        this.m_popup.setCursor(Cursor.getPredefinedCursor(3));
        String cmd = e.getActionCommand();
        for (int i2 = 0; i2 < this.m_list.size(); ++i2) {
            KeyNamePair pp = this.m_list.get(i2);
            if (!cmd.equals(pp.getName())) continue;
            this.launchReport(pp);
            return;
        }
    }

    public static int getAD_Table_ID(String TableName) {
        int AD_Table_ID = 0;
        String sql = "SELECT AD_Table_ID FROM AD_Table WHERE TableName=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, TableName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                AD_Table_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        return AD_Table_ID;
    }
}

