/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.logging.Level;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class SubCurrentLine
extends PosSubPanel
implements ActionListener {
    private CButton f_new;
    private CButton f_reset;
    private CButton f_plus;
    private CButton f_minus;
    private CLabel f_currency;
    private VNumber f_price;
    private CLabel f_uom;
    private VNumber f_quantity;
    private MOrder m_order = null;
    private static CLogger log = CLogger.getCLogger(SubCurrentLine.class);

    public SubCurrentLine(PosPanel posPanel) {
        super(posPanel);
    }

    public void init() {
        TitledBorder border = new TitledBorder(Msg.getMsg(Env.getCtx(), "CurrentLine"));
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = INSETS2;
        gbc.gridy = 0;
        this.f_new = this.createButtonAction("New", KeyStroke.getKeyStroke(155, 1));
        gbc.gridx = 0;
        this.add((Component)this.f_new, gbc);
        this.f_reset = this.createButtonAction("Reset", null);
        gbc.gridx = -1;
        this.add((Component)this.f_reset, gbc);
        this.f_currency = new CLabel("---");
        gbc.anchor = 13;
        gbc.weightx = 0.1;
        gbc.fill = 2;
        this.add((Component)this.f_currency, gbc);
        this.f_price = new VNumber("PriceActual", false, false, true, 12, Msg.translate(Env.getCtx(), "PriceActual"));
        this.f_price.addActionListener(this);
        this.f_price.setColumns(10, 25);
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.add((Component)this.f_price, gbc);
        this.setPrice(Env.ZERO);
        this.f_uom = new CLabel("--");
        gbc.anchor = 13;
        gbc.weightx = 0.1;
        gbc.fill = 2;
        this.add((Component)this.f_uom, gbc);
        this.f_minus = this.createButtonAction("Minus", null);
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.add((Component)this.f_minus, gbc);
        this.f_quantity = new VNumber("QtyOrdered", false, false, true, 29, Msg.translate(Env.getCtx(), "QtyOrdered"));
        this.f_quantity.addActionListener(this);
        this.f_quantity.setColumns(5, 25);
        this.add((Component)this.f_quantity, gbc);
        this.setQty(Env.ONE);
        this.f_plus = this.createButtonAction("Plus", null);
        this.add((Component)this.f_plus, gbc);
    }

    public GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        return gbc;
    }

    public void dispose() {
        super.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == null || action.length() == 0) {
            return;
        }
        log.info("SubCurrentLine - actionPerformed: " + action);
        if (action.equals("New")) {
            this.saveLine();
        } else if (action.equals("Reset")) {
            this.newLine();
        } else if (action.equals("Plus")) {
            this.f_quantity.plus();
        } else if (action.equals("Minus")) {
            this.f_quantity.minus(1);
        } else if (e.getSource() == this.f_price) {
            this.f_price.setValue(this.f_price.getValue());
        } else if (e.getSource() == this.f_quantity) {
            this.f_quantity.setValue(this.f_quantity.getValue());
        }
    }

    public void setCurrency(String currency) {
        if (currency == null) {
            this.f_currency.setText("---");
        } else {
            this.f_currency.setText(currency);
        }
    }

    public void setUOM(String UOM) {
        if (UOM == null) {
            this.f_uom.setText("--");
        } else {
            this.f_uom.setText(UOM);
        }
    }

    public void setPrice(BigDecimal price) {
        if (price == null) {
            price = Env.ZERO;
        }
        this.f_price.setValue(price);
        boolean rw = Env.ZERO.compareTo(price) == 0 || this.p_pos.isModifyPrice();
        this.f_price.setReadWrite(rw);
    }

    public BigDecimal getPrice() {
        return (BigDecimal)this.f_price.getValue();
    }

    public void setQty(BigDecimal qty) {
        this.f_quantity.setValue(qty);
    }

    public BigDecimal getQty() {
        return (BigDecimal)this.f_quantity.getValue();
    }

    public void newLine() {
        this.p_posPanel.f_product.setM_Product_ID(0);
        this.setQty(Env.ONE);
        this.setPrice(Env.ZERO);
        this.p_posPanel.f_lines.updateTable(this.m_order);
    }

    public boolean saveLine() {
        BigDecimal PriceActual;
        MProduct product = this.p_posPanel.f_product.getProduct();
        if (product == null) {
            return false;
        }
        BigDecimal QtyOrdered = (BigDecimal)this.f_quantity.getValue();
        MOrderLine line = this.createLine(product, QtyOrdered, PriceActual = (BigDecimal)this.f_price.getValue());
        if (line == null) {
            return false;
        }
        if (!line.save()) {
            return false;
        }
        this.newLine();
        return true;
    }

    public MOrder getOrder() {
        if (this.m_order == null) {
            this.m_order = new MOrder(Env.getCtx(), 0, null);
            this.m_order.setAD_Org_ID(this.p_pos.getAD_Org_ID());
            this.m_order.setIsSOTrx(true);
            if (this.p_pos.getC_DocType_ID() != 0) {
                this.m_order.setC_DocTypeTarget_ID(this.p_pos.getC_DocType_ID());
            } else {
                this.m_order.setC_DocTypeTarget_ID("WR");
            }
            MBPartner partner = this.p_posPanel.f_bpartner.getBPartner();
            if (partner == null || partner.get_ID() == 0) {
                partner = this.p_pos.getBPartner();
            }
            if (partner == null || partner.get_ID() == 0) {
                log.log(Level.SEVERE, "SubCurrentLine.getOrder - no BPartner");
                return null;
            }
            log.info("SubCurrentLine.getOrder -" + partner);
            this.m_order.setBPartner(partner);
            int id = this.p_posPanel.f_bpartner.getC_BPartner_Location_ID();
            if (id != 0) {
                this.m_order.setC_BPartner_Location_ID(id);
            }
            if ((id = this.p_posPanel.f_bpartner.getAD_User_ID()) != 0) {
                this.m_order.setAD_User_ID(id);
            }
            this.m_order.setM_PriceList_ID(this.p_pos.getM_PriceList_ID());
            this.m_order.setM_Warehouse_ID(this.p_pos.getM_Warehouse_ID());
            this.m_order.setSalesRep_ID(this.p_pos.getSalesRep_ID());
            if (!this.m_order.save()) {
                this.m_order = null;
            }
        }
        return this.m_order;
    }

    public MOrderLine createLine(MProduct product, BigDecimal QtyOrdered, BigDecimal PriceActual) {
        MOrder order = this.getOrder();
        if (order == null) {
            return null;
        }
        MOrderLine line = new MOrderLine(order);
        line.setProduct(product);
        line.setQty(QtyOrdered);
        line.setPrice();
        line.setPrice(PriceActual);
        line.save();
        return line;
    }
}

