/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import org.compiere.apps.ADialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.model.MPOS;
import org.compiere.pos.PosKeyboardFocusManager;
import org.compiere.pos.QueryBPartner;
import org.compiere.pos.QueryProduct;
import org.compiere.pos.SubBPartner;
import org.compiere.pos.SubBasicKeys;
import org.compiere.pos.SubCheckout;
import org.compiere.pos.SubCurrentLine;
import org.compiere.pos.SubFunctionKeys;
import org.compiere.pos.SubLines;
import org.compiere.pos.SubProduct;
import org.compiere.pos.SubSalesRep;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class PosPanel
extends CPanel
implements FormPanel {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Properties m_ctx = Env.getCtx();
    private int m_SalesRep_ID = 0;
    protected MPOS p_pos = null;
    private PosKeyboardFocusManager m_focusMgr = null;
    protected StatusBar f_status = new StatusBar();
    protected SubBPartner f_bpartner = null;
    protected SubSalesRep f_salesRep = null;
    protected SubCurrentLine f_curLine = null;
    protected SubProduct f_product = null;
    protected SubLines f_lines = null;
    protected SubFunctionKeys f_functionKeys = null;
    protected SubCheckout f_checkout = null;
    protected SubBasicKeys f_basicKeys = null;
    protected QueryProduct f_queryProduct = null;
    protected QueryBPartner f_queryBPartner = null;
    private Timestamp m_today = Env.getContextAsDate(this.m_ctx, "#Date");

    public PosPanel() {
        super(new GridBagLayout());
        this.m_focusMgr = new PosKeyboardFocusManager();
        KeyboardFocusManager.setCurrentKeyboardFocusManager(this.m_focusMgr);
    }

    public void init(int WindowNo, FormFrame frame) {
        this.m_SalesRep_ID = Env.getAD_User_ID(this.m_ctx);
        this.log.info("init - SalesRep_ID=" + this.m_SalesRep_ID);
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            if (!this.dynInit()) {
                this.dispose();
                frame.dispose();
                return;
            }
            frame.getContentPane().add((Component)this, "Center");
            frame.getContentPane().add((Component)this.f_status, "South");
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "init", e);
        }
        this.log.config("PosPanel.init - " + this.getPreferredSize());
        this.m_focusMgr.start();
    }

    public void dispose() {
        if (this.m_focusMgr != null) {
            this.m_focusMgr.stop();
        }
        this.m_focusMgr = null;
        if (this.f_bpartner != null) {
            this.f_bpartner.dispose();
        }
        this.f_bpartner = null;
        if (this.f_salesRep != null) {
            this.f_salesRep.dispose();
        }
        this.f_salesRep = null;
        if (this.f_curLine != null) {
            this.f_curLine.dispose();
        }
        this.f_curLine = null;
        if (this.f_product != null) {
            this.f_product.dispose();
        }
        this.f_product = null;
        if (this.f_lines != null) {
            this.f_lines.dispose();
        }
        this.f_lines = null;
        if (this.f_functionKeys != null) {
            this.f_functionKeys.dispose();
        }
        this.f_functionKeys = null;
        if (this.f_checkout != null) {
            this.f_checkout.dispose();
        }
        this.f_checkout = null;
        if (this.f_basicKeys != null) {
            this.f_basicKeys.dispose();
        }
        this.f_basicKeys = null;
        if (this.f_queryProduct != null) {
            this.f_queryProduct.dispose();
        }
        this.f_queryProduct = null;
        if (this.f_queryBPartner != null) {
            this.f_queryBPartner.dispose();
        }
        this.f_queryBPartner = null;
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
        this.m_ctx = null;
    }

    private boolean dynInit() {
        if (!this.setMPOS()) {
            return false;
        }
        this.f_bpartner = new SubBPartner(this);
        this.add((Component)this.f_bpartner, this.f_bpartner.getGridBagConstraints());
        this.f_salesRep = new SubSalesRep(this);
        this.add((Component)this.f_salesRep, this.f_salesRep.getGridBagConstraints());
        this.f_curLine = new SubCurrentLine(this);
        this.add((Component)this.f_curLine, this.f_curLine.getGridBagConstraints());
        this.f_product = new SubProduct(this);
        this.add((Component)this.f_product, this.f_product.getGridBagConstraints());
        this.f_lines = new SubLines(this);
        this.add((Component)this.f_lines, this.f_lines.getGridBagConstraints());
        this.f_functionKeys = new SubFunctionKeys(this);
        this.add((Component)this.f_functionKeys, this.f_functionKeys.getGridBagConstraints());
        this.f_checkout = new SubCheckout(this);
        this.add((Component)this.f_checkout, this.f_checkout.getGridBagConstraints());
        this.f_basicKeys = new SubBasicKeys(this);
        this.add((Component)this.f_basicKeys, this.f_basicKeys.getGridBagConstraints());
        this.f_queryProduct = new QueryProduct(this);
        this.add((Component)this.f_queryProduct, this.f_queryProduct.getGridBagConstraints());
        this.f_queryBPartner = new QueryBPartner(this);
        this.add((Component)this.f_queryBPartner, this.f_queryBPartner.getGridBagConstraints());
        this.newOrder();
        return true;
    }

    private boolean setMPOS() {
        String title;
        Object[] poss = null;
        poss = this.m_SalesRep_ID == 100 ? this.getPOSs(0) : this.getPOSs(this.m_SalesRep_ID);
        if (poss.length == 0) {
            ADialog.error(this.m_WindowNo, this.m_frame, "NoPOSForUser");
            return false;
        }
        if (poss.length == 1) {
            this.p_pos = poss[0];
            return true;
        }
        String msg = Msg.getMsg(this.m_ctx, "SelectPOS");
        Object selection = JOptionPane.showInputDialog(this.m_frame, msg, title = Env.getHeader(this.m_ctx, this.m_WindowNo), 3, null, poss, poss[0]);
        if (selection != null) {
            this.p_pos = (MPOS)selection;
            return true;
        }
        return false;
    }

    private MPOS[] getPOSs(int SalesRep_ID) {
        ArrayList<MPOS> list = new ArrayList<MPOS>();
        String sql = "SELECT * FROM C_POS WHERE SalesRep_ID=?";
        if (SalesRep_ID == 0) {
            sql = "SELECT * FROM C_POS WHERE AD_Client_ID=?";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            if (SalesRep_ID != 0) {
                pstmt.setInt(1, this.m_SalesRep_ID);
            } else {
                pstmt.setInt(1, Env.getAD_Client_ID(this.m_ctx));
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MPOS(this.m_ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MPOS[] retValue = new MPOS[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.f_product.f_name.requestFocus();
    }

    public void openQuery(CPanel panel) {
        this.f_checkout.setVisible(false);
        this.f_basicKeys.setVisible(false);
        this.f_lines.setVisible(false);
        this.f_functionKeys.setVisible(false);
        panel.setVisible(true);
    }

    public void closeQuery(CPanel panel) {
        panel.setVisible(false);
        this.f_checkout.setVisible(true);
        this.f_basicKeys.setVisible(true);
        this.f_lines.setVisible(true);
        this.f_functionKeys.setVisible(true);
    }

    public Timestamp getToday() {
        return this.m_today;
    }

    public void newOrder() {
        this.log.info("PosPabel.newOrder");
        this.f_bpartner.setC_BPartner_ID(0);
        this.f_curLine.newLine();
        this.f_product.f_name.requestFocus();
    }
}

