/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import org.compiere.plaf.CompiereColor;
import org.compiere.plaf.CompierePanelUI;
import org.compiere.plaf.CompiereUtils;

public class CompiereTabbedPaneUI
extends MetalTabbedPaneUI {
    public static ComponentUI createUI(JComponent c) {
        return new CompiereTabbedPaneUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.tabPane.setOpaque(false);
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            CompierePanelUI.updateIt(g, c);
        }
        this.paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
        int tabPlacement = this.tabPane.getTabPlacement();
        Insets insets = c.getInsets();
        Dimension size = c.getSize();
        if (this.tabPane.isOpaque()) {
            g.setColor(c.getBackground());
            switch (tabPlacement) {
                case 2: {
                    g.fillRect(insets.left, insets.top, this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth), size.height - insets.bottom - insets.top);
                    break;
                }
                case 3: {
                    int totalTabHeight = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                    g.fillRect(insets.left, size.height - insets.bottom - totalTabHeight, size.width - insets.left - insets.right, totalTabHeight);
                    break;
                }
                case 4: {
                    int totalTabWidth = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                    g.fillRect(size.width - insets.right - totalTabWidth, insets.top, totalTabWidth, size.height - insets.top - insets.bottom);
                    break;
                }
                default: {
                    g.fillRect(insets.left, insets.top, size.width - insets.right - insets.left, this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight));
                    this.paintHighlightBelowTab();
                    break;
                }
            }
        } else {
            super.paint(g, c);
        }
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        GradientPaint paint;
        Graphics2D g2D = (Graphics2D)g;
        Component comp = this.tabPane.getComponentAt(tabIndex);
        g2D.setPaint(comp.getBackground());
        CompiereColor bg = CompiereColor.getDefaultBackground();
        if (comp instanceof JPanel) {
            JPanel jp = (JPanel)comp;
            try {
                bg = (CompiereColor)jp.getClientProperty("CompiereBackground");
            }
            catch (Exception e) {
                System.err.println("AdempiereTabbedPaneUI - ClientProperty: " + e.getMessage());
            }
        }
        if (bg == null) {
            if (CompiereUtils.isLeftToRight(this.tabPane)) {
                switch (tabPlacement) {
                    case 2: {
                        g2D.fillRect(x + 5, y + 1, w - 5, h - 1);
                        g2D.fillRect(x + 2, y + 4, 3, h - 4);
                        break;
                    }
                    case 3: {
                        g2D.fillRect(x + 2, y, w - 2, h - 4);
                        g2D.fillRect(x + 5, y + (h - 1) - 3, w - 5, 3);
                        break;
                    }
                    case 4: {
                        g2D.fillRect(x + 1, y + 1, w - 5, h - 1);
                        g2D.fillRect(x + (w - 1) - 3, y + 5, 3, h - 5);
                        break;
                    }
                    default: {
                        g2D.fillRect(x + 4, y + 2, w - 1 - 3, h - 1 - 1);
                        g2D.fillRect(x + 2, y + 5, 2, h - 5);
                        break;
                    }
                }
            } else {
                switch (tabPlacement) {
                    case 2: {
                        g2D.fillRect(x + 5, y + 1, w - 5, h - 1);
                        g2D.fillRect(x + 2, y + 4, 3, h - 4);
                        break;
                    }
                    case 3: {
                        g2D.fillRect(x, y, w - 5, h - 1);
                        g2D.fillRect(x + (w - 1) - 4, y, 4, h - 5);
                        g2D.fillRect(x + (w - 1) - 4, y + (h - 1) - 4, 2, 2);
                        break;
                    }
                    case 4: {
                        g2D.fillRect(x + 1, y + 1, w - 5, h - 1);
                        g2D.fillRect(x + (w - 1) - 3, y + 5, 3, h - 5);
                        break;
                    }
                    default: {
                        g2D.fillRect(x, y + 2, w - 1 - 3, h - 1 - 1);
                        g2D.fillRect(x + (w - 1) - 3, y + 4, 3, h - 4);
                        break;
                    }
                }
            }
        } else if (CompiereUtils.isLeftToRight(this.tabPane)) {
            switch (tabPlacement) {
                case 2: {
                    bg.paintRect(g2D, this.tabPane, x + 5, y + 1, w - 5, h - 1);
                    bg.paintRect(g2D, this.tabPane, x + 2, y + 4, 3, h - 4);
                    break;
                }
                case 3: {
                    bg.paintRect(g2D, this.tabPane, x + 2, y, w - 2, h - 4);
                    bg.paintRect(g2D, this.tabPane, x + 5, y + (h - 1) - 3, w - 5, 3);
                    break;
                }
                case 4: {
                    bg.paintRect(g2D, this.tabPane, x, y + 2, w - 4, h - 2);
                    bg.paintRect(g2D, this.tabPane, x + (w - 1) - 3, y + 5, 3, h - 5);
                    break;
                }
                default: {
                    bg.paintRect(g2D, this.tabPane, x + 4, y + 2, w - 1 - 3, h - 1 - 1);
                    bg.paintRect(g2D, this.tabPane, x + 2, y + 5, 2, h - 5);
                    break;
                }
            }
        } else {
            switch (tabPlacement) {
                case 2: {
                    bg.paintRect(g2D, this.tabPane, x + 5, y + 1, w - 5, h - 1);
                    bg.paintRect(g2D, this.tabPane, x + 2, y + 4, 3, h - 4);
                    break;
                }
                case 3: {
                    bg.paintRect(g2D, this.tabPane, x, y, w - 5, h - 1);
                    bg.paintRect(g2D, this.tabPane, x + (w - 1) - 4, y, 4, h - 5);
                    bg.paintRect(g2D, this.tabPane, x + (w - 1) - 4, y + (h - 1) - 4, 2, 2);
                    break;
                }
                case 4: {
                    bg.paintRect(g2D, this.tabPane, x + 1, y + 1, w - 5, h - 1);
                    bg.paintRect(g2D, this.tabPane, x + (w - 1) - 3, y + 5, 3, h - 5);
                    break;
                }
                default: {
                    bg.paintRect(g2D, this.tabPane, x, y + 2, w - 1 - 3, h - 1 - 1);
                    bg.paintRect(g2D, this.tabPane, x + (w - 1) - 3, y + 4, 3, h - 4);
                }
            }
        }
        if (!isSelected || tabPlacement != 4 && tabPlacement != 2 && tabPlacement != 3) {
            Shape top = new Rectangle(x, y, w, h / 2);
            if (tabPlacement == 1 || tabPlacement == 2) {
                top = new Polygon(new int[]{x + 6, x + w, x + w, x, x}, new int[]{y, y, y + h / 2, y + h / 2, y + 6}, 5);
            } else if (tabPlacement == 4) {
                top = new Polygon(new int[]{x, x + w - 6, x + w, x + w, x}, new int[]{y, y, y + 6, y + h / 2, y + h / 2}, 5);
            }
            paint = new GradientPaint(x, y, CompiereUtils.COL_1TOP, x, y + h / 2, CompiereUtils.COL_1END);
            g2D.setPaint(paint);
            g2D.fill(top);
        }
        if (!isSelected || tabPlacement != 1 && tabPlacement != 4 && tabPlacement != 2) {
            Shape end = new Rectangle(x, y + h / 2, w, h / 2);
            if (tabPlacement == 3) {
                end = new Polygon(new int[]{x, x + w, x + w, x + 6, x}, new int[]{y + h / 2, y + h / 2, y + h, y + h, y + h - 6}, 5);
            }
            paint = new GradientPaint(x, y + h / 2, CompiereUtils.COL_2TOP, x, y + h, CompiereUtils.COL_2END);
            g2D.setPaint(paint);
            g2D.fill(end);
        }
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        Component comp = null;
        if (selectedIndex != -1) {
            comp = this.tabPane.getComponentAt(selectedIndex);
        }
        if (comp != null && comp instanceof JComponent) {
            JComponent jc = (JComponent)comp;
            CompiereColor bg = null;
            try {
                if (jc != null) {
                    bg = (CompiereColor)jc.getClientProperty("CompiereBackground");
                }
            }
            catch (Exception e) {
                System.err.println("AdempiereTabbedPaneUI - ClientProperty: " + e.getMessage());
            }
            if (bg == null) {
                bg = new CompiereColor(jc.getBackground());
                jc.putClientProperty("CompiereBackground", bg);
            }
            bg.paintRect(g, jc, x, y, w, h);
        } else if (comp != null) {
            g.setColor(comp.getBackground());
            g.fillRect(x, y, w, h);
        }
        this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.selectHighlight);
        if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x, y, x, y + h - 2);
        } else {
            g.drawLine(x, y, x, selRect.y + 1);
            if (selRect.y + selRect.height < y + h - 2) {
                g.drawLine(x, selRect.y + selRect.height + 1, x, y + h - 2);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        boolean leftToRight = CompiereUtils.isLeftToRight(this.tabPane);
        int bottom = y + h - 1;
        int right = x + w - 1;
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.shadow);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.x < x || selRect.x > x + w) {
            g.setColor(this.darkShadow);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        } else {
            boolean lastInRun = this.isLastInRun(selectedIndex);
            g.setColor(this.darkShadow);
            if (leftToRight || lastInRun) {
                g.drawLine(x, bottom, selRect.x, bottom);
            } else {
                g.drawLine(x, bottom, selRect.x - 1, bottom);
            }
            if (selRect.x + selRect.width < x + w - 2) {
                if (leftToRight && !lastInRun) {
                    g.drawLine(selRect.x + selRect.width, bottom, right, bottom);
                } else {
                    g.drawLine(selRect.x + selRect.width - 1, bottom, right, bottom);
                }
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.shadow);
        if (tabPlacement != 4 || selectedIndex < 0 || selRect.y < y || selRect.y > y + h) {
            g.setColor(this.darkShadow);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        } else {
            g.setColor(this.darkShadow);
            g.drawLine(x + w - 1, y, x + w - 1, selRect.y);
            if (selRect.y + selRect.height < y + h - 2) {
                g.setColor(this.darkShadow);
                g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 2);
            }
        }
    }

    private boolean isLastInRun(int tabIndex) {
        int run = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        int lastIndex = this.lastTabInRun(this.tabPane.getTabCount(), run);
        return tabIndex == lastIndex;
    }

    protected boolean shouldFillGap(int currentRun, int tabIndex, int x, int y) {
        return false;
    }

    protected void paintTopTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int currentRun = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        int lastIndex = this.lastTabInRun(this.tabPane.getTabCount(), currentRun);
        int firstIndex = this.tabRuns[currentRun];
        boolean leftToRight = CompiereUtils.isLeftToRight(this.tabPane);
        int bottom = h - 1;
        int right = w - 1;
        if (this.shouldFillGap(currentRun, tabIndex, x, y)) {
            g.translate(x, y);
            if (leftToRight) {
                g.setColor(this.getColorForGap(currentRun, x, y + 1));
                g.fillRect(1, 0, 5, 3);
                g.fillRect(1, 3, 2, 2);
            } else {
                g.setColor(this.getColorForGap(currentRun, x + w - 1, y + 1));
                g.fillRect(right - 5, 0, 5, 3);
                g.fillRect(right - 2, 3, 2, 2);
            }
            g.translate(-x, -y);
        }
        g.translate(x, y);
        g.setColor(this.darkShadow);
        if (leftToRight) {
            g.drawLine(1, 5, 6, 0);
            g.drawLine(6, 0, right, 0);
            if (tabIndex == lastIndex) {
                g.drawLine(right, 1, right, bottom);
            }
            if (tabIndex != this.tabRuns[this.runCount - 1]) {
                g.drawLine(0, 0, 0, bottom);
            } else {
                g.drawLine(0, 6, 0, bottom);
            }
        } else {
            g.drawLine(right - 1, 5, right - 6, 0);
            g.drawLine(right - 6, 0, 0, 0);
            if (tabIndex != this.tabRuns[this.runCount - 1]) {
                g.drawLine(right, 0, right, bottom);
            } else {
                g.drawLine(right, 6, right, bottom);
            }
            if (tabIndex == lastIndex) {
                g.drawLine(0, 1, 0, bottom);
            }
        }
        if (!isSelected) {
            g.drawLine(0, bottom, right, bottom);
        }
        g.setColor(isSelected ? this.selectHighlight : this.highlight);
        if (leftToRight) {
            g.drawLine(1, 6, 6, 1);
            if (tabIndex == lastIndex) {
                g.drawLine(6, 1, right - 1, 1);
            } else {
                g.drawLine(6, 1, right, 1);
            }
            g.drawLine(1, 6, 1, bottom);
            if (tabIndex == firstIndex && tabIndex != this.tabRuns[this.runCount - 1]) {
                if (this.tabPane.getSelectedIndex() == this.tabRuns[currentRun + 1]) {
                    g.setColor(this.selectHighlight);
                } else {
                    g.setColor(this.highlight);
                }
                g.drawLine(1, 0, 1, 4);
            }
        } else {
            g.drawLine(right - 1, 6, right - 6, 1);
            g.drawLine(right - 6, 1, 1, 1);
            if (tabIndex == lastIndex) {
                g.drawLine(1, 1, 1, bottom);
            } else {
                g.drawLine(0, 1, 0, bottom);
            }
        }
        g.translate(-x, -y);
    }

    protected void paintLeftTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int tabCount = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tabCount, tabIndex);
        int lastIndex = this.lastTabInRun(tabCount, currentRun);
        int firstIndex = this.tabRuns[currentRun];
        g.translate(x, y);
        int bottom = h - 1;
        int right = w - 1;
        g.setColor(isSelected ? this.selectHighlight : this.highlight);
        g.drawLine(1, 6, 6, 1);
        g.drawLine(6, 1, right, 1);
        g.drawLine(1, 6, 1, bottom);
        if (!isSelected) {
            g.drawLine(right - 1, 0, right - 1, bottom);
        }
        g.setColor(this.darkShadow);
        g.drawLine(1, 5, 6, 0);
        g.drawLine(6, 0, right, 0);
        g.drawLine(0, 6, 0, bottom);
        g.drawLine(0, bottom, right, bottom);
        if (!isSelected) {
            g.drawLine(right, 0, right, bottom);
        }
        g.translate(-x, -y);
    }

    protected void paintRightTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int tabCount = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tabCount, tabIndex);
        int lastIndex = this.lastTabInRun(tabCount, currentRun);
        int firstIndex = this.tabRuns[currentRun];
        g.translate(x, y);
        int bottom = h - 1;
        int right = w - 1;
        g.setColor(isSelected ? this.selectHighlight : this.highlight);
        g.drawLine(right - 6, 1, right - 1, 6);
        g.drawLine(0, 1, right - 6, 1);
        g.drawLine(right - 1, 6, right - 1, bottom - 1);
        if (!isSelected) {
            g.drawLine(0, 1, 0, bottom - 1);
        }
        g.setColor(this.darkShadow);
        g.drawLine(right - 6, 0, right, 6);
        g.drawLine(0, 0, right - 6, 0);
        g.drawLine(right, 6, right, bottom);
        g.drawLine(0, bottom, right, bottom);
        g.translate(-x, -y);
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        boolean calculate;
        boolean bl = calculate = tabPlacement != 1 && tabPlacement != 3;
        if (this.getTextViewForTab(tabIndex) != null) {
            calculate = false;
        }
        String title = this.tabPane.getTitleAt(tabIndex);
        int pos = title.indexOf(" ");
        if (calculate && pos == -1) {
            calculate = false;
        }
        if (!calculate) {
            return super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        }
        Icon icon = this.getIconForTab(tabIndex);
        Insets tabInsetsLocal = this.getTabInsets(tabPlacement, tabIndex);
        int width = tabInsetsLocal.left + tabInsetsLocal.right + 3;
        if (icon != null) {
            width += icon.getIconWidth() + this.textIconGap;
        }
        String firstLine = title.substring(0, pos);
        String secondLine = title.substring(pos + 1);
        return width += Math.max(SwingUtilities.computeStringWidth(metrics, firstLine), SwingUtilities.computeStringWidth(metrics, secondLine));
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        boolean calculate;
        boolean bl = calculate = tabPlacement != 1 && tabPlacement != 3;
        if (this.getTextViewForTab(tabIndex) != null) {
            calculate = false;
        }
        String title = this.tabPane.getTitleAt(tabIndex);
        int pos = title.indexOf(" ");
        if (calculate && pos == -1) {
            calculate = false;
        }
        if (!calculate) {
            return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
        }
        int height = fontHeight * 2;
        Icon icon = this.getIconForTab(tabIndex);
        Insets tabInsetsLocal = this.getTabInsets(tabPlacement, tabIndex);
        if (icon != null) {
            height = Math.max(height, icon.getIconHeight());
        }
        return height += tabInsetsLocal.top + tabInsetsLocal.bottom + 2;
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        boolean calculate;
        boolean bl = calculate = tabPlacement != 1 && tabPlacement != 3;
        if (this.getTextViewForTab(tabIndex) != null) {
            calculate = false;
        }
        if (!calculate) {
            super.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
            return;
        }
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 1, 2, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        Insets tabInsetsLocal = this.getTabInsets(tabPlacement, tabIndex);
        iconRect.x += (xNudge += tabInsetsLocal.left);
        iconRect.y += (yNudge += tabInsetsLocal.top + 1);
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        boolean calculate;
        boolean bl = calculate = tabPlacement != 1 && tabPlacement != 3;
        if (this.getTextViewForTab(tabIndex) != null) {
            calculate = false;
        }
        if (!calculate) {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
            return;
        }
        String firstLine = title;
        String secondLine = null;
        int pos = title.indexOf(32);
        if (pos != -1) {
            firstLine = title.substring(0, pos);
            secondLine = title.substring(pos + 1);
        }
        g.setFont(font);
        int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
        if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
            Color c = this.tabPane.getForegroundAt(tabIndex);
            if (!isSelected) {
                c = c.equals(Color.black) ? Color.darkGray : c.brighter();
            }
            g.setColor(c);
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, firstLine, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            if (secondLine != null) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, secondLine, mnemIndex - firstLine.length(), textRect.x, textRect.y + metrics.getAscent() + metrics.getHeight());
            }
        } else {
            g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, firstLine, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            if (secondLine != null) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, secondLine, mnemIndex - firstLine.length(), textRect.x, textRect.y + metrics.getAscent() + metrics.getHeight());
            }
            g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, firstLine, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            if (secondLine != null) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, secondLine, mnemIndex - firstLine.length(), textRect.x - 1, textRect.y + metrics.getAscent() + metrics.getHeight() - 1);
            }
        }
    }

    protected LayoutManager createLayoutManager() {
        return new TabbedPaneLayout();
    }

    public class TabbedPaneLayout
    extends MetalTabbedPaneUI.TabbedPaneLayout {
        public TabbedPaneLayout() {
            super(CompiereTabbedPaneUI.this);
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            super.calculateTabRects(tabPlacement, tabCount);
            if (tabPlacement == 1 || tabPlacement == 3) {
                return;
            }
            int tabHeight = CompiereTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
            for (int i2 = 0; i2 < CompiereTabbedPaneUI.this.rects.length; ++i2) {
                int level = 0;
                Component comp = CompiereTabbedPaneUI.this.tabPane.getComponentAt(i2);
                if (comp instanceof JComponent) {
                    JComponent jc = (JComponent)comp;
                    try {
                        Integer ll = (Integer)jc.getClientProperty("CompiereTabLevel");
                        if (ll != null) {
                            level = ll;
                        }
                    }
                    catch (Exception e) {
                        System.err.println("AdempiereTabbedPaneUI - ClientProperty: " + e.getMessage());
                    }
                }
                if (level != 0) {
                    if (tabPlacement == 2) {
                        ((CompiereTabbedPaneUI)CompiereTabbedPaneUI.this).rects[i2].x += level * 5;
                    }
                    ((CompiereTabbedPaneUI)CompiereTabbedPaneUI.this).rects[i2].width -= level * 5;
                }
                ((CompiereTabbedPaneUI)CompiereTabbedPaneUI.this).rects[i2].height = tabHeight;
                if (i2 <= 0) continue;
                ((CompiereTabbedPaneUI)CompiereTabbedPaneUI.this).rects[i2].y = ((CompiereTabbedPaneUI)CompiereTabbedPaneUI.this).rects[i2 - 1].y + tabHeight;
            }
        }
    }
}

