/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.plaf.CompiereUtils;
import org.compiere.swing.ColorBlind;
import org.compiere.swing.ThemeUtils;
import org.compiere.util.KeyNamePair;
import org.compiere.util.ValueNamePair;

public class CompiereColor
implements Serializable {
    public static final String TYPE_FLAT = "F";
    public static final String TYPE_GRADIENT = "G";
    public static final String TYPE_LINES = "L";
    public static final String TYPE_TEXTURE = "T";
    private static ResourceBundle s_res = ResourceBundle.getBundle("org.compiere.plaf.PlafRes");
    public static final String[] TYPE_VALUES = new String[]{"F", "G", "L", "T"};
    public static final String[] TYPE_NAMES = new String[]{s_res.getString("BackColType_Flat"), s_res.getString("BackColType_Gradient"), s_res.getString("BackColType_Lines"), s_res.getString("BackColType_Texture")};
    public static final ValueNamePair[] TYPES = new ValueNamePair[]{new ValueNamePair(TYPE_VALUES[0], TYPE_NAMES[0]), new ValueNamePair(TYPE_VALUES[1], TYPE_NAMES[1]), new ValueNamePair(TYPE_VALUES[2], TYPE_NAMES[2]), new ValueNamePair(TYPE_VALUES[3], TYPE_NAMES[3])};
    public static final int[] GRADIENT_SP_VALUES = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    public static final String[] GRADIENT_SP_NAMES = new String[]{"North", "North-East", "East", "South-East", "South", "South-West", "West", "North-West"};
    public static final KeyNamePair[] GRADIENT_SP = new KeyNamePair[]{new KeyNamePair(GRADIENT_SP_VALUES[0], GRADIENT_SP_NAMES[0]), new KeyNamePair(GRADIENT_SP_VALUES[1], GRADIENT_SP_NAMES[1]), new KeyNamePair(GRADIENT_SP_VALUES[2], GRADIENT_SP_NAMES[2]), new KeyNamePair(GRADIENT_SP_VALUES[3], GRADIENT_SP_NAMES[3]), new KeyNamePair(GRADIENT_SP_VALUES[4], GRADIENT_SP_NAMES[4]), new KeyNamePair(GRADIENT_SP_VALUES[5], GRADIENT_SP_NAMES[5]), new KeyNamePair(GRADIENT_SP_VALUES[6], GRADIENT_SP_NAMES[6]), new KeyNamePair(GRADIENT_SP_VALUES[7], GRADIENT_SP_NAMES[7])};
    private static final String EXCEPTION_TEXT = "Arguments cannot be NULL";
    private String m_type = "G";
    private Color m_primaryColor = UIManager.getColor("Panel.background");
    private Color m_secondaryColor = new Color(245, 245, 245);
    private URL m_textureURL = null;
    private BufferedImage m_image = null;
    private float m_compositeAlpha = 0.7f;
    private float m_lineWidth = 1.0f;
    private int m_lineDistance = 5;
    private int m_startPoint = 8;
    private int m_repeatDistance = 100;
    private ColorBackground m_back = null;
    private boolean m_3d = true;
    private boolean m_dirty = true;
    private static Logger log = Logger.getLogger(CompiereColor.class.getName());

    public static void setBackground(JComponent c) {
        CompiereColor.setBackground(c, new CompiereColor(AdempierePLAF.getFormBackground()));
    }

    public static void setBackground(JComponent c, CompiereColor cc) {
        c.putClientProperty("CompiereBackground", cc);
    }

    public static CompiereColor getBackground(JComponent c) {
        CompiereColor bg = null;
        try {
            bg = (CompiereColor)c.getClientProperty("CompiereBackground");
        }
        catch (Exception e) {
            log.severe("ClientProperty: " + e.getMessage());
        }
        return bg;
    }

    public static void setBackground(Window win) {
        CompiereColor.setBackground(win, new CompiereColor(AdempierePLAF.getFormBackground()));
    }

    public static void setBackground(Window win, CompiereColor cc) {
        if (win instanceof JDialog) {
            ((JPanel)((JDialog)win).getContentPane()).putClientProperty("CompiereBackground", cc);
        } else if (win instanceof JFrame) {
            ((JPanel)((JFrame)win).getContentPane()).putClientProperty("CompiereBackground", cc);
        } else if (win instanceof JWindow) {
            ((JPanel)((JWindow)win).getContentPane()).putClientProperty("CompiereBackground", cc);
        }
    }

    public static CompiereColor getDefaultBackground() {
        return new CompiereColor(AdempierePLAF.getFormBackground());
    }

    public static CompiereColor parse(String attributes) {
        CompiereColor cc = new CompiereColor();
        try {
            if (attributes != null && attributes.length() > 0) {
                cc.parseAttributres(attributes);
            }
        }
        catch (Exception e) {
            log.severe("(" + attributes + ") - " + e.toString());
        }
        return cc;
    }

    public CompiereColor() {
        this(TYPE_GRADIENT);
    }

    public CompiereColor(String type) {
        if (type == null) {
            new IllegalArgumentException(EXCEPTION_TEXT);
        }
        if (type.equals(TYPE_FLAT) || type.equals(TYPE_GRADIENT) || type.equals(TYPE_TEXTURE) || type.equals(TYPE_LINES)) {
            this.m_type = type;
        } else {
            new IllegalArgumentException("Invalid Type");
        }
    }

    public CompiereColor(Color bg) {
        this(bg, true);
    }

    public CompiereColor(Color bg, boolean flat) {
        if (bg == null) {
            new IllegalArgumentException(EXCEPTION_TEXT);
        }
        this.m_type = flat ? TYPE_FLAT : TYPE_GRADIENT;
        this.m_primaryColor = bg;
    }

    public CompiereColor(Color upperColor, Color lowerColor, int startPoint, int repeatDistance) {
        if (upperColor == null || lowerColor == null) {
            new IllegalArgumentException(EXCEPTION_TEXT);
        }
        this.m_type = TYPE_GRADIENT;
        this.m_primaryColor = upperColor;
        this.m_secondaryColor = lowerColor;
        this.m_startPoint = startPoint;
        this.m_repeatDistance = repeatDistance;
    }

    public CompiereColor(Color upperColor, Color lowerColor) {
        this(upperColor, lowerColor, 8, 100);
    }

    public CompiereColor(URL textureURL, Color taint, float compositeAlpha) {
        if (textureURL == null || taint == null) {
            new IllegalArgumentException(EXCEPTION_TEXT);
        }
        this.m_type = TYPE_TEXTURE;
        this.m_textureURL = textureURL;
        this.m_primaryColor = taint;
        this.m_compositeAlpha = compositeAlpha;
    }

    public CompiereColor(String textureURL, Color taint, float compositeAlpha) {
        if (textureURL == null || taint == null) {
            new IllegalArgumentException(EXCEPTION_TEXT);
        }
        this.m_type = TYPE_TEXTURE;
        this.setTextureURL(textureURL);
        this.m_primaryColor = taint;
        this.m_compositeAlpha = compositeAlpha;
    }

    public CompiereColor(Color lineColor, Color backColor, float lineWidth, int lineDistance) {
        if (lineColor == null || backColor == null) {
            new IllegalArgumentException(EXCEPTION_TEXT);
        }
        this.m_type = TYPE_LINES;
        this.m_primaryColor = backColor;
        this.m_secondaryColor = lineColor;
        this.m_lineWidth = lineWidth;
        this.m_lineDistance = lineDistance;
    }

    public CompiereColor(CompiereColor cc) {
        if (cc == null) {
            return;
        }
        this.setColor(cc);
    }

    public String getType() {
        return this.m_type;
    }

    public boolean isFlat() {
        return TYPE_FLAT.equals(this.getType());
    }

    public boolean isGradient() {
        return TYPE_GRADIENT.equals(this.getType());
    }

    public boolean isLine() {
        return TYPE_LINES.equals(this.getType());
    }

    public boolean isTexture() {
        return TYPE_TEXTURE.equals(this.getType());
    }

    public Color getFlatColor() {
        return this.m_primaryColor;
    }

    public void setFlatColor(Color color) {
        if (!this.isFlat() || color == null) {
            return;
        }
        this.m_primaryColor = color;
        this.m_dirty = true;
    }

    public Color getGradientUpperColor() {
        if (!this.isGradient()) {
            return null;
        }
        return this.m_primaryColor;
    }

    public void setGradientUpperColor(Color color) {
        if (!this.isGradient() || color == null) {
            return;
        }
        this.m_primaryColor = color;
        this.m_dirty = true;
    }

    public Color getGradientLowerColor() {
        if (!this.isGradient()) {
            return null;
        }
        return this.m_secondaryColor;
    }

    public void setGradientLowerColor(Color color) {
        if (!this.isGradient() || color == null) {
            return;
        }
        this.m_secondaryColor = color;
        this.m_dirty = true;
    }

    public int getGradientStartPoint() {
        if (!this.isGradient()) {
            return 0;
        }
        return this.m_startPoint;
    }

    public void setGradientStartPoint(int startPoint) {
        if (!this.isGradient()) {
            return;
        }
        this.m_startPoint = startPoint;
        this.m_dirty = true;
    }

    public int getGradientRepeatDistance() {
        if (!this.isGradient()) {
            return 0;
        }
        return this.m_repeatDistance;
    }

    public void setGradientRepeatDistance(int repeatDistance) {
        if (!this.isGradient()) {
            return;
        }
        this.m_repeatDistance = repeatDistance;
        this.m_dirty = true;
    }

    public void setGradientRepeatDistance(String repeatDistanceString) {
        if (!this.isGradient()) {
            return;
        }
        try {
            this.setGradientRepeatDistance(Integer.parseInt(repeatDistanceString));
        }
        catch (Exception e) {
            log.severe("Parsing=" + repeatDistanceString + " - " + e.getMessage());
        }
    }

    public URL getTextureURL() {
        if (!this.isTexture()) {
            return null;
        }
        if (this.m_textureURL == null) {
            this.m_textureURL = CompiereColor.class.getResource("Adempiere00x100.gif");
        }
        return this.m_textureURL;
    }

    public BufferedImage getTextureImage() {
        if (this.m_image == null) {
            URL url = this.getTextureURL();
            this.m_image = CompiereUtils.loadBufferedImage(url, 3);
        }
        return this.m_image;
    }

    public void setTextureURL(URL url) {
        if (!this.isTexture() || url == null) {
            return;
        }
        this.m_textureURL = url;
        this.m_image = null;
        this.m_dirty = true;
    }

    public void setTextureURL(String urlString) {
        if (!this.isTexture() || urlString == null) {
            return;
        }
        try {
            this.setTextureURL(new URL(urlString));
        }
        catch (Exception e) {
            log.severe("Parsing URL=" + urlString + " - " + e.getMessage());
        }
    }

    public Color getTextureTaintColor() {
        if (!this.isTexture()) {
            return null;
        }
        return this.m_primaryColor;
    }

    public void setTextureTaintColor(Color color) {
        if (!this.isTexture() || color == null) {
            return;
        }
        this.m_primaryColor = color;
        this.m_dirty = true;
    }

    public float getTextureCompositeAlpha() {
        if (!this.isTexture()) {
            return 0.0f;
        }
        return this.m_compositeAlpha;
    }

    public void setTextureCompositeAlpha(float alpha) {
        if (!this.isTexture()) {
            return;
        }
        this.m_compositeAlpha = alpha;
        this.m_dirty = true;
    }

    public void setTextureCompositeAlpha(String alphaString) {
        if (!this.isTexture() || alphaString == null) {
            return;
        }
        try {
            this.setTextureCompositeAlpha(Float.parseFloat(alphaString));
        }
        catch (Exception e) {
            log.severe("Parsing=" + alphaString + " - " + e.getMessage());
        }
    }

    public Color getLineColor() {
        if (!this.isLine()) {
            return null;
        }
        return this.m_secondaryColor;
    }

    public void setLineColor(Color color) {
        if (!this.isLine() || color == null) {
            return;
        }
        this.m_secondaryColor = color;
        this.m_dirty = true;
    }

    public Color getLineBackColor() {
        if (!this.isLine()) {
            return null;
        }
        return this.m_primaryColor;
    }

    public void setLineBackColor(Color color) {
        if (!this.isLine() || color == null) {
            return;
        }
        this.m_primaryColor = color;
        this.m_dirty = true;
    }

    public float getLineWidth() {
        if (!this.isLine()) {
            return 0.0f;
        }
        return this.m_lineWidth;
    }

    public void setLineWidth(float width) {
        if (!this.isLine()) {
            return;
        }
        this.m_lineWidth = width;
        this.m_dirty = true;
    }

    public void setLineWidth(String widthString) {
        if (!this.isLine() || widthString == null) {
            return;
        }
        try {
            this.setLineWidth(Float.parseFloat(widthString));
        }
        catch (Exception e) {
            log.severe("Parsing=" + widthString + " - " + e.getMessage());
        }
    }

    public int getLineDistance() {
        if (!this.isLine()) {
            return 0;
        }
        return this.m_lineDistance;
    }

    public void setLineDistance(int distance) {
        if (!this.isLine()) {
            return;
        }
        this.m_lineDistance = distance;
        this.m_dirty = true;
    }

    public void setLineDistance(String distanceString) {
        if (!this.isLine()) {
            return;
        }
        try {
            this.setLineDistance(Integer.parseInt(distanceString));
        }
        catch (Exception e) {
            log.severe("Parsing=" + distanceString + " - " + e.getMessage());
        }
    }

    protected void setPrimaryColor(Color color) {
        if (color != null) {
            this.m_primaryColor = color;
        }
    }

    public void setColor(CompiereColor cc) {
        if (cc == null) {
            return;
        }
        this.m_type = cc.getType();
        if (cc.isFlat()) {
            this.m_primaryColor = cc.getFlatColor();
        } else if (cc.isGradient()) {
            this.m_primaryColor = cc.getGradientUpperColor();
            this.m_secondaryColor = cc.getGradientLowerColor();
            this.m_startPoint = cc.getGradientStartPoint();
            this.m_repeatDistance = cc.getGradientRepeatDistance();
        } else if (cc.isTexture()) {
            this.setTextureURL(cc.getTextureURL());
            this.m_primaryColor = cc.getTextureTaintColor();
            this.m_compositeAlpha = cc.getTextureCompositeAlpha();
        } else if (cc.isLine()) {
            this.m_primaryColor = cc.getLineBackColor();
            this.m_secondaryColor = cc.getLineColor();
            this.m_lineWidth = cc.getLineWidth();
            this.m_lineDistance = cc.getLineDistance();
        } else {
            log.severe("Invalid Color");
        }
        this.m_dirty = true;
    }

    public void paint(Graphics g, JComponent c) {
        this.getColorBackground(c).paint(g, c);
    }

    public void paintRect(Graphics g, JComponent c, int x, int y, int w, int h) {
        this.getColorBackground(c).paintRect(g, c, x, y, w, h);
    }

    private ColorBackground getColorBackground(JComponent c) {
        if (this.m_back == null) {
            Rectangle bounds = c.getBounds();
            for (Container container = c.getParent(); container != null; container = container.getParent()) {
                bounds = container.getBounds(bounds);
            }
            this.m_back = new ColorBackground(bounds);
        }
        return this.m_back;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AdempiereColor[");
        if (this.isFlat()) {
            sb.append("Flat").append(" ").append(ThemeUtils.getColorAsString(this.getFlatColor()));
        } else if (this.isGradient()) {
            sb.append("Gradient").append(" Upper=").append(ThemeUtils.getColorAsString(this.getGradientUpperColor())).append(",Lower=").append(ThemeUtils.getColorAsString(this.getGradientLowerColor())).append(",Start=").append(this.getGradientStartPoint()).append(",RDistance=").append(this.getGradientRepeatDistance());
        } else if (this.isLine()) {
            sb.append("Line").append(" Color=").append(ThemeUtils.getColorAsString(this.getLineColor())).append(",BackColor=").append(ThemeUtils.getColorAsString(this.getLineBackColor())).append(",Width=").append(this.getLineWidth()).append(",Distance=").append(this.getLineDistance());
        } else if (this.isTexture()) {
            sb.append("Texture").append(" GraphURL=").append(this.getTextureURL()).append(",Taint=").append(ThemeUtils.getColorAsString(this.getTextureTaintColor())).append(",Alpha=").append(this.getTextureCompositeAlpha());
        }
        sb.append("]");
        return sb.toString();
    }

    private void parseAttributres(String str) {
        if (str.indexOf("[Flat ") != -1) {
            this.m_type = TYPE_FLAT;
            this.m_primaryColor = ThemeUtils.parseColor(str, new ColorUIResource(this.m_primaryColor));
        } else if (str.indexOf("[Gradient ") != -1) {
            this.m_type = TYPE_GRADIENT;
            this.m_primaryColor = ThemeUtils.parseColor(str.substring(str.indexOf(" Upper=") + 7, str.indexOf(",Lower=")), new ColorUIResource(this.m_primaryColor));
            this.m_secondaryColor = ThemeUtils.parseColor(str.substring(str.indexOf(",Lower=") + 7, str.indexOf(",Start=")), new ColorUIResource(this.m_secondaryColor));
            this.m_startPoint = Integer.parseInt(str.substring(str.indexOf(",Start=") + 7, str.indexOf(",RDistance=")));
            this.setGradientRepeatDistance(str.substring(str.indexOf(",RDistance=") + 11, str.lastIndexOf("]")));
        } else if (str.indexOf("[Line ") != -1) {
            this.m_type = TYPE_LINES;
            this.m_primaryColor = ThemeUtils.parseColor(str.substring(str.indexOf(" Color=") + 7, str.indexOf(",BackColor=")), new ColorUIResource(this.m_primaryColor));
            this.m_secondaryColor = ThemeUtils.parseColor(str.substring(str.indexOf(",BackColor=") + 11, str.indexOf(",Width=")), new ColorUIResource(this.m_secondaryColor));
            this.setLineWidth(str.substring(str.indexOf(",Width=") + 7, str.indexOf(",Distance=")));
            this.setLineDistance(str.substring(str.indexOf(",Distance=") + 10, str.lastIndexOf("]")));
        } else if (str.indexOf("[Texture ") != -1) {
            this.m_type = TYPE_TEXTURE;
            this.setTextureURL(str.substring(str.indexOf(" GraphURL=") + 10, str.indexOf(",Taint=")));
            this.m_primaryColor = ThemeUtils.parseColor(str.substring(str.indexOf(",Taint=") + 7, str.indexOf(",Alpha=")), new ColorUIResource(this.m_primaryColor));
            this.setTextureCompositeAlpha(str.substring(str.indexOf(",Alpha=") + 7, str.lastIndexOf("]")));
        }
    }

    boolean isDirty() {
        return this.m_dirty;
    }

    void setDirty(boolean dirty) {
        this.m_dirty = dirty;
    }

    public class ColorBackground {
        private int m_height = 200;
        private int m_width = 200;
        private BufferedImage m_backImage;
        private int m_colorBlind = ColorBlind.getColorType();

        public ColorBackground(Rectangle bounds) {
            this.createColorBackground(bounds);
            this.fillColorBackground();
        }

        private void createColorBackground(Rectangle bounds) {
            this.m_height = Math.max(bounds.y + bounds.height, this.m_height);
            this.m_width = Math.max(bounds.x + bounds.width, this.m_width);
            this.m_backImage = new BufferedImage(this.m_width, this.m_height, 3);
        }

        public void fillColorBackground() {
            Graphics2D g2D = this.m_backImage.createGraphics();
            if (CompiereColor.this.isGradient()) {
                Point start = null;
                Point end = null;
                int r = 1;
                switch (CompiereColor.this.m_startPoint) {
                    case 8: {
                        start = new Point(0, 0);
                        if (CompiereColor.this.m_repeatDistance > 0) {
                            end = new Point(CompiereColor.this.m_repeatDistance, CompiereColor.this.m_repeatDistance);
                            break;
                        }
                        end = new Point(this.m_width / r, this.m_height / r);
                        break;
                    }
                    case 7: {
                        start = new Point(0, this.m_height / 2);
                        if (CompiereColor.this.m_repeatDistance > 0) {
                            end = new Point(CompiereColor.this.m_repeatDistance, this.m_height / 2);
                            break;
                        }
                        end = new Point(this.m_width / r, this.m_height / 2);
                        break;
                    }
                    case 6: {
                        start = new Point(0, this.m_height);
                        if (CompiereColor.this.m_repeatDistance > 0) {
                            end = new Point(CompiereColor.this.m_repeatDistance, this.m_height - CompiereColor.this.m_repeatDistance);
                            break;
                        }
                        end = new Point(this.m_width / r, this.m_height - this.m_height / r);
                        break;
                    }
                    case 5: {
                        start = new Point(0, this.m_height);
                        if (CompiereColor.this.m_repeatDistance > 0) {
                            end = new Point(0, this.m_height - CompiereColor.this.m_repeatDistance);
                            break;
                        }
                        end = new Point(0, this.m_height - this.m_height / r);
                        break;
                    }
                    case 4: {
                        start = new Point(this.m_width, this.m_height);
                        if (CompiereColor.this.m_repeatDistance > 0) {
                            end = new Point(this.m_width - CompiereColor.this.m_repeatDistance, this.m_height - CompiereColor.this.m_repeatDistance);
                            break;
                        }
                        end = new Point(this.m_width - this.m_width / r, this.m_height - this.m_height / r);
                        break;
                    }
                    case 3: {
                        start = new Point(this.m_width, this.m_height / 2);
                        if (CompiereColor.this.m_repeatDistance > 0) {
                            end = new Point(this.m_width - CompiereColor.this.m_repeatDistance, this.m_height / 2);
                            break;
                        }
                        end = new Point(this.m_width - this.m_width / r, this.m_height / 2);
                        break;
                    }
                    case 2: {
                        start = new Point(this.m_width, 0);
                        if (CompiereColor.this.m_repeatDistance > 0) {
                            end = new Point(this.m_width - CompiereColor.this.m_repeatDistance, CompiereColor.this.m_repeatDistance);
                            break;
                        }
                        end = new Point(this.m_width - this.m_width / r, this.m_height / r);
                        break;
                    }
                    default: {
                        start = new Point(0, 0);
                        end = CompiereColor.this.m_repeatDistance > 0 ? new Point(0, CompiereColor.this.m_repeatDistance) : new Point(0, this.m_height / r);
                    }
                }
                GradientPaint paint = new GradientPaint(start, ColorBlind.getDichromatColor(CompiereColor.this.getGradientUpperColor()), end, ColorBlind.getDichromatColor(CompiereColor.this.getGradientLowerColor()), true);
                g2D.setPaint(paint);
                g2D.fillRect(0, 0, this.m_width, this.m_height);
            } else if (CompiereColor.this.isTexture()) {
                BufferedImage image = CompiereColor.this.getTextureImage();
                if (image == null) {
                    g2D.setPaint(ColorBlind.getDichromatColor(CompiereColor.this.getFlatColor()));
                    g2D.fillRect(0, 0, this.m_width, this.m_height);
                } else {
                    Rectangle anchor = new Rectangle(0, 0, image.getWidth(), image.getHeight());
                    TexturePaint texture = new TexturePaint(image, anchor);
                    g2D.setPaint(texture);
                    g2D.fillRect(0, 0, this.m_width, this.m_height);
                    g2D.setComposite(AlphaComposite.getInstance(3, CompiereColor.this.getTextureCompositeAlpha()));
                    g2D.setPaint(ColorBlind.getDichromatColor(CompiereColor.this.getTextureTaintColor()));
                    g2D.fillRect(0, 0, this.m_width, this.m_height);
                }
            } else if (CompiereColor.this.isLine()) {
                g2D.setPaint(ColorBlind.getDichromatColor(CompiereColor.this.getLineBackColor()));
                g2D.fillRect(0, 0, this.m_width, this.m_height);
                g2D.setPaint(ColorBlind.getDichromatColor(CompiereColor.this.getLineColor()));
                g2D.setStroke(new BasicStroke(CompiereColor.this.getLineWidth()));
                for (int y = 0; y < this.m_height; y += CompiereColor.this.getLineDistance()) {
                    g2D.drawLine(0, y, this.m_width, y);
                }
            } else {
                g2D.setPaint(ColorBlind.getDichromatColor(CompiereColor.this.getFlatColor()));
                g2D.fillRect(0, 0, this.m_width, this.m_height);
            }
            CompiereColor.this.setDirty(false);
        }

        public void paint(Graphics g, JComponent c) {
            Rectangle bounds = c.getBounds();
            this.check(bounds);
            int h = c.getHeight();
            int w = c.getWidth();
            g.drawImage(this.m_backImage, 0, 0, w, h, bounds.x, bounds.y, bounds.x + w, bounds.y + h, c);
        }

        public void paintRect(Graphics g, JComponent c, int x, int y, int w, int h) {
            Rectangle bounds = c.getBounds();
            this.check(bounds);
            g.drawImage(this.m_backImage, x, y, x + w, h + y, x, y, x + w, y + h, c);
        }

        private void check(Rectangle bounds) {
            if (ColorBlind.getColorType() != this.m_colorBlind) {
                this.m_colorBlind = ColorBlind.getColorType();
                CompiereColor.this.setDirty(true);
            }
            if (this.m_height < bounds.y + bounds.height || this.m_width < bounds.x + bounds.width) {
                this.createColorBackground(bounds);
                this.fillColorBackground();
            } else if (CompiereColor.this.isDirty()) {
                this.fillColorBackground();
            }
        }
    }
}

