/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MLocation;
import org.compiere.model.MTax;
import org.compiere.model.MTaxPostal;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class Tax {
    private static CLogger log = CLogger.getCLogger(Tax.class);

    public static int get(Properties ctx, int M_Product_ID, int C_Charge_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, boolean IsSOTrx) {
        if (M_Product_ID != 0) {
            return Tax.getProduct(ctx, M_Product_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, IsSOTrx);
        }
        if (C_Charge_ID != 0) {
            return Tax.getCharge(ctx, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, IsSOTrx);
        }
        return Tax.getExemptTax(ctx, AD_Org_ID);
    }

    public static int getCharge(Properties ctx, int C_Charge_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, boolean IsSOTrx) {
        if (M_Warehouse_ID == 0) {
            M_Warehouse_ID = Env.getContextAsInt(ctx, "M_Warehouse_ID");
        }
        if (M_Warehouse_ID == 0) {
            log.warning("No Warehouse - C_Charge_ID=" + C_Charge_ID);
            return 0;
        }
        String variable = "";
        int C_TaxCategory_ID = 0;
        int shipFromC_Location_ID = 0;
        int shipToC_Location_ID = 0;
        int billFromC_Location_ID = 0;
        int billToC_Location_ID = 0;
        String IsTaxExempt = null;
        String sql = "SELECT c.C_TaxCategory_ID, o.C_Location_ID, il.C_Location_ID, b.IsTaxExempt, w.C_Location_ID, sl.C_Location_ID FROM C_Charge c, AD_OrgInfo o, C_BPartner_Location il INNER JOIN C_BPartner b ON (il.C_BPartner_ID=b.C_BPartner_ID), M_Warehouse w, C_BPartner_Location sl WHERE c.C_Charge_ID=? AND o.AD_Org_ID=? AND il.C_BPartner_Location_ID=? AND w.M_Warehouse_ID=? AND sl.C_BPartner_Location_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_Charge_ID);
            pstmt.setInt(2, AD_Org_ID);
            pstmt.setInt(3, billC_BPartner_Location_ID);
            pstmt.setInt(4, M_Warehouse_ID);
            pstmt.setInt(5, shipC_BPartner_Location_ID);
            ResultSet rs = pstmt.executeQuery();
            boolean found = false;
            if (rs.next()) {
                C_TaxCategory_ID = rs.getInt(1);
                billFromC_Location_ID = rs.getInt(2);
                billToC_Location_ID = rs.getInt(3);
                IsTaxExempt = rs.getString(4);
                shipFromC_Location_ID = rs.getInt(5);
                shipToC_Location_ID = rs.getInt(6);
                found = true;
            }
            rs.close();
            pstmt.close();
            if (!found) {
                log.warning("Not found for C_Charge_ID=" + C_Charge_ID + ", AD_Org_ID=" + AD_Org_ID + ", M_Warehouse_ID=" + M_Warehouse_ID + ", C_BPartner_Location_ID=" + billC_BPartner_Location_ID + "/" + shipC_BPartner_Location_ID);
                return 0;
            }
            if ("Y".equals(IsTaxExempt)) {
                return Tax.getExemptTax(ctx, AD_Org_ID);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
            return 0;
        }
        if (!IsSOTrx) {
            int temp = billFromC_Location_ID;
            billFromC_Location_ID = billToC_Location_ID;
            billToC_Location_ID = temp;
            temp = shipFromC_Location_ID;
            shipFromC_Location_ID = shipToC_Location_ID;
            shipToC_Location_ID = temp;
        }
        log.fine("getCharge - C_TaxCategory_ID=" + C_TaxCategory_ID + ", billFromC_Location_ID=" + billFromC_Location_ID + ", billToC_Location_ID=" + billToC_Location_ID + ", shipFromC_Location_ID=" + shipFromC_Location_ID + ", shipToC_Location_ID=" + shipToC_Location_ID);
        return Tax.get(ctx, C_TaxCategory_ID, IsSOTrx, shipDate, shipFromC_Location_ID, shipToC_Location_ID, billDate, billFromC_Location_ID, billToC_Location_ID);
    }

    public static int getProduct(Properties ctx, int M_Product_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, boolean IsSOTrx) {
        String variable = "";
        int C_TaxCategory_ID = 0;
        int shipFromC_Location_ID = 0;
        int shipToC_Location_ID = 0;
        int billFromC_Location_ID = 0;
        int billToC_Location_ID = 0;
        String IsTaxExempt = null;
        try {
            int temp;
            String sql = "SELECT p.C_TaxCategory_ID, o.C_Location_ID, il.C_Location_ID, b.IsTaxExempt, w.C_Location_ID, sl.C_Location_ID FROM M_Product p, AD_OrgInfo o, C_BPartner_Location il INNER JOIN C_BPartner b ON (il.C_BPartner_ID=b.C_BPartner_ID), M_Warehouse w, C_BPartner_Location sl WHERE p.M_Product_ID=? AND o.AD_Org_ID=? AND il.C_BPartner_Location_ID=? AND w.M_Warehouse_ID=? AND sl.C_BPartner_Location_ID=?";
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setInt(2, AD_Org_ID);
            pstmt.setInt(3, billC_BPartner_Location_ID);
            pstmt.setInt(4, M_Warehouse_ID);
            pstmt.setInt(5, shipC_BPartner_Location_ID);
            ResultSet rs = pstmt.executeQuery();
            boolean found = false;
            if (rs.next()) {
                C_TaxCategory_ID = rs.getInt(1);
                billFromC_Location_ID = rs.getInt(2);
                billToC_Location_ID = rs.getInt(3);
                IsTaxExempt = rs.getString(4);
                shipFromC_Location_ID = rs.getInt(5);
                shipToC_Location_ID = rs.getInt(6);
                found = true;
            }
            rs.close();
            pstmt.close();
            if (found && "Y".equals(IsTaxExempt)) {
                log.fine("getProduct - Business Partner is Tax exempt");
                return Tax.getExemptTax(ctx, AD_Org_ID);
            }
            if (found) {
                if (!IsSOTrx) {
                    int temp2 = billFromC_Location_ID;
                    billFromC_Location_ID = billToC_Location_ID;
                    billToC_Location_ID = temp2;
                    temp2 = shipFromC_Location_ID;
                    shipFromC_Location_ID = shipToC_Location_ID;
                    shipToC_Location_ID = temp2;
                }
                log.fine("getProduct - C_TaxCategory_ID=" + C_TaxCategory_ID + ", billFromC_Location_ID=" + billFromC_Location_ID + ", billToC_Location_ID=" + billToC_Location_ID + ", shipFromC_Location_ID=" + shipFromC_Location_ID + ", shipToC_Location_ID=" + shipToC_Location_ID);
                return Tax.get(ctx, C_TaxCategory_ID, IsSOTrx, shipDate, shipFromC_Location_ID, shipToC_Location_ID, billDate, billFromC_Location_ID, billToC_Location_ID);
            }
            sql = "SELECT C_TaxCategory_ID FROM M_Product WHERE M_Product_ID=?";
            variable = "M_Product_ID";
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_Product_ID);
            rs = pstmt.executeQuery();
            found = false;
            if (rs.next()) {
                C_TaxCategory_ID = rs.getInt(1);
                found = true;
            }
            rs.close();
            pstmt.close();
            if (C_TaxCategory_ID == 0) {
                log.saveError("TaxCriteriaNotFound", Msg.translate(ctx, variable) + (found ? "" : " (Product=" + M_Product_ID + " not found)"));
                return 0;
            }
            log.fine("getProduct - C_TaxCategory_ID=" + C_TaxCategory_ID);
            sql = "SELECT C_Location_ID FROM AD_OrgInfo WHERE AD_Org_ID=?";
            variable = "AD_Org_ID";
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Org_ID);
            rs = pstmt.executeQuery();
            found = false;
            if (rs.next()) {
                billFromC_Location_ID = rs.getInt(1);
                found = true;
            }
            rs.close();
            pstmt.close();
            if (billFromC_Location_ID == 0) {
                log.saveError("TaxCriteriaNotFound", Msg.translate(Env.getAD_Language(ctx), variable) + (found ? "" : " (Info/Org=" + AD_Org_ID + " not found)"));
                return 0;
            }
            sql = "SELECT l.C_Location_ID, b.IsTaxExempt FROM C_BPartner_Location l INNER JOIN C_BPartner b ON (l.C_BPartner_ID=b.C_BPartner_ID) WHERE C_BPartner_Location_ID=?";
            variable = "BillTo_ID";
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, billC_BPartner_Location_ID);
            rs = pstmt.executeQuery();
            found = false;
            if (rs.next()) {
                billToC_Location_ID = rs.getInt(1);
                IsTaxExempt = rs.getString(2);
                found = true;
            }
            rs.close();
            pstmt.close();
            if (billToC_Location_ID == 0) {
                log.saveError("TaxCriteriaNotFound", Msg.translate(Env.getAD_Language(ctx), variable) + (found ? "" : " (BPLocation=" + billC_BPartner_Location_ID + " not found)"));
                return 0;
            }
            if ("Y".equals(IsTaxExempt)) {
                return Tax.getExemptTax(ctx, AD_Org_ID);
            }
            if (!IsSOTrx) {
                temp = billFromC_Location_ID;
                billFromC_Location_ID = billToC_Location_ID;
                billToC_Location_ID = temp;
            }
            log.fine("getProduct - billFromC_Location_ID = " + billFromC_Location_ID);
            log.fine("getProduct - billToC_Location_ID = " + billToC_Location_ID);
            sql = "SELECT C_Location_ID FROM M_Warehouse WHERE M_Warehouse_ID=?";
            variable = "M_Warehouse_ID";
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_Warehouse_ID);
            rs = pstmt.executeQuery();
            found = false;
            if (rs.next()) {
                shipFromC_Location_ID = rs.getInt(1);
                found = true;
            }
            rs.close();
            pstmt.close();
            if (shipFromC_Location_ID == 0) {
                log.saveError("TaxCriteriaNotFound", Msg.translate(Env.getAD_Language(ctx), variable) + (found ? "" : " (Warehouse=" + M_Warehouse_ID + " not found)"));
                return 0;
            }
            sql = "SELECT C_Location_ID FROM C_BPartner_Location WHERE C_BPartner_Location_ID=?";
            variable = "C_BPartner_Location_ID";
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, shipC_BPartner_Location_ID);
            rs = pstmt.executeQuery();
            found = false;
            if (rs.next()) {
                shipToC_Location_ID = rs.getInt(1);
                found = true;
            }
            rs.close();
            pstmt.close();
            if (shipToC_Location_ID == 0) {
                log.saveError("TaxCriteriaNotFound", Msg.translate(Env.getAD_Language(ctx), variable) + (found ? "" : " (BPLocation=" + shipC_BPartner_Location_ID + " not found)"));
                return 0;
            }
            if (!IsSOTrx) {
                temp = shipFromC_Location_ID;
                shipFromC_Location_ID = shipToC_Location_ID;
                shipToC_Location_ID = temp;
            }
            log.fine("getProduct - shipFromC_Location_ID = " + shipFromC_Location_ID);
            log.fine("getProduct - shipToC_Location_ID = " + shipToC_Location_ID);
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "getProduct (" + variable + ")", e);
        }
        return Tax.get(ctx, C_TaxCategory_ID, IsSOTrx, shipDate, shipFromC_Location_ID, shipToC_Location_ID, billDate, billFromC_Location_ID, billToC_Location_ID);
    }

    private static int getExemptTax(Properties ctx, int AD_Org_ID) {
        int C_Tax_ID = 0;
        String sql = "SELECT t.C_Tax_ID FROM C_Tax t INNER JOIN AD_Org o ON (t.AD_Client_ID=o.AD_Client_ID) WHERE t.IsTaxExempt='Y' AND o.AD_Org_ID=? ORDER BY t.Rate DESC";
        boolean found = false;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Org_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                C_Tax_ID = rs.getInt(1);
                found = true;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "getExemptTax", e);
        }
        log.fine("getExemptTax - TaxExempt=Y - C_Tax_ID=" + C_Tax_ID);
        if (C_Tax_ID == 0) {
            log.saveError("TaxCriteriaNotFound", Msg.getMsg(ctx, "TaxNoExemptFound") + (found ? "" : " (Tax/Org=" + AD_Org_ID + " not found)"));
        }
        return C_Tax_ID;
    }

    protected static int get(Properties ctx, int C_TaxCategory_ID, boolean IsSOTrx, Timestamp shipDate, int shipFromC_Locction_ID, int shipToC_Location_ID, Timestamp billDate, int billFromC_Location_ID, int billToC_Location_ID) {
        MTax tax;
        int i2;
        if (CLogMgt.isLevelFine()) {
            log.info("get(Detail) - Category=" + C_TaxCategory_ID + ", SOTrx=" + IsSOTrx);
            log.config("get(Detail) - BillFrom=" + billFromC_Location_ID + ", BillTo=" + billToC_Location_ID + ", BillDate=" + billDate);
        }
        MTax[] taxes = MTax.getAll(ctx);
        MLocation lFrom = new MLocation(ctx, billFromC_Location_ID, null);
        MLocation lTo = new MLocation(ctx, billToC_Location_ID, null);
        log.finer("From=" + lFrom);
        log.finer("To=" + lTo);
        for (i2 = 0; i2 < taxes.length; ++i2) {
            tax = taxes[i2];
            log.finest(tax.toString());
            if (tax.getC_TaxCategory_ID() != C_TaxCategory_ID || !tax.isActive() || tax.getParent_Tax_ID() != 0 || IsSOTrx && "P".equals(tax.getSOPOType()) || !IsSOTrx && "S".equals(tax.getSOPOType())) continue;
            log.finest("From Country - " + (tax.getC_Country_ID() == lFrom.getC_Country_ID() || tax.getC_Country_ID() == 0));
            log.finest("From Region - " + (tax.getC_Region_ID() == lFrom.getC_Region_ID() || tax.getC_Region_ID() == 0));
            log.finest("To Country - " + (tax.getTo_Country_ID() == lTo.getC_Country_ID() || tax.getTo_Country_ID() == 0));
            log.finest("To Region - " + (tax.getTo_Region_ID() == lTo.getC_Region_ID() || tax.getTo_Region_ID() == 0));
            log.finest("Date valid - " + !tax.getValidFrom().after(billDate));
            if (tax.getC_Country_ID() != lFrom.getC_Country_ID() && tax.getC_Country_ID() != 0 || tax.getC_Region_ID() != lFrom.getC_Region_ID() && tax.getC_Region_ID() != 0 || tax.getTo_Country_ID() != lTo.getC_Country_ID() && tax.getTo_Country_ID() != 0 || tax.getTo_Region_ID() != lTo.getC_Region_ID() && tax.getTo_Region_ID() != 0 || tax.getValidFrom().after(billDate)) continue;
            if (!tax.isPostal()) {
                return tax.getC_Tax_ID();
            }
            MTaxPostal[] postals = tax.getPostals(false);
            for (int j = 0; j < postals.length; ++j) {
                MTaxPostal postal = postals[j];
                if (!postal.isActive() || !postal.getPostal().startsWith(lFrom.getPostal()) || postal.getPostal_To() != null && !postal.getPostal_To().startsWith(lTo.getPostal())) continue;
                return tax.getC_Tax_ID();
            }
        }
        for (i2 = 0; i2 < taxes.length; ++i2) {
            tax = taxes[i2];
            if (!tax.isDefault() || !tax.isActive() || tax.getParent_Tax_ID() != 0 || IsSOTrx && "P".equals(tax.getSOPOType()) || !IsSOTrx && "S".equals(tax.getSOPOType())) continue;
            log.fine("get (default) - " + tax);
            return tax.getC_Tax_ID();
        }
        log.saveError("TaxNotFound", "");
        return 0;
    }
}

