/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAssignmentSlot;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MRole;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleUtil {
    private Properties m_ctx;
    private int m_S_Resource_ID;
    private boolean m_isAvailable = true;
    private boolean m_isSingleAssignment = true;
    private int m_S_ResourceType_ID = 0;
    private int m_C_UOM_ID = 0;
    private Timestamp m_startDate = null;
    private Timestamp m_endDate = null;
    private String m_typeName = null;
    private Timestamp m_slotStartTime = null;
    private Timestamp m_slotEndTime = null;
    private MAssignmentSlot[] m_timeSlots = null;
    public static final Timestamp EARLIEST = new Timestamp(new GregorianCalendar(1970, 1, 1).getTimeInMillis());
    public static final Timestamp LATEST = new Timestamp(new GregorianCalendar(2070, 12, 31).getTimeInMillis());
    private static CLogger log = CLogger.getCLogger(ScheduleUtil.class);

    public ScheduleUtil(Properties ctx) {
        this.m_ctx = ctx;
    }

    public MAssignmentSlot[] getAssignmentSlots(int S_Resource_ID, Timestamp start_Date, Timestamp end_Date, BigDecimal qty, boolean getAll, String trxName) {
        ResultSet rs;
        CPreparedStatement pstmt;
        log.config(start_Date.toString());
        if (this.m_S_Resource_ID != S_Resource_ID) {
            this.getBaseInfo(S_Resource_ID);
        }
        ArrayList<MAssignmentSlot> list = new ArrayList<MAssignmentSlot>();
        MAssignmentSlot ma = null;
        if (!this.m_isAvailable) {
            ma = new MAssignmentSlot(EARLIEST, LATEST, Msg.getMsg(this.m_ctx, "ResourceNotAvailable"), "", 0);
            if (!getAll) {
                return new MAssignmentSlot[]{ma};
            }
            list.add(ma);
        }
        this.m_startDate = start_Date;
        this.m_endDate = end_Date;
        if (this.m_endDate == null) {
            this.m_endDate = MUOMConversion.getEndDate(this.m_ctx, this.m_startDate, this.m_C_UOM_ID, qty);
        }
        log.fine("- EndDate=" + this.m_endDate);
        String sql = "SELECT Description, DateFrom, DateTo FROM S_ResourceUnavailable WHERE S_Resource_ID=? AND DateTo >= ? AND DateFrom <= ? AND IsActive='Y'";
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, this.m_S_Resource_ID);
            pstmt.setTimestamp(2, this.m_startDate);
            pstmt.setTimestamp(3, this.m_endDate);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ma = new MAssignmentSlot(TimeUtil.getDay(rs.getTimestamp(2)), TimeUtil.getNextDay(rs.getTimestamp(3)), Msg.getMsg(this.m_ctx, "ResourceUnAvailable"), rs.getString(1), 11);
                if (getAll) {
                    this.createDaySlot(list, ma);
                    continue;
                }
                list.add(ma);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
            ma = new MAssignmentSlot(EARLIEST, LATEST, Msg.getMsg(this.m_ctx, "ResourceUnAvailable"), e.toString(), 11);
        }
        if (ma != null && !getAll) {
            return new MAssignmentSlot[]{ma};
        }
        sql = MRole.getDefault(this.m_ctx, false).addAccessSQL("SELECT Name, Date1 FROM C_NonBusinessDay WHERE TRUNC(Date1) BETWEEN ? AND ?", "C_NonBusinessDay", false, false);
        try {
            Timestamp startDay = TimeUtil.getDay(this.m_startDate);
            Timestamp endDay = TimeUtil.getDay(this.m_endDate);
            CPreparedStatement pstmt2 = DB.prepareStatement(sql, trxName);
            pstmt2.setTimestamp(1, startDay);
            pstmt2.setTimestamp(2, endDay);
            ResultSet rs2 = pstmt2.executeQuery();
            while (rs2.next()) {
                ma = new MAssignmentSlot(TimeUtil.getDay(rs2.getTimestamp(2)), TimeUtil.getNextDay(rs2.getTimestamp(2)), Msg.getMsg(this.m_ctx, "NonBusinessDay"), rs2.getString(1), 12);
                log.finer("- NonBusinessDay " + ma);
                list.add(ma);
            }
            rs2.close();
            pstmt2.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
            ma = new MAssignmentSlot(EARLIEST, LATEST, Msg.getMsg(this.m_ctx, "NonBusinessDay"), e.toString(), 12);
        }
        if (ma != null && !getAll) {
            return new MAssignmentSlot[]{ma};
        }
        sql = "SELECT Name, IsTimeSlot,TimeSlotStart,TimeSlotEnd, IsDateSlot,OnMonday,OnTuesday,OnWednesday,OnThursday,OnFriday,OnSaturday,OnSunday FROM S_ResourceType WHERE S_ResourceType_ID=?";
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, this.m_S_ResourceType_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_typeName = rs.getString(1);
                if ("Y".equals(rs.getString(2))) {
                    this.m_slotStartTime = TimeUtil.getDayTime(this.m_startDate, rs.getTimestamp(3));
                    this.m_slotEndTime = TimeUtil.getDayTime(this.m_endDate, rs.getTimestamp(4));
                    if (TimeUtil.inRange(this.m_startDate, this.m_endDate, this.m_slotStartTime, this.m_slotEndTime)) {
                        ma = new MAssignmentSlot(this.m_slotStartTime, this.m_slotEndTime, Msg.getMsg(this.m_ctx, "ResourceNotInSlotTime"), this.m_typeName, 22);
                        if (getAll) {
                            this.createTimeSlot(list, rs.getTimestamp(3), rs.getTimestamp(4));
                        }
                    }
                }
                if ("Y".equals(rs.getString(5)) && TimeUtil.inRange(this.m_startDate, this.m_endDate, "Y".equals(rs.getString(6)), "Y".equals(rs.getString(7)), "Y".equals(rs.getString(8)), "Y".equals(rs.getString(9)), "Y".equals(rs.getString(10)), "Y".equals(rs.getString(11)), "Y".equals(rs.getString(12)))) {
                    ma = new MAssignmentSlot(this.m_startDate, this.m_endDate, Msg.getMsg(this.m_ctx, "ResourceNotInSlotDay"), this.m_typeName, 21);
                    if (getAll) {
                        this.createDaySlot(list, "Y".equals(rs.getString(6)), "Y".equals(rs.getString(7)), "Y".equals(rs.getString(8)), "Y".equals(rs.getString(9)), "Y".equals(rs.getString(10)), "Y".equals(rs.getString(11)), "Y".equals(rs.getString(12)));
                    }
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
            ma = new MAssignmentSlot(EARLIEST, LATEST, Msg.getMsg(this.m_ctx, "ResourceNotInSlotDay"), e.toString(), 12);
        }
        if (ma != null && !getAll) {
            return new MAssignmentSlot[]{ma};
        }
        sql = "SELECT S_ResourceAssignment_ID FROM S_ResourceAssignment WHERE S_Resource_ID=? AND AssignDateTo >= ? AND AssignDateFrom <= ? AND IsActive='Y'";
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, this.m_S_Resource_ID);
            pstmt.setTimestamp(2, this.m_startDate);
            pstmt.setTimestamp(3, this.m_endDate);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MResourceAssignment mAssignment = new MResourceAssignment(Env.getCtx(), rs.getInt(1), trxName);
                ma = new MAssignmentSlot(mAssignment);
                if (!getAll) break;
                list.add(ma);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
            ma = new MAssignmentSlot(EARLIEST, LATEST, Msg.translate(this.m_ctx, "S_R"), e.toString(), 101);
        }
        if (ma != null && !getAll) {
            return new MAssignmentSlot[]{ma};
        }
        this.createTimeSlots();
        ArrayList<MAssignmentSlot> clean = new ArrayList<MAssignmentSlot>(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MAssignmentSlot mas = list.get(i2);
            if (!mas.getStartTime().equals(this.m_startDate) && !mas.getStartTime().after(this.m_startDate) || !mas.getEndTime().equals(this.m_endDate) && !mas.getEndTime().before(this.m_endDate)) continue;
            clean.add(mas);
        }
        MAssignmentSlot[] sorted = new MAssignmentSlot[clean.size()];
        clean.toArray(sorted);
        Arrays.sort(sorted, new MAssignmentSlot());
        list.clear();
        clean.clear();
        Timestamp sortedDay = null;
        for (int i3 = 0; i3 < sorted.length; ++i3) {
            if (sortedDay == null) {
                sortedDay = TimeUtil.getDay(sorted[i3].getStartTime());
            }
            if (sortedDay.equals(TimeUtil.getDay(sorted[i3].getStartTime()))) {
                list.add(sorted[i3]);
                continue;
            }
            this.layoutSlots(list, clean);
            list.clear();
            list.add(sorted[i3]);
            sortedDay = TimeUtil.getDay(sorted[i3].getStartTime());
        }
        this.layoutSlots(list, clean);
        MAssignmentSlot[] retValue = new MAssignmentSlot[clean.size()];
        clean.toArray(retValue);
        Arrays.sort(retValue, new MAssignmentSlot());
        return retValue;
    }

    private void layoutSlots(ArrayList<MAssignmentSlot> list, ArrayList<MAssignmentSlot> clean) {
        int y;
        MAssignmentSlot mas;
        int i2;
        int size = list.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            MAssignmentSlot mas2 = list.get(0);
            this.layoutY(mas2);
            clean.add(mas2);
            return;
        }
        boolean allDay = false;
        for (i2 = 0; !allDay && i2 < size; ++i2) {
            mas = list.get(i2);
            if (mas.getStatus() != 0 && mas.getStatus() != 11 && mas.getStatus() != 12 && mas.getStatus() != 21) continue;
            allDay = true;
        }
        if (allDay) {
            for (i2 = 0; i2 < list.size(); ++i2) {
                mas = list.get(i2);
                if (mas.getStatus() != 22) continue;
                list.remove(i2--);
            }
        }
        for (i2 = 0; i2 < list.size(); ++i2) {
            mas = list.get(i2);
            this.layoutY(mas);
            clean.add(mas);
        }
        int maxYslots = this.m_timeSlots.length;
        int[] xSlots = new int[maxYslots];
        for (int i3 = 0; i3 < list.size(); ++i3) {
            MAssignmentSlot mas3 = list.get(i3);
            y = mas3.getYStart();
            while (y < mas3.getYEnd()) {
                int n = y++;
                xSlots[n] = xSlots[n] + 1;
            }
        }
        int maxXslots = 0;
        for (int y2 = 0; y2 < xSlots.length; ++y2) {
            if (xSlots[y2] <= maxXslots) continue;
            maxXslots = xSlots[y2];
        }
        if (maxXslots < 2) {
            for (int i4 = 0; i4 < list.size(); ++i4) {
                MAssignmentSlot mas4 = list.get(i4);
                mas4.setX(0, 1);
            }
            return;
        }
        ArrayList[][] matrix = new ArrayList[maxXslots][maxYslots];
        for (y = 0; y < maxYslots; ++y) {
            ArrayList<MAssignmentSlot> xyList;
            matrix[0][y] = xyList = new ArrayList<MAssignmentSlot>();
            for (int i5 = 0; i5 < list.size(); ++i5) {
                MAssignmentSlot mas5 = list.get(i5);
                if (y < mas5.getYStart() || y > mas5.getYEnd()) continue;
                xyList.add(mas5);
            }
            for (int x = 1; x < maxXslots; ++x) {
                matrix[x][y] = new ArrayList();
            }
        }
        for (y = 0; y < maxYslots; ++y) {
            if (y > 0 && matrix[0][y].size() > 0) {
                for (int x = 1; x < maxXslots; ++x) {
                    if (matrix[x][y - 1].size() <= 0) continue;
                    Object above = matrix[x][y - 1].get(0);
                    for (int i6 = 0; i6 < matrix[x][y].size(); ++i6) {
                        if (!above.equals(matrix[0][y].get(i6))) continue;
                        matrix[x][y].add(matrix[0][y].get(i6));
                        matrix[0][y].remove(i6--);
                    }
                }
            }
            if (matrix[0][y].size() <= 1) continue;
            Object above = null;
            if (y > 0 && matrix[0][y - 1].size() > 0) {
                above = matrix[0][y - 1].get(0);
            }
            int i7 = 0;
            while (matrix[0][y].size() > 1) {
                Object move = matrix[0][y].get(i7);
                if (!move.equals(above)) {
                    for (int x = 1; move != null && x < maxXslots; ++x) {
                        if (matrix[x][y].size() != 0) continue;
                        matrix[x][y].add(move);
                        matrix[0][y].remove(i7--);
                        move = null;
                    }
                }
                ++i7;
            }
        }
        for (y = 0; y < maxYslots; ++y) {
            for (int x = 0; x < maxXslots; ++x) {
                if (matrix[x][y].size() <= 0) continue;
                MAssignmentSlot mas6 = (MAssignmentSlot)matrix[x][y].get(0);
                mas6.setX(x, xSlots[y]);
            }
        }
        matrix = null;
    }

    private void layoutY(MAssignmentSlot mas) {
        int timeSlotStart = this.getTimeSlotIndex(mas.getStartTime(), false);
        int timeSlotEnd = this.getTimeSlotIndex(mas.getEndTime(), true);
        if (TimeUtil.isAllDay(mas.getStartTime(), mas.getEndTime())) {
            timeSlotEnd = this.m_timeSlots.length - 1;
        }
        mas.setY(timeSlotStart, timeSlotEnd);
    }

    private int getTimeSlotIndex(Timestamp time, boolean endTime) {
        if (this.m_timeSlots.length <= 1) {
            return 0;
        }
        for (int i2 = 0; i2 < this.m_timeSlots.length; ++i2) {
            if (!this.m_timeSlots[i2].inSlot(time, endTime)) continue;
            return i2;
        }
        log.log(Level.SEVERE, "MSchedule.getTimeSlotIndex - did not find Slot for " + time + " end=" + endTime);
        return 0;
    }

    private void getBaseInfo(int S_Resource_ID) {
        String sql = MRole.getDefault(this.m_ctx, false).addAccessSQL("SELECT r.IsActive,r.IsAvailable,null,r.S_ResourceType_ID,rt.C_UOM_ID FROM S_Resource r, S_ResourceType rt WHERE r.S_Resource_ID=? AND r.S_ResourceType_ID=rt.S_ResourceType_ID", "r", true, false);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, S_Resource_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                if (!"Y".equals(rs.getString(1))) {
                    this.m_isAvailable = false;
                }
                if (this.m_isAvailable && !"Y".equals(rs.getString(2))) {
                    this.m_isAvailable = false;
                }
                this.m_isSingleAssignment = "Y".equals(rs.getString(3));
                this.m_S_ResourceType_ID = rs.getInt(4);
                this.m_C_UOM_ID = rs.getInt(5);
            } else {
                this.m_isAvailable = false;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
            this.m_isAvailable = false;
        }
        this.m_S_Resource_ID = S_Resource_ID;
    }

    private void createTimeSlot(ArrayList<MAssignmentSlot> list, Timestamp startTime, Timestamp endTime) {
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.setTimeInMillis(this.m_startDate.getTime());
        GregorianCalendar calEnd = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        calEnd.setTimeInMillis(this.m_endDate.getTime());
        while (cal.before(calEnd)) {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Timestamp start = new Timestamp(cal.getTimeInMillis());
            GregorianCalendar cal_1 = new GregorianCalendar(Language.getLoginLanguage().getLocale());
            cal_1.setTimeInMillis(startTime.getTime());
            cal.set(11, cal_1.get(11));
            cal.set(12, cal_1.get(12));
            cal.set(13, cal_1.get(13));
            Timestamp end = new Timestamp(cal.getTimeInMillis());
            MAssignmentSlot ma = new MAssignmentSlot(start, end, Msg.getMsg(this.m_ctx, "ResourceNotInSlotTime"), "", 22);
            list.add(ma);
            cal_1.setTimeInMillis(endTime.getTime());
            cal.set(11, cal_1.get(11));
            cal.set(12, cal_1.get(12));
            cal.set(13, cal_1.get(13));
            start = new Timestamp(cal.getTimeInMillis());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.add(6, 1);
            end = new Timestamp(cal.getTimeInMillis());
            ma = new MAssignmentSlot(start, end, Msg.getMsg(this.m_ctx, "ResourceNotInSlotTime"), "", 22);
            list.add(ma);
        }
    }

    private void createDaySlot(ArrayList<MAssignmentSlot> list, boolean OnMonday, boolean OnTuesday, boolean OnWednesday, boolean OnThursday, boolean OnFriday, boolean OnSaturday, boolean OnSunday) {
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.setTimeInMillis(this.m_startDate.getTime());
        GregorianCalendar calEnd = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        calEnd.setTimeInMillis(this.m_endDate.getTime());
        while (cal.before(calEnd)) {
            int weekday = cal.get(7);
            if (!OnSaturday && weekday == 7 || !OnSunday && weekday == 1 || !OnMonday && weekday == 2 || !OnTuesday && weekday == 3 || !OnWednesday && weekday == 4 || !OnThursday && weekday == 5 || !OnFriday && weekday == 6) {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                Timestamp start = new Timestamp(cal.getTimeInMillis());
                cal.add(6, 1);
                Timestamp end = new Timestamp(cal.getTimeInMillis());
                MAssignmentSlot ma = new MAssignmentSlot(start, end, Msg.getMsg(this.m_ctx, "ResourceNotInSlotDay"), "", 21);
                list.add(ma);
                continue;
            }
            cal.add(6, 1);
        }
    }

    private void createDaySlot(ArrayList<MAssignmentSlot> list, MAssignmentSlot ma) {
        Timestamp start = ma.getStartTime();
        GregorianCalendar calStart = new GregorianCalendar();
        calStart.setTime(start);
        calStart.set(11, 0);
        calStart.set(12, 0);
        calStart.set(13, 0);
        calStart.set(14, 0);
        Timestamp end = ma.getEndTime();
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.setTime(end);
        calEnd.set(11, 0);
        calEnd.set(12, 0);
        calEnd.set(13, 0);
        calEnd.set(14, 0);
        while (calStart.before(calEnd)) {
            Timestamp xStart = new Timestamp(calStart.getTimeInMillis());
            calStart.add(6, 1);
            Timestamp xEnd = new Timestamp(calStart.getTimeInMillis());
            MAssignmentSlot myMa = new MAssignmentSlot(xStart, xEnd, ma.getName(), ma.getDescription(), ma.getStatus());
            list.add(myMa);
        }
    }

    public MAssignmentSlot[] getDayTimeSlots() {
        return this.m_timeSlots;
    }

    private void createTimeSlots() {
        if (this.m_typeName == null) {
            throw new IllegalStateException("ResourceTypeName not set");
        }
        ArrayList<MAssignmentSlot> list = new ArrayList<MAssignmentSlot>();
        MUOM uom = MUOM.get(this.m_ctx, this.m_C_UOM_ID);
        int minutes = MUOMConversion.convertToMinutes(this.m_ctx, this.m_C_UOM_ID, Env.ONE);
        log.config("Minutes=" + minutes);
        if (minutes > 0 && minutes < 1440) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(this.m_startDate);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            if (this.m_slotStartTime != null) {
                long start = cal.getTimeInMillis();
                cal.setTime(TimeUtil.getDayTime(this.m_startDate, this.m_slotStartTime));
                cal.set(13, 0);
                cal.set(14, 0);
                list.add(new MAssignmentSlot(start, cal.getTimeInMillis()));
            }
            GregorianCalendar calEnd = new GregorianCalendar();
            if (this.m_slotEndTime != null) {
                calEnd.setTime(TimeUtil.getDayTime(this.m_startDate, this.m_slotEndTime));
                calEnd.set(13, 0);
                calEnd.set(14, 0);
            } else {
                calEnd.setTime(this.m_startDate);
                calEnd.set(11, 0);
                calEnd.set(12, 0);
                calEnd.set(13, 0);
                calEnd.set(14, 0);
                calEnd.add(6, 1);
            }
            GregorianCalendar calEndSlot = new GregorianCalendar();
            calEndSlot.setTime(cal.getTime());
            calEndSlot.add(12, minutes);
            while (cal.before(calEnd)) {
                list.add(new MAssignmentSlot(cal.getTimeInMillis(), calEndSlot.getTimeInMillis()));
                cal.add(12, minutes);
                calEndSlot.add(12, minutes);
            }
            calEndSlot.setTime(cal.getTime());
            calEndSlot.set(11, 0);
            calEndSlot.set(12, 0);
            calEndSlot.set(13, 0);
            calEndSlot.set(14, 0);
            calEndSlot.add(6, 1);
            list.add(new MAssignmentSlot(cal.getTimeInMillis(), calEndSlot.getTimeInMillis()));
        } else {
            list.add(new MAssignmentSlot(TimeUtil.getDay(this.m_startDate), TimeUtil.getNextDay(this.m_startDate)));
        }
        this.m_timeSlots = new MAssignmentSlot[list.size()];
        list.toArray(this.m_timeSlots);
    }

    public int getS_Resource_ID() {
        return this.m_S_Resource_ID;
    }

    public Timestamp getStartDate() {
        return this.m_startDate;
    }

    public Timestamp getEndDate() {
        return this.m_endDate;
    }
}

