/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentProcessor;
import org.compiere.util.CLogger;

public abstract class PaymentProcessor {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private static CLogger s_log = CLogger.getCLogger(PaymentProcessor.class);
    public static final String ENCODING = "UTF-8";
    private boolean m_encoded = false;
    public static final char AMP = '&';
    public static final char EQ = '=';
    protected MPaymentProcessor p_mpp = null;
    protected MPayment p_mp = null;
    private int m_timeout = 30;

    public static PaymentProcessor create(MPaymentProcessor mpp, MPayment mp) {
        s_log.info("create for " + mpp);
        String className = mpp.getPayProcessorClass();
        if (className == null || className.length() == 0) {
            s_log.log(Level.SEVERE, "No PaymentProcessor class name in " + mpp);
            return null;
        }
        PaymentProcessor myProcessor = null;
        try {
            Class<?> ppClass = Class.forName(className);
            if (ppClass != null) {
                myProcessor = (PaymentProcessor)ppClass.newInstance();
            }
        }
        catch (Error e1) {
            s_log.log(Level.SEVERE, className + " - Error=" + e1.getMessage());
            return null;
        }
        catch (Exception e2) {
            s_log.log(Level.SEVERE, className, e2);
            return null;
        }
        if (myProcessor == null) {
            s_log.log(Level.SEVERE, "no class");
            return null;
        }
        myProcessor.p_mpp = mpp;
        myProcessor.p_mp = mp;
        return myProcessor;
    }

    public abstract boolean processCC() throws IllegalArgumentException;

    public abstract boolean isProcessedOK();

    public void setTimeout(int newTimeout) {
        this.m_timeout = newTimeout;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    protected String createPair(String name, BigDecimal value, int maxLength) {
        if (value == null) {
            return this.createPair(name, "0", maxLength);
        }
        if (value.scale() < 2) {
            value = value.setScale(2, 4);
        }
        return this.createPair(name, String.valueOf(value), maxLength);
    }

    protected String createPair(String name, int value, int maxLength) {
        if (value == 0) {
            return "";
        }
        return this.createPair(name, String.valueOf(value), maxLength);
    }

    protected String createPair(String name, String value, int maxLength) {
        if (name == null || name.length() == 0 || value == null || value.length() == 0) {
            return "";
        }
        if (value.length() > maxLength) {
            value = value.substring(0, maxLength);
        }
        StringBuffer retValue = new StringBuffer(name);
        if (this.m_encoded) {
            try {
                value = URLEncoder.encode(value, ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                this.log.log(Level.SEVERE, value + " - " + e.toString());
            }
        } else if (value.indexOf(38) != -1 || value.indexOf(61) != -1) {
            retValue.append("[").append(value.length()).append("]");
        }
        retValue.append('=');
        retValue.append(value);
        return retValue.toString();
    }

    public void setEncoded(boolean doEncode) {
        this.m_encoded = doEncode;
    }

    public boolean isEncoded() {
        return this.m_encoded;
    }

    protected Properties getConnectPostProperties(String urlString, String parameter) {
        long start = System.currentTimeMillis();
        String result = this.connectPost(urlString, parameter);
        if (result == null) {
            return null;
        }
        Properties prop = new Properties();
        try {
            String info = URLDecoder.decode(result, ENCODING);
            StringTokenizer st = new StringTokenizer(info, "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int index = token.indexOf(61);
                if (index == -1) {
                    prop.put(token, "");
                    continue;
                }
                String key = token.substring(0, index);
                String value = token.substring(index + 1);
                prop.put(key, value);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, result, e);
        }
        long ms = System.currentTimeMillis() - start;
        this.log.fine(ms + "ms - " + prop.toString());
        return prop;
    }

    protected String connectPost(String urlString, String parameter) {
        String response = null;
        try {
            URL url = new URL(urlString);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            this.log.fine(connection.getURL().toString());
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.write(parameter.getBytes());
            out.flush();
            out.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            response = in.readLine();
            in.close();
            this.log.finest(response);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, urlString, e);
        }
        return response;
    }
}

