/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.beans.VetoableChangeSupport;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModelValidationEngine {
    private static ModelValidationEngine s_engine = null;
    private static CLogger log = CLogger.getCLogger(ModelValidationEngine.class);
    private VetoableChangeSupport m_changeSupport = new VetoableChangeSupport(this);
    private ArrayList<ModelValidator> m_validators = new ArrayList();
    private Hashtable<String, ArrayList<ModelValidator>> m_modelChangeListeners = new Hashtable();
    private Hashtable<String, ArrayList<ModelValidator>> m_docValidateListeners = new Hashtable();

    public static ModelValidationEngine get() {
        if (s_engine == null) {
            s_engine = new ModelValidationEngine();
        }
        return s_engine;
    }

    private ModelValidationEngine() {
        MClient[] clients = MClient.getAll(new Properties());
        for (int i2 = 0; i2 < clients.length; ++i2) {
            String classNames = clients[i2].getModelValidationClasses();
            if (classNames == null || classNames.length() == 0) continue;
            StringTokenizer st = new StringTokenizer(classNames, ";");
            while (st.hasMoreTokens()) {
                String className = null;
                try {
                    className = st.nextToken();
                    if (className == null || (className = className.trim()).length() == 0) continue;
                    Class<?> clazz = Class.forName(className);
                    ModelValidator validator = (ModelValidator)clazz.newInstance();
                    this.initialize(validator, clients[i2]);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, className + ": " + e.getMessage());
                }
            }
        }
        log.config(this.toString());
    }

    private void initialize(ModelValidator validator, MClient client) {
        validator.initialize(this, client);
        this.m_validators.add(validator);
    }

    public String loginComplete(int AD_Client_ID, int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        for (int i2 = 0; i2 < this.m_validators.size(); ++i2) {
            String error;
            ModelValidator validator = this.m_validators.get(i2);
            if (AD_Client_ID != validator.getAD_Client_ID() || (error = validator.login(AD_Org_ID, AD_Role_ID, AD_User_ID)) == null || error.length() <= 0) continue;
            return error;
        }
        return null;
    }

    public void addModelChange(String tableName, ModelValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = tableName + listener.getAD_Client_ID();
        ArrayList<ModelValidator> list = this.m_modelChangeListeners.get(propertyName);
        if (list == null) {
            list = new ArrayList();
            list.add(listener);
            this.m_modelChangeListeners.put(propertyName, list);
        } else {
            list.add(listener);
        }
    }

    public void removeModelChange(String tableName, ModelValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = tableName + listener.getAD_Client_ID();
        ArrayList<ModelValidator> list = this.m_modelChangeListeners.get(propertyName);
        if (list == null) {
            return;
        }
        list.remove(listener);
        if (list.size() == 0) {
            this.m_modelChangeListeners.remove(propertyName);
        }
    }

    public String fireModelChange(PO po, int type) {
        if (po == null || this.m_modelChangeListeners.size() == 0) {
            return null;
        }
        String propertyName = po.get_TableName() + po.getAD_Client_ID();
        ArrayList<ModelValidator> list = this.m_modelChangeListeners.get(propertyName);
        if (list == null) {
            return null;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String error;
            try {
                ModelValidator validator = list.get(i2);
                error = validator.modelChange(po, type);
                if (error == null || error.length() <= 0) continue;
                return error;
            }
            catch (Exception e) {
                error = e.getMessage();
                if (error == null) {
                    error = e.toString();
                }
                return error;
            }
        }
        return null;
    }

    public void addDocValidate(String tableName, ModelValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = tableName + listener.getAD_Client_ID();
        ArrayList<ModelValidator> list = this.m_docValidateListeners.get(propertyName);
        if (list == null) {
            list = new ArrayList();
            list.add(listener);
            this.m_docValidateListeners.put(propertyName, list);
        } else {
            list.add(listener);
        }
    }

    public void removeDocValidate(String tableName, ModelValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = tableName + listener.getAD_Client_ID();
        ArrayList<ModelValidator> list = this.m_docValidateListeners.get(propertyName);
        if (list == null) {
            return;
        }
        list.remove(listener);
        if (list.size() == 0) {
            this.m_docValidateListeners.remove(propertyName);
        }
    }

    public String fireDocValidate(PO po, int timing) {
        if (po == null || this.m_docValidateListeners.size() == 0) {
            return null;
        }
        String propertyName = po.get_TableName() + po.getAD_Client_ID();
        ArrayList<ModelValidator> list = this.m_docValidateListeners.get(propertyName);
        if (list == null) {
            return null;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ModelValidator validator = null;
            try {
                validator = list.get(i2);
                String error = validator.docValidate(po, timing);
                if (error == null || error.length() <= 0) continue;
                return error;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, validator.toString(), e);
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelValidationEngine[");
        sb.append("Validators=#").append(this.m_validators.size()).append(", ModelChange=#").append(this.m_modelChangeListeners.size()).append(", DocValidate=#").append(this.m_docValidateListeners.size()).append("]");
        return sb.toString();
    }
}

