/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Dimension;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MMenu;
import org.compiere.model.MRole;
import org.compiere.model.MTab;
import org.compiere.model.MWindowAccess;
import org.compiere.model.X_AD_WF_Node;
import org.compiere.model.X_AD_Window;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MWindow
extends X_AD_Window {
    private static CLogger s_log = CLogger.getCLogger(MWindow.class);
    private MTab[] m_tabs = null;

    public MWindow(Properties ctx, int AD_Window_ID, String trxName) {
        super(ctx, AD_Window_ID, trxName);
        if (AD_Window_ID == 0) {
            this.setWindowType("M");
            this.setEntityType("U");
            this.setIsBetaFunctionality(false);
            this.setIsDefault(false);
            this.setIsSOTrx(true);
        }
    }

    public MWindow(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setWindowSize(Dimension size) {
        if (size != null) {
            this.setWinWidth(size.width);
            this.setWinHeight(size.height);
        }
    }

    public MTab[] getTabs(boolean reload, String trxName) {
        if (this.m_tabs != null && !reload) {
            return this.m_tabs;
        }
        String sql = "SELECT * FROM AD_Tab WHERE AD_Window_ID=? ORDER BY SeqNo";
        ArrayList<MTab> list = new ArrayList<MTab>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, this.getAD_Window_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MTab(this.getCtx(), rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_tabs = new MTab[list.size()];
        list.toArray(this.m_tabs);
        return this.m_tabs;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        block6: {
            block5: {
                if (!newRecord) break block5;
                MRole[] roles = MRole.getOf(this.getCtx(), "IsManual='N'");
                for (int i2 = 0; i2 < roles.length; ++i2) {
                    MWindowAccess wa = new MWindowAccess(this, roles[i2].getAD_Role_ID());
                    wa.save();
                }
                break block6;
            }
            if (!this.is_ValueChanged("IsActive") && !this.is_ValueChanged("Name") && !this.is_ValueChanged("Description") && !this.is_ValueChanged("Help")) break block6;
            MMenu[] menues = MMenu.get(this.getCtx(), "AD_Window_ID=" + this.getAD_Window_ID());
            for (int i3 = 0; i3 < menues.length; ++i3) {
                menues[i3].setName(this.getName());
                menues[i3].setDescription(this.getDescription());
                menues[i3].setIsActive(this.isActive());
                menues[i3].save();
            }
            X_AD_WF_Node[] nodes = MWindow.getWFNodes(this.getCtx(), "AD_Window_ID=" + this.getAD_Window_ID());
            for (int i4 = 0; i4 < nodes.length; ++i4) {
                boolean changed = false;
                if (nodes[i4].isActive() != this.isActive()) {
                    nodes[i4].setIsActive(this.isActive());
                    changed = true;
                }
                if (nodes[i4].isCentrallyMaintained()) {
                    nodes[i4].setName(this.getName());
                    nodes[i4].setDescription(this.getDescription());
                    nodes[i4].setHelp(this.getHelp());
                    changed = true;
                }
                if (!changed) continue;
                nodes[i4].save();
            }
        }
        return success;
    }

    public static X_AD_WF_Node[] getWFNodes(Properties ctx, String whereClause) {
        String sql = "SELECT * FROM AD_WF_Node";
        if (whereClause != null && whereClause.length() > 0) {
            sql = sql + " WHERE " + whereClause;
        }
        ArrayList<X_AD_WF_Node> list = new ArrayList<X_AD_WF_Node>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new X_AD_WF_Node(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        X_AD_WF_Node[] retValue = new X_AD_WF_Node[list.size()];
        list.toArray(retValue);
        return retValue;
    }
}

